@extends('layouts.app')

@section('title') RO @endsection

@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            
            <div class="d-flex align-items-stretch justify-content-between mb-2">
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap mr-15">
                    <h4 class="d-inline-block mb-0 mr-3">Status : </h4>
                    <span class="label label-danger label-pill label-inline mr-2">New</span>
                    <span class="label label-info label-pill label-inline mr-2">Pending</span>
                    <span class="label label-success label-inline mr-2">Completed</span>
                    <span class="label label-warning label-inline mr-2">In process</span>
                </div>

                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
                    <a href="{{ route('admin.ro.create') }}" class="btn btn-light-primary font-weight-bolder"><i class="la la-plus"></i>Add</a>
                </div>
            </div>

            <div class="row">

                <div class="col-sm-12">
                    <!-- Datatable (JS in datatable-custom.js) -->
                    <table class="table table-bordered mt-15 table_po_list table-hover" id="po_list">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>RO #</th>
                                <th>RO Date</th>
                                <th>Vendor</th>
                                <th>Item Description</th>
                                <th>Qty</th>
                                <th>Unit</th>
                                <th>RF#</th>
                                <th>Requested</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>1</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-123456</a></td>
                                <td>03/09/2021</td>
                                <td>ABC Sdn Bhd</td>
                                <td>Item 1 description asdad asd as asd ad</td>
                                <td>128</td>
                                <td>Nos</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC28082021001</a></td>
                                <td>28/08/2021</td>
                            </tr>
                            <tr>
                                <td>2</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-123456</a></td>
                                <td>03/09/2021</td>
                                <td>ABC Sdn Bhd</td>
                                <td>Item 2 description asdad asd as asd ad</td>
                                <td>76</td>
                                <td>Kg</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC28082021001</a></td>
                                <td>28/08/2021</td>
                            </tr>
                            <tr>
                                <td>3</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-234567</a></td>
                                <td>28/07/2021</td>
                                <td>DEF Sdn Bhd</td>
                                <td>Item 8 description asdad asd as asd ad</td>
                                <td>15</td>
                                <td>M3</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC21072021008</a></td>
                                <td>21/07/2021</td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-345678</a></td>
                                <td>28/07/2021</td>
                                <td>GGG Sdn Bhd</td>
                                <td>Item 11 description asdad asd as asd ad</td>
                                <td>47</td>
                                <td>Kg</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC25072021003</a></td>
                                <td>25/07/2021</td>
                            </tr>
                            <tr>
                                <td>5</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-345678</a></td>
                                <td>28/07/2021</td>
                                <td>GGG Sdn Bhd</td>
                                <td>Item 11 description asdad asd as asd ad</td>
                                <td>58</td>
                                <td>Kg</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC05092021001</a></td>
                                <td>23/07/2021</td>
                            </tr>
                            <tr>
                                <td>6</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-456789</a></td>
                                <td>19/07/2021</td>
                                <td>ABC Sdn Bhd</td>
                                <td>Item 2 description asdad asd as asd ad</td>
                                <td>95</td>
                                <td>Kg</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC13072021009</a></td>
                                <td>13/07/2021</td>
                            </tr>
                            <tr>
                                <td>7</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-567890</a></td>
                                <td>15/07/2021</td>
                                <td>ABC Sdn Bhd</td>
                                <td>Item description asdad asd as asd ad</td>
                                <td>83</td>
                                <td>Nos</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10072021002</a></td>
                                <td>10/07/2021</td>
                            </tr>
                            <tr>
                                <td>8</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-678901</a></td>
                                <td>09/07/2021</td>
                                <td>XYZ Sdn Bhd</td>
                                <td>Item 7 description asdad asd as asd ad</td>
                                <td>36</td>
                                <td>M3</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC05072021005</a></td>
                                <td>05/07/2021</td>
                            </tr>
                            <tr>
                                <td>9</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-678901</a></td>
                                <td>09/07/2021</td>
                                <td>XYZ Sdn Bhd</td>
                                <td>Item 15 description asdad asd as asd ad</td>
                                <td>128</td>
                                <td>Nos</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC05092021001</a></td>
                                <td>05/07/2021</td>
                            </tr>
                            <tr>
                                <td>10</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-789012</a></td>
                                <td>01/07/2021</td>
                                <td>KKK Sdn Bhd</td>
                                <td>Item 2 description asdad asd as asd ad</td>
                                <td>128</td>
                                <td>Kg</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC28062021004</a></td>
                                <td>28/06/2021</td>
                            </tr>
                            <tr>
                                <td>11</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-890123</a></td>
                                <td>25/06/2021</td>
                                <td>WWW Sdn Bhd</td>
                                <td>Item 7 description asdad asd as asd ad</td>
                                <td>128</td>
                                <td>M3</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC23062021007</a></td>
                                <td>23/06/2021</td>
                            </tr>
                            <tr>
                                <td>12</td>
                                <td><a href="assets/document/po-sample.pdf" target="_blank">RO-890123</a></td>
                                <td>25/06/2021</td>
                                <td>WWW Sdn Bhd</td>
                                <td>Item 2 description asdad asd as asd ad</td>
                                <td>69</td>
                                <td>Kg</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC15062021002</a></td>
                                <td>15/06/2021</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Modal RF -->
            <div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h1>Requisition Form</h1>
                                    <h5>RF#: RF-AC28082021001</h5>
                                </div>
                                <div class="col-sm-6">
                                    <div class="address-box text-right">
                                        Arte Cheras,<br>
                                        No.2, Jalan Midah 2,<br>
                                        Taman Midah, Cheras,<br>
                                        56000 Kuala Lumpur<br>
                                        Tel: +6012-123 4567												
                                    </div>
                                    <div class="logo-box">
                                        <div class="logo-rf" style="background-image: url('assets/media/arte-cheras.png');"></div>
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-5 mb-5">

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="to-info">
                                        <strong>To:</strong><br>
                                        Headquarters<br>
                                        No.1, Jalan Wangsa Permai, 2nd Floor,<br>
                                        Bangunan One Wangsa, Taman Wangsa Permai,<br>
                                        Tel: +603-6277 2480<br>
                                        Fax: +603-6276 2482
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="request-info">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td>Request Date :</td>
                                                <td>28/08/2021</td>
                                            </tr>
                                            <tr>
                                                <td>Requested by :</td>
                                                <td>Janet Tan</td>
                                            </tr>
                                            <tr>
                                                <td>Contact # :</td>
                                                <td>017-330 5149</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <table class="table table-bordered table-rf mt-5">
                                        <tr>
                                            <th>#</th>
                                            <th>Item Description</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>Date Required</th>
                                            <th>Remarks</th>
                                        </tr>
                                        <tr>
                                            <td>1</td>
                                            <td>Item 1</td>
                                            <td>Nos</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>Item 2</td>
                                            <td>Kg</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1. This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>Item 3</td>
                                            <td>M3</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
</div>

    
@endsection