@php
    $page 	= Request::segment(4);
	$title	= "Create";
	
	if($page == "edit") {
		$title = "Edit";
	}
@endphp
@extends('layouts.app')

@section('title') PO |  {{$title}} @endsection

@section('content')

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">            
			<div class="row">
				<div class="col-sm-12">
					<h4>PO Details</h4>
					<form id="PoDetail" data-po-id="">
						<div class="form-group row">
							<div class="col-sm-6">
								<label class="col-form-label text-right mr-5">PO#:</label>
								<input id="po_no" type="text" class="form-control" placeholder="Fill in PO#" />
							</div>
							<div class="col-sm-6">
								<div class="col-sm-12">
									<label class="col-form-label text-right mr-5">PO Date:</label>
									<input type="text" class="form-control datepicker" id="kt_datepicker_4_1" data-date-format="dd-mm-yyyy" placeholder="Select PO Date" />
								</div>
							</div>
						</div>
						<div class="form-group row">
							<div class="col-sm-6">
								<label class="col-form-label text-right mr-5">Select Vendor:</label>
								<select id="SelectVendor" class="form-control selectpicker" data-live-search="true" data-size="3">											
									<option disabled selected>Vendor Company</option>						
									@foreach ($vendors as $vendor)
										<option data-tokens="{{ $vendor->company_name }}" value="{{ $vendor->id }}">{{ $vendor->company_name }} ({{ $vendor->company_no }})</option>
									@endforeach 
								</select>
							</div>
							<div class="col-sm-6">
								<div class="col-sm-12">
									<label class="col-form-label text-right mr-5">Upload PO file:</label>
									<div class="custom-file">
										<input type="file" class="custom-file-input" id="po_file"/>
										<label class="custom-file-label" for="po_file">Choose file</label>
									</div>
									<div class="img_preview mt-5"></div>
									<div class="doc_preview"></div>
								</div>								
							</div>
						</div>
					</form>
				</div>			
			</div>
			<hr>
			<div class="d-flex align-items-stretch justify-content-between mb-2">
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap mr-15 title">  
				@php if($page == "edit") { @endphp					
					<label style="font-size:20px; font-weight:400;">RF No: &nbsp;&nbsp;<a class="modal-links rf_no" data-toggle="modal" data-target="#requisition_form" data-id=""></a></label>
				@php } @endphp				
                </div>

                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">					
                    <a href="#" class="btn btn-primary font-weight-bolder btnAddNew" data-toggle="modal" data-target="#add_newPOItem"><i class="la la-plus"></i>Add</a>
                </div>
            </div>
            <div id="kt_repeater_2" data-rf-id="" data-rf-no="">
                <div class="form-group row mb-0">
                    <div class="col-sm-12">
					{{-- <input type="hidden" id="selectedRf" value="" /> --}}
                        <table class="table table-bordered table_rf_new_item new">
                            <tr>
                                <th style="width:5%;">#</th>
                                <th style="width:41%;">Item Name & Description</th>                                
                                <th style="width:9%;">Unit</th>
                                <th style="width:10%;">Qty</th>
                                {{-- <th>Date Required</th> --}}
                                <th style="width:30%;">Remarks </th>
                                <th style="width:5%;">Action</th>
                            </tr>
                            <tbody>
                                
                            </tbody>
                            {{-- <tbody data-repeater-list="">
                                <tr data-repeater-item="">
                                    <td></td>
                                    <td>
                                        <select class="form-control selectpicker" data-live-search="true" data-size="3">
                                        @foreach ($items as $item)
                                            <option value="{{ $item->id }}" data-tokens="item 1">{{ $item->name }}</option>
                                        @endforeach                                
                                        </select>
                                    </td>
                                    <td><input type="text" class="form-control" placeholder="Unit" /></td>
                                    <td><input type="number" class="form-control" placeholder="Qty" min="0" /></td>
                                    <td><input type="text" class="form-control" id="kt_datepicker_1" placeholder="Select Date" /></td>
                                    <td><input type="text" class="form-control" placeholder="Remarks" /></td>
                                    <td>
                                        <a href="javascript:;" data-repeater-delete=""  data-toggle="modal" data-target="#delete_rf_item" class="btn btn-sm font-weight-bolder btn-light-danger">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </td>
                                </tr>
                            </tbody> --}}
                        </table>
                    </div>
                </div>
                {{-- <div class="form-group row">
                    <div class="col-sm-12">
                        <a href="javascript:;" data-repeater-create="" class="btn btn-sm font-weight-bolder btn-light-primary">
                            <i class="la la-plus"></i>Add
                        </a>
                    </div>
                </div> --}}
            </div>			
			
			{{-- <div class="row">
				<div class="col-sm-12">
					<form id="PoDetail2">
						<div class="form-group mt-6">
							<div class="radio-list">
								<label class="radio">
									<input type="radio" name="po_type" value="select_po" />
									<span></span>
									Select PO File:
								</label>
								<div class="form-group row selectPO" style="display:none;">
									<div class="col-sm-4">
										<select class="form-control selectpicker" data-live-search="true" data-size="3">
											<option disabled selected>Select PO</option>											
										@foreach ($po_list as $po)
											<option data-tokens="{{ $po->po_no }}" value="{{ $po->id }}">{{ $po->po_no }} [{{ $po->company_name }}]</option>
										@endforeach 	
										</select>
									</div>
								</div>
								<label class="radio">
									<input type="radio" name="po_type" value="upload_po" />
									<span></span>
									Upload a new PO file
								</label>
								<div class="uploadPO" style="display:none;">
									<div class="form-group row">
										<div class="col-sm-6">
											<label class="col-form-label text-right mr-5">PO#:</label>
											<input id="po_no" type="text" class="form-control" placeholder="Fill in PO#" />
										</div>
										<div class="col-sm-6">
											<label class="col-form-label text-right mr-5">PO Date:</label>
											<input type="text" class="form-control" id="kt_datepicker_4_1" placeholder="Select PO Date" />
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-6">
											<label class="col-form-label text-right mr-5">Select Vendor:</label>
											<select id="SelectVendor2" class="form-control selectpicker" data-live-search="true" data-size="3">											
												<option disabled selected>Vendor Company</option>											
												@foreach ($vendors as $vendor)
													<option data-tokens="{{ $vendor->company_name }}" value="{{ $vendor->id }}">{{ $vendor->company_name }} ({{ $vendor->company_no }})</option>
												@endforeach 
											</select>
										</div>
										<div class="col-sm-6">
											<label class="col-form-label text-right mr-5">Upload PO file:</label>
											<div class="custom-file">
												<input type="file" class="custom-file-input" id="po_file2"/>
												<label class="custom-file-label" for="po_file2">Choose file</label>
											</div>
											<div class="img_preview2 mt-5"></div>
											<div class="doc_preview2"></div>
										</div>
									</div>
								</div>
							</div>
						</div>			
					</form>
					
				</div>
			</div>	
			--}} 	
			<hr>
            <div class="row">
                <div class="col-sm-12">
                    <p class="mb-0">Notes:</p>
                    <ol class="notes-list">
                        <li>Request forms done by site clerical personnel will be needed project manager's approval.</li>
                        <li>Request forms done by project manager will be auto-approved and sent to HQ.</li>
                    </ol>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12 text-center">
                    <a href="#" class="btn btn-primary font-weight-bolder btnProceed">Proceed</a>
                    <a class="btn btn-light-primary font-weight-bolder">Reset</a>
                </div>
            </div>
            
        </div>

    </div>
</div>
<!-- Modal PO Details Update -->
<div class="modal fade" id="add_newPOItem" tabindex="-1" role="dialog" aria-labelledby="add_newPOItem" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add PO Item</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i aria-hidden="true" class="ki ki-close"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div id="ListSearch"></div>
						<div id="ListItem" data-rf-id="" data-rf-no=""></div>
                    </div>
                </div>

            </div>
            <div class="modal-footer d-flex align-items-stretch justify-content-between">				
				<div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap mr-15">
					<button type="button" class="btn btn-primary font-weight-bold btnBack">Back</button>
				</div>
				<div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
					<button type="button" class="btn btn-primary font-weight-bold mr-3 btnConfirm">Add</button>					
					<button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
				</div>
            </div>
        </div>
    </div>
</div>

<!-- Modal RF -->
<div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content">
			<div class="modal-body">
				<div class="row">
					<div class="col-sm-5">
						<h1>Requisition Form</h1>
						<h5 class="rf_no"></h5>
					</div>
					<div class="col-sm-7">
						<div class="address-box text-right">
							Arte Cheras,<br>
							No.2, Jalan Midah 2,<br>
							Taman Midah, Cheras,<br>
							56000 Kuala Lumpur<br>
							Tel: +6012-123 4567												
						</div>
						<div class="logo-box">
							<div class="logo-rf" style="background-image: url('{{ asset('/images/logo/arte-cheras.png') }}');"></div>
						</div>
					</div>
				</div>

				<hr class="mt-5 mb-5">

				<div class="row">
					<div class="col-sm-6">
						<div class="to-info"></div>
					</div>
					<div class="col-sm-6">
						<div class="request-info">
						{{-- <table class="table table-borderless">
								<tr>
									<td>Request Date :</td>
									<td>28/08/2021</td>
								</tr>
								<tr>
									<td>Requested by :</td>
									<td>Janet Tan</td>
								</tr>
								<tr>
									<td>Contact # :</td>
									<td>017-330 5149</td>
								</tr>
						</table> --}}
						</div>
					</div>

					<div class="col-sm-12">
						<table class="table table-bordered table-rf mt-5">
							{{--<tr>
								<th>#</th>
								<th>Item Description</th>
								<th>Unit</th>
								<th>Qty</th>
								<th>Date Required</th>
								<th>Remarks</th>
							</tr>
							<tr>
								<td>1</td>
								<td>Item 1</td>
								<td>Nos</td>
								<td>128</td>
								<td>05/10/2021</td>
								<td>This is some description for item 1</td>
							</tr>
							<tr>
								<td>2</td>
								<td>Item 2</td>
								<td>Kg</td>
								<td>128</td>
								<td>05/10/2021</td>
								<td>This is some description for item 1. This is some description for item 1</td>
							</tr>
							<tr>
								<td>3</td>
								<td>Item 3</td>
								<td>M3</td>
								<td>128</td>
								<td>05/10/2021</td>
								<td>This is some description for item 1</td>
							</tr>--}}
						</table>
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
			</div>
		</div>
	</div>
</div>

    
@endsection

@section('custom_js')
<script src="{{ asset('js/po.js') }}"></script>
<script src="{{ asset('js/pages/crud/forms/widgets/form-repeater.js') }}"></script>
<script src="{{ asset('js/pages/crud/forms/widgets/bootstrap-datepicker.js') }}"></script>
@endsection