@extends('layouts.app')

@section('title') Overview @endsection

@php
    if(Gate::check('is-pm')) {
        
    }
@endphp

@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div id="total_requisition" class="d-flex justify-content-center"></div>
                </div>
            </div>

            <hr class="mt-15 mb-15">

            <div class="row">
                <div class="col-sm-12">
                    <!-- Datatable (JS in datatable-custom.js) -->
                    <table class="table table-bordered mt-15 table_overviewpmtr table-hover" id="overview_pm_tr">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>RF#</th>
                                <th>Requested by</th>
                                <th>Contact</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>05/09/2021</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC05092021001</a></td>
                                <td>Chris Lim</td>
                                <td>017-217 8990</td>
                                <td>Complete</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>08/09/2021</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC08092021001</a></td>
                                <td>Cyndy Wong</td>
                                <td>012-225 9887</td>
                                <td>InComplete</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>10/09/2021</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                <td>Janet Tan</td>
                                <td>017-330 5149</td>
                                <td>Complete</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>10/09/2021</td>
                                <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                <td>Janet Tan</td>
                                <td>017-330 5149</td>
                                <td>InComplete</td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Modal RF -->
            <div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h1>Requisition Form</h1>
                                    <h5>RF#: RF-AC28082021001</h5>
                                </div>
                                <div class="col-sm-6">
                                    <div class="address-box text-right">
                                        Arte Cheras,<br>
                                        No.2, Jalan Midah 2,<br>
                                        Taman Midah, Cheras,<br>
                                        56000 Kuala Lumpur<br>
                                        Tel: +6012-123 4567												
                                    </div>
                                    <div class="logo-box">
                                        <div class="logo-rf" style="background-image: url('assets/media/arte-cheras.png');"></div>
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-5 mb-5">

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="to-info">
                                        <strong>To:</strong><br>
                                        Headquarters<br>
                                        No.1, Jalan Wangsa Permai, 2nd Floor,<br>
                                        Bangunan One Wangsa, Taman Wangsa Permai,<br>
                                        Tel: +603-6277 2480<br>
                                        Fax: +603-6276 2482
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="request-info">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td>Request Date :</td>
                                                <td>28/08/2021</td>
                                            </tr>
                                            <tr>
                                                <td>Requested by :</td>
                                                <td>Janet Tan</td>
                                            </tr>
                                            <tr>
                                                <td>Contact # :</td>
                                                <td>017-330 5149</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <table class="table table-bordered table-rf mt-5">
                                        <tr>
                                            <th>#</th>
                                            <th>Item Description</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>Date Required</th>
                                            <th>Remarks</th>
                                        </tr>
                                        <tr>
                                            <td>1</td>
                                            <td>Item 1</td>
                                            <td>Nos</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>Item 2</td>
                                            <td>Kg</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1. This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>Item 3</td>
                                            <td>M3</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
</div>
    {{-- @can('is-pm')
        <h1>IS PM</h1>
        @include('admin.dashboard.pm')    
    @elsecan('is-hq')
        @include('admin.dashboard.hq')   
    @elsecan('is-site')
        @include('site.dashboard')
    @endcan --}}
@endsection

@section('custom_js')
    <script>
		var KTApexChartsDemo = function () {

			var _total_requisition = function () {
				const apexChart = "#total_requisition";
				var options = {
					series: [{
						name: 'Pending',
						data: [619, 828, 539, 589, 427, 206, 624, 449, 301, 388]
					}, {
						name: 'PO',
						data: [4899, 3591, 3946, 2381, 2653, 2405, 1864, 1983, 1274, 925]
					}, {
						name: 'DO',
						data: [832, 957, 558, 248, 363, 673, 559, 341, 488, 345]
					}, {
						name: 'Rejected',
						data: [384, 449, 204, 347, 146, 103, 216, 145, 56, 123]
					}],
					chart: {
						type: 'bar',
						height: 450,
						stacked: true,
						toolbar: {
							tools: {
								download: false
							}
						},
					},
					title: {
						text: 'Total Requisition',
						align: 'center',
						style: {
							fontSize:  '16px',
							fontWeight:  'bold',
							color:  '#000'
						},
					},
					responsive: [{
						breakpoint: 480,

						options: {
							title: {
								style: {
									fontSize: '14px',
								},
							},
							chart: {
								height: 500,
							},
							legend: {
								position: 'bottom'
							},
							xaxis: {
								type: 'text',
								categories: [
									['Item 2', '(Nos)'],
									['Item 5', '(M2)'],
									['Item 9', '(M3)'],
									['Item 6', '(Nos)'],
									['Item 1', '(Kg)'],
									['Item 10', '(Nos)'],
									['Item 8', '(Kg)'],
									['Item 4', '(M3)'],
									['Item 3', '(Kg)'],
									['Item 7', '(Kg)'],
								],
								tickAmount: 6,
							},
						}
					}],
					plotOptions: {
						bar: {
							borderRadius: 8,
							horizontal: true,
						},
					},
					xaxis: {
						type: 'text',
						categories: ['Item 2 (Nos)', 'Item 5 (M2)', 'Item 9 (M3)', 'Item 6 (Nos)', 'Item 1 (Kg)', 'Item 10 (Nos)', 'Item 8 (Kg)', 'Item 4 (M3)', 'Item 3 (Kg)', 'Item 7 (Kg)'],
						tickAmount: 6,
					},
					dataLabels: {
						enabled: true,
						style: {
							fontSize: '10px',
						},
					},
					legend: {
						position: 'bottom',
						formatter: function (seriesName, opts) {
							return [seriesName, " - ", opts.w.globals.seriesTotals[opts.seriesIndex]]
						}
					},
					fill: {
						opacity: 1
					},
					colors: ['#87c5fe', '#f4ca80', '#75cf8c', '#bbbfc2'],
					grid: {
						xaxis: {
							lines: {
								show: true
							}
						},
						yaxis: {
							lines: {
								show: false
							}
						}
					},
					states: {
						normal: {
							filter: {
								type: 'none',
								value: 0,
							}
						},
						hover: {
							filter: {
								type: 'darken',
								value: 0.15,
							}
						},
						active: {
							allowMultipleDataPointsSelection: false,
							filter: {
								type: 'darken',
								value: 0.35,
							}
						},
					}
				};

				var chart = new ApexCharts(document.querySelector(apexChart), options);
				chart.render();
			}

			return {
				// public functions
				init: function () {
					_total_requisition();
				}
			};
		}();
	</script>
@endsection