@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="pageTitle">
                        <h4>Latest Status of Material Items on Site (Weekly)</h4>
                    </div>
                    <div class="row select_status status1">
                        <div class="col-lg-6 col-sm-12">
                            <div id="arteCheras_status" class="d-flex justify-content-center mt-5"></div>
                            <ul class="status-info mt-5">
                                <li class="rfapprov">
                                    <p>RF Approv</p>
                                    <p>5</p>
                                    <div class="seperator"></div>
                                    <p>20.8%</p>
                                </li>
                                <li class="rereject">
                                    <p>RF Reject</p>
                                    <p>2</p>
                                    <div class="seperator"></div>
                                    <p>8.3%</p>
                                </li>
                                <li class="po">
                                    <p>PO</p>
                                    <p>6</p>
                                    <div class="seperator"></div>
                                    <p>25.0%</p>
                                </li>
                                <li class="do">
                                    <p>DO</p>
                                    <p>7</p>
                                    <div class="seperator"></div>
                                    <p>29.2%</p>
                                </li>
                                <li class="received">
                                    <p>Received</p>
                                    <p>4</p>
                                    <div class="seperator"></div>
                                    <p>16.7%</p>
                                </li>
                            </ul>
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <div id="arteMK_status" class="d-flex justify-content-center mt-5"></div>
                            <ul class="status-info mt-5">
                                <li class="rfapprov">
                                    <p>RF Approv</p>
                                    <p>7</p>
                                    <div class="seperator"></div>
                                    <p>28.0%</p>
                                </li>
                                <li class="rereject">
                                    <p>RF Reject</p>
                                    <p>3</p>
                                    <div class="seperator"></div>
                                    <p>12.0%</p>
                                </li>
                                <li class="po">
                                    <p>PO</p>
                                    <p>8</p>
                                    <div class="seperator"></div>
                                    <p>32.0%</p>
                                </li>
                                <li class="do">
                                    <p>DO</p>
                                    <p>5</p>
                                    <div class="seperator"></div>
                                    <p>20.0%</p>
                                </li>
                                <li class="received">
                                    <p>Received</p>
                                    <p>2</p>
                                    <div class="seperator"></div>
                                    <p>8.0%</p>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <hr class="mt-15 mb-15">

            <div class="row">
                <div class="col-sm-12">
                    <ul class="nav nav-pills basic-tabs" id="pm_dashboardTab">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#rf">
                                <span class="nav-text">RF</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#po">
                                <span class="nav-text">PO</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#do">
                                <span class="nav-text">DO</span>
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content pm_dashboardTab mt-5" id="pm_dashboardTabContent">
                        <div class="tab-pane fade show active" id="rf" role="tabpanel" aria-labelledby="rf">
                            <!-- Datatable (JS in datatable-custom.js) -->
                            <table class="table table-bordered mt-15 table_dashpmrf table-hover" id="dashboard_pm_rf">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>RF#</th>
                                        <th>Req Item</th>
                                        <th>Req Date</th>
                                        <th>Req by</th>
                                        <th>Contact</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Arte Cheras</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>5</td>
                                        <td>10/09/2021</td>
                                        <td>Cyndy Wong</td>
                                        <td>012-225 9887</td>
                                        <td>Submitted</td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Arte Cheras</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                        <td>3</td>
                                        <td>10/09/2021</td>
                                        <td>Janet Tan</td>
                                        <td>017-330 5149</td>
                                        <td>Submitted</td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>Arte Cheras</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021003</a></td>
                                        <td>3</td>
                                        <td>10/09/2021</td>
                                        <td>Janet Tan</td>
                                        <td>017-330 5149</td>
                                        <td>Rejected</td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>Arte MK</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>3</td>
                                        <td>10/09/2021</td>
                                        <td>Tiffany Chan</td>
                                        <td>013-556 3399</td>
                                        <td>Submitted</td>
                                    </tr>
                                    <tr>
                                        <td>5</td>
                                        <td>Arte MK</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                        <td>4</td>
                                        <td>10/09/2021</td>
                                        <td>Chloe Lam</td>
                                        <td>016-222 3343</td>
                                        <td>Submitted</td>
                                    </tr>
                                    <tr>
                                        <td>6</td>
                                        <td>Arte MK</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021003</a></td>
                                        <td>3</td>
                                        <td>10/09/2021</td>
                                        <td>Chloe Lam</td>
                                        <td>016-222 3343</td>
                                        <td>Rejected</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                
                        <div class="tab-pane fade" id="po" role="tabpanel" aria-labelledby="po">
                            <!-- Datatable (JS in datatable-custom.js) -->
                            <table class="table table-bordered table-hover mt-15 table_dashpmpo" id="dashboard_pm_po">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>PO#</th>
                                        <th>Item Desc</th>
                                        <th>Qty</th>
                                        <th>Unit</th>
                                        <th>Vendor</th>
                                        <th>RF#</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>58</td>
                                        <td>M3</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>117</td>
                                        <td>M3</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>102</td>
                                        <td>Kg</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>5</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>6</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>58</td>
                                        <td>Kg</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>

                                    <tr>
                                        <td>7</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>183</td>
                                        <td>M3</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>8</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>9</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>117</td>
                                        <td>M3</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>10</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>102</td>
                                        <td>Kg</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>11</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>12</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>13</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>58</td>
                                        <td>Kg</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>14</td>
                                        <td>Arte MK</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>183</td>
                                        <td>Kg</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>15</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>58</td>
                                        <td>Kg</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>16</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>58</td>
                                        <td>M3</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>17</td>
                                        <td>Arte Cheras</td>
                                        <td>PO-10092021001</td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                
                        <div class="tab-pane fade" id="do" role="tabpanel" aria-labelledby="do">
                            <!-- Datatable (JS in datatable-custom.js) -->
                            <table class="table table-bordered table-hover mt-15 table_dashpmdo" id="dashboard_pm_do">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>DO#</th>
                                        <th>Item Desc</th>
                                        <th>Qty</th>
                                        <th>Unit</th>
                                        <th>Vendor</th>
                                        <th>PO#</th>
                                        <th>RF#</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>125</td>
                                        <td>Kg</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>5</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>6</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>156</td>
                                        <td>M3</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>7</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>89</td>
                                        <td>Kg</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>8</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>178</td>
                                        <td>Nos</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>9</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>113</td>
                                        <td>M3</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>10</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>256</td>
                                        <td>Kg</td>
                                        <td>XYZ Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>11</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>89</td>
                                        <td>Kg</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>12</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>53</td>
                                        <td>Nos</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>13</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>62</td>
                                        <td>M3</td>
                                        <td>WWW Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>14</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>106</td>
                                        <td>Kg</td>
                                        <td>WWW Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>15</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>99</td>
                                        <td>M3</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>16</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>138</td>
                                        <td>Kg</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>17</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>110</td>
                                        <td>Nos</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>18</td>
                                        <td>Arte MK</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>237</td>
                                        <td>M3</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>19</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>136</td>
                                        <td>Kg</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>20</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>178</td>
                                        <td>M3</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                    <tr>
                                        <td>21</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>88</td>
                                        <td>Kg</td>
                                        <td>TNT Sdn Bhd</td>
                                        <td>PO-04092021001</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td>Pending</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal RF -->
            <div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h1>Requisition Form</h1>
                                    <h5>RF#: RF-AC28082021001</h5>
                                </div>
                                <div class="col-sm-6">
                                    <div class="address-box text-right">
                                        Arte Cheras,<br>
                                        No.2, Jalan Midah 2,<br>
                                        Taman Midah, Cheras,<br>
                                        56000 Kuala Lumpur<br>
                                        Tel: +6012-123 4567												
                                    </div>
                                    <div class="logo-box">
                                        <div class="logo-rf" style="background-image: url('assets/media/arte-cheras.png');"></div>
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-5 mb-5">

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="to-info">
                                        <strong>To:</strong><br>
                                        Headquarters<br>
                                        No.1, Jalan Wangsa Permai, 2nd Floor,<br>
                                        Bangunan One Wangsa, Taman Wangsa Permai,<br>
                                        Tel: +603-6277 2480<br>
                                        Fax: +603-6276 2482
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="request-info">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td>Request Date :</td>
                                                <td>28/08/2021</td>
                                            </tr>
                                            <tr>
                                                <td>Requested by :</td>
                                                <td>Janet Tan</td>
                                            </tr>
                                            <tr>
                                                <td>Contact # :</td>
                                                <td>017-330 5149</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <table class="table table-bordered table-rf mt-5">
                                        <tr>
                                            <th>#</th>
                                            <th>Item Description</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>Date Required</th>
                                            <th>Remarks</th>
                                        </tr>
                                        <tr>
                                            <td>1</td>
                                            <td>Item 1</td>
                                            <td>Nos</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>Item 2</td>
                                            <td>Kg</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1. This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>Item 3</td>
                                            <td>M3</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Received Item Details -->
            <div class="modal fade" id="received_details" tabindex="-1" role="dialog" aria-labelledby="received_details" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Received Item Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <i aria-hidden="true" class="ki ki-close"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <table class="table table-bordered table-receivedDetails mb-10">
                                        <tr>
                                            <th>#</th>
                                            <th>DO#</th>
                                            <th>Vendor</th>
                                            <th>Item Description</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>PO#</th>
                                            <th>RF#</th>
                                            <th>Received</th>
                                        </tr>
                                        <tr>
                                            <td>1</td>
                                            <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                            <td>ABC Sdn Bhd</td>
                                            <td>Item 1 description asdad asd as asd ad	</td>
                                            <td>128</td>
                                            <td>Nos</td>
                                            <td>PO-04092021001</td>
                                            <td>RF-AC28082021001</td>
                                            <td>05/09/2021</td>
                                        </tr>
                                    </table>

                                    <ul class="nav nav-pills basic-tabs" id="received_details_Tab">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-toggle="tab" href="#stocks">
                                                <span class="nav-text"><i class="fas fa-cubes"></i>Stocks</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#vehicle">
                                                <span class="nav-text"><i class="fas fa-truck"></i>Vehicle</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#driver">
                                                <span class="nav-text"><i class="fas fa-user"></i>Driver</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#document">
                                                <span class="nav-text"><i class="far fa-file-alt"></i>Document</span>
                                            </a>
                                        </li>
                                    </ul>

                                    <div class="tab-content received_details_Tab mt-5" id="received_detailsTabContent">
                                        <div class="tab-pane fade show active" id="stocks" role="tabpanel" aria-labelledby="stocks">
                                            <ul class="info_img_list">
                                                <li>
                                                    <a href="#img1">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/stock.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img1">
                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img2">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/stock.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img2">
                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img3">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/stock.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img3">
                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane fade" id="vehicle" role="tabpanel" aria-labelledby="vehicle">
                                            <ul class="info_img_list">
                                                <li>
                                                    <a href="#img4">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img4">
                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img5">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img5">
                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img6">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img6">
                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img7">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img7">
                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img8">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img8">
                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane fade" id="driver" role="tabpanel" aria-labelledby="driver">
                                            <ul class="info_img_list">
                                                <li>
                                                    <a href="#img9">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/driver.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img9">
                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img10">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/driver.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img10">
                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img11">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/driver.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img11">
                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="tab-pane fade" id="document" role="tabpanel" aria-labelledby="document">
                                            <ul class="info_img_list">
                                                <li>
                                                    <a href="#img12">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/document.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img12">
                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img13">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/document.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img13">
                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#img14">
                                                        <div class="info_img_bg"
                                                            style="background-image: url(assets/media/document.jpg);">
                                                        </div>
                                                    </a>
                                                    <a href="#" class="lightbox" id="img14">
                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>


                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection
@section('custom_js')
    <script>
		var KTApexChartsDemo = function () {
			var _arteCheras_status = function () {
				const apexChart = "#arteCheras_status";
				var options = {
					labels: ["RF Approv", "RF Reject", "PO", "DO", "Received"],
					series: [5, 2, 6, 7, 4],
					chart: {
						// width: 400,
						height: 400,
						type: 'pie',
					},
					legend: {
						position: 'bottom',
					},
					responsive: [{
						breakpoint: 480,
						options: {
							chart: {
								height: 300,
							},
						},
					}],
					colors: ['#87c5fe', '#bbbfc2', '#f4ca80', '#75cfb4', '#75cf8c'],
					dataLabels: {
						style: {
							colors: ['#000'],
						},
						dropShadow: {
							enabled: false,
						},
					},
					title: {
						text: 'Arte Cheras',
						align: 'center'
					},
					states: {
						normal: {
							filter: {
								type: 'none',
								value: 0,
							}
						},
						hover: {
							filter: {
								type: 'darken',
								value: 0.15,
							}
						},
						active: {
							allowMultipleDataPointsSelection: false,
							filter: {
								type: 'darken',
								value: 0.35,
							}
						},
					}
				};

				var chart = new ApexCharts(document.querySelector(apexChart), options);
				chart.render();
			}

			var _arteMK_status = function () {
				const apexChart = "#arteMK_status";
				var options = {
					labels: ["RF Approv", "RF Reject", "PO", "DO", "Received"],
					series: [7, 3, 8, 5, 2],
					chart: {
						// width: 400,
						height: 400,
						type: 'pie',
					},
					legend: {
						position: 'bottom',
					},
					responsive: [{
						breakpoint: 480,
						options: {
							chart: {
								height: 300,
							},
						},
					}],
					colors: ['#87c5fe', '#bbbfc2', '#f4ca80', '#75cfb4', '#75cf8c'],
					dataLabels: {
						style: {
							colors: ['#000'],
						},
						dropShadow: {
							enabled: false,
						},
					},
					title: {
						text: 'Arte MK',
						align: 'center'
					},
					states: {
						normal: {
							filter: {
								type: 'none',
								value: 0,
							}
						},
						hover: {
							filter: {
								type: 'darken',
								value: 0.15,
							}
						},
						active: {
							allowMultipleDataPointsSelection: false,
							filter: {
								type: 'darken',
								value: 0.35,
							}
						},
					}
				};

				var chart = new ApexCharts(document.querySelector(apexChart), options);
				chart.render();
			}

			



			return {
				// public functions
				init: function () {
					_arteCheras_status();
					_arteMK_status();
				}
			};
		}();

	</script>

@endsection