<?php

namespace App\Http\Controllers;

use App\Models\Material;
use App\Models\User;
use App\Models\Role;
use App\Models\Residential;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;
use Config;

class VendorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {		
        if(Gate::denies('logged-in')) {
            // dd('no access allowed');
			return redirect('/login');
        } 
		
		if(Gate::check('is-vendor')) {
            // $residential = Residential::all();
            // $user        = User::all();
            // $role        = Role::all();
            DB::enableQueryLog();

            $user 			= auth()->user();
            $role 			= $user->getRole($user->id);
            $user_id     	= $user->id;

            $res   		 	= $user->getResidential($user->id);
            $residential_id = $res->residential_id;
            $vendor_id	 	= $res->vendor_id;
            
            $residential = DB::select("SELECT * FROM residential WHERE id IN ($residential_id) order by name asc");
           
            // dd(DB::getQueryLog());
            // $residential = Residential::all();
            // dd($residential);
            // print_r($role);
            // echo 'residential_id: '.$residential_id;
            // print_r($residential);

            // $users = DB::table('users')->get();
            // $users = DB::table('users')->where('company_id', 'John')->first();
			return view('vendor.index', compact('residential', 'user', 'role'));
			
        } else {
			return redirect('/login');
		}
    }
	
	public function show_po(Request $request)
    {
        //  echo 'MaterialController > Show Item';       
        // DB::enableQueryLog();
        // print_r($id);
        $user       	= auth()->user();
        $role       	= $user->getRole($user->id);
        $user_id    	= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;

        // $materials      = Material::getMaterial('item', $company_id);
        // $measurements   = Material::getMeasurements();

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)"); 
        // // print_r($count);
        // $count  = $count[0]->count;
        // // echo 'COUNT : '.$count;
        // if($count == 0) {
        //     dd("Permission not allow for the project");
        //     //  return view('overview.index', compact('residential', 'user', 'role'));
        // }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('vendor.po', compact('residential', 'user', 'role'));
    }
	
	public function getPoList(Request $request) {
        // dd($request);
        $user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;

        $materials 		= Material::getMaterial('trade', $company_id);
        $user_info		= "";
        // dd($request);

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      

        $project_id     = $request['project_id'];
        $by_status      = $request['by_status'];
        $source      	= $request['source'];

        switch($by_status) {
            case 'delete'      	: $by_status = 0;
                break;
			case 'new'      	: $by_status = 1;
                break;
            case 'rejected' 	: $by_status = 2;
                break;
			// case 'do' 			: $by_status = 4;
                // break;
            // case 'completed'    : $by_status = 5;
                // break;
            // case 'rejected'     : $by_status = 6;
                // break;
        }
        

        // $columnIndex    = "";
        // $columnName     = "name";
        // $columnSortOrder= "asc";
        // $searchValue    = "a";

		if($source == "vendor_add_do") { 
			// Total records
			$totalRecords           = DB::table(Config::get('constants.tables.po'))->select(DB::raw('COUNT(*) as allcount'))
					->where('residential_id', '=', $project_id)
					->where('vendor_id', '=', $vendor_id)
					->where('status', '=', '2')
					->where('company_id', '=', $company_id)
					// ->where(function($q) use ($search_arr, $searchValue) {
						// $q->where('po_no', 'LIKE', '%'.$searchValue.'%')
						  // ->orWhere('create_at', 'LIKE', '%'.$searchValue.'%');
					// })
					->value('allcount');  
			
			$totalRecordswithFilter = DB::table(Config::get('constants.tables.po'))->select(DB::raw('COUNT(*) as allcount'))
					->where('residential_id', '=', $project_id)
					->where('vendor_id', '=', $vendor_id)
					->where('status', '=', '2')
					// ->where('po_no', 'LIKE', '%'.$searchValue.'%')
					// ->where(function($q) use ($search_arr, $searchValue) {
						// $q->where('po_no', 'LIKE', '%'.$searchValue.'%')
						  // ->orWhere('create_at', 'LIKE', '%'.$searchValue.'%');
					// })
					->value('allcount');  
		
			// Fetch records   
			$records = DB::table(Config::get('constants.tables.po'))
				// ->orderBy($columnName,$columnSortOrder)
				->where('residential_id', '=', $project_id)
				->where('company_id', '=', $company_id)
				->where('vendor_id', '=', $vendor_id)
				->where('status', '=', '2')
				// ->where(function($q) use ($search_arr, $searchValue) {
					// $q->where('po_no', 'LIKE', '%'.$searchValue.'%')
					  // ->orWhere('create_at', 'LIKE', '%'.$searchValue.'%');
				// })
				// ->skip($start)
				->take($rowperpage)->get();  
				// ->where('po_no', 'LIKE', '%'.$searchValue.'%')
				// ->orWhere('create_at', 'LIKE', '%'.$searchValue.'%')
				
			
		} else {
			// Total records
			$totalRecords           = DB::table(Config::get('constants.tables.po'))->select(DB::raw('COUNT(*) as allcount'))
					->where('residential_id', '=', $project_id)
					->where('vendor_id', '=', $vendor_id)
					// ->where('status', '=', $by_status)
					->where('company_id', '=', $company_id)->value('allcount');  
			// Material::select('count(*) as allcount')->count();
			$totalRecordswithFilter = DB::table(Config::get('constants.tables.po'))->select(DB::raw('COUNT(*) as allcount'))
					->where('residential_id', '=', $project_id)
					->where('vendor_id', '=', $vendor_id)
					// ->where('status', '=', $by_status)
					// ->where('po_no', 'LIKE', '%'.$searchValue.'%')
					->value('allcount');  
			//Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

			// Fetch records   
			$records = DB::table(Config::get('constants.tables.po'))
				// ->orderBy($columnName,$columnSortOrder)
				->where('residential_id', '=', $project_id)
				->where('company_id', '=', $company_id)
				->where('vendor_id', '=', $vendor_id)
				// ->where('status', '=', $by_status)
				// ->where('po_no', 'LIKE', '%'.$searchValue.'%')->skip($start)
				->take($rowperpage)->get();  
		}
       

        $data_arr   = array();
        $num        = 1;

		if($records) {
			foreach($records as $record){
				$fid				= $record->id;
				$create_by         	= $record->create_by;
				$vendor_id         	= $record->vendor_id;
				$user_info	    	= DB::table(Config::get('constants.tables.user'))->select('name', 'tel')
					->where('id', '=', $create_by)->get();  
				
				// if($vendor_id != 0) {
					// $vendor_info	= DB::table(Config::get('constants.tables.vendor'))->select('company_name', 'tel')
						// ->where('id', '=', $vendor_id)->get();  
				// } else {
					// $vendor_info = array();
				// }				
					
				$po_no     			= $record->po_no;
				$create_at          = $record->create_at;       
				$status 			= ($record->status == 1) ? "Pending" : "";
				
				switch($record->status) {
					case '1'	: $status = "New";
						break;
					case '2'	: $status = "Accepted";
						break;
					// case '3'	: $status = "DO Created";
						// break;
					// case '4'	: $status = "PO PRocessed";
						// break;
					// case '5'	: $status = "Completed";
						// break;
					case '3'	: $status = "Rejected";
						break;
					
				}
				
				$total_item         = DB::table(Config::get('constants.tables.po_item'))->select(DB::raw('COUNT(*) as allcount'))
					->where('po_id', '=', $fid)->value('allcount');
			
				if($record->status == 1) {
					$action	= '<a href="#" class="btn btn-light-success font-weight-bolder btnUpdateAction" data-toggle="modal" data-target="#ConfirmPopup" data-id="'.$fid.'" data-ref-no="'.$po_no.'" data-action="accept" >Accept</a>';
				} else {
					if($source == "vendor_add_do") {
						$action	= '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="'.$fid.'">Select</a>';
					} else {
						$action = "-";
					}
					
				}
				
				
				$data_arr[] = array(
					"id"                => '',            
					"po_no"				=> '<a class="modal-links po" data-toggle="modal" data-target="#po_form" data-id="'.$fid.'">'.$po_no.'</a>',	//$requisition_no,
					"total_item"        => $total_item,              
					"create_by"         => $user_info[0]->name,
					"create_at"         => $create_at,
					// "vendor"           	=> ($vendor_info) ? $vendor_info[0]->company_name : array(),
					"rf_no"            	=> "",
					"do"            	=> "",
					"status"            => $status,					
					"action"            => $action
					// "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_Item"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
				);

				$num++;
			}
		}
       
        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecords,
            // "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr,
			"user_info"				=> $user_info
        );
        
        echo json_encode($response);

        exit;       
    }
	
	public function show_do(Request $request)
    {
        $user       	= auth()->user();
        $role       	= $user->getRole($user->id);
        $user_id    	= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('vendor.do', compact('residential', 'user', 'role'));
    }

	
	public function getDoList(Request $request) {
        // dd($request);
        $user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;

        $materials 		= Material::getMaterial('trade', $company_id);
        $user_info		= "";
        // dd($request);

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      

        $project_id     = $request['project_id'];
        $by_status      = $request['by_status'];
        $source      	= $request['source'];

        switch($by_status) {
            case 'new'      	: $by_status = 1;
                break;
			case 'pending'      : $by_status = 2;
                break;
            case 'po' 			: $by_status = 3;
                break;
			case 'do' 			: $by_status = 4;
                break;
            case 'completed'    : $by_status = 5;
                break;
            case 'rejected'     : $by_status = 6;
                break;
        }
        

        // $columnIndex    = "";
        // $columnName     = "name";
        // $columnSortOrder= "asc";
        // $searchValue    = "a";

        // Total records
        $totalRecords           = DB::table(Config::get('constants.tables.do'))->select(DB::raw('COUNT(*) as allcount'))
                ->where('residential_id', '=', $project_id)
                ->where('vendor_id', '=', $vendor_id)
                // ->where('status', '=', $by_status)
                ->where('company_id', '=', $company_id)->value('allcount');  
        // Material::select('count(*) as allcount')->count();
        $totalRecordswithFilter = DB::table(Config::get('constants.tables.do'))->select(DB::raw('COUNT(*) as allcount'))
                ->where('residential_id', '=', $project_id)
                ->where('vendor_id', '=', $vendor_id)
                // ->where('status', '=', $by_status)
                // ->where('do_no', 'LIKE', '%'.$searchValue.'%')
				->value('allcount');  
        //Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

        // Fetch records   
        $records = DB::table(Config::get('constants.tables.do'))
		// ->orderBy($columnName,$columnSortOrder)
            ->where('residential_id', '=', $project_id)
            ->where('company_id', '=', $company_id)
            ->where('vendor_id', '=', $vendor_id)
            // ->where('status', '=', $by_status)
            // ->where('do_no', 'LIKE', '%'.$searchValue.'%')->skip($start)
			->take($rowperpage)->get();  

        $data_arr   = array();
        $num        = 1;

		if($records) {
			foreach($records as $record){
				$fid				= $record->id;
				$create_by         	= $record->create_by;
				$vendor_id         	= $record->vendor_id;
				$user_info	    	= DB::table(Config::get('constants.tables.user'))->select('name', 'tel')
					->where('id', '=', $create_by)->get();  
				
				if($vendor_id != 0) {
					$vendor_info	= DB::table(Config::get('constants.tables.vendor'))->select('company_name', 'tel')
						->where('id', '=', $vendor_id)->get();  
				} else {
					$vendor_info = array();
				}				
					
				$do_no     			= $record->do_no;
				$create_at          = $record->create_at;       
				$status 			= ($record->status == 1) ? "Pending" : "";
				
				switch($record->status) {
					case '1'	: $status = "New";
						break;
					case '2'	: $status = "Accepted";
						break;
					case '3'	: $status = "Incomplete";
						break;
					case '4'	: $status = "Completed";
						break;
					case '5'	: $status = "Rejected";
						break;
					// case '6'	: $status = "Rejected";
						// break;
					
				}
				
				$total_item         = DB::table(Config::get('constants.tables.do_item'))->select(DB::raw('COUNT(*) as allcount'))
					->where('do_id', '=', $fid)->value('allcount');
					
				if($source == "po_page") {
					//<a href="{{ url('admin/requisition/'.$residential_id.'/create') }}" class="btn btn-light-primary font-weight-bolder"><i class="la la-plus"></i>Add</a>
					//<button type="button" class="btn btn-success font-weight-bold btnApproveRf" data-rf-id="" data-action="approve">Approve RF</button>
					$action	= '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="'.$fid.'">Select</a>';
				} else {
					$action = '<a href="'.$project_id.'/edit/'.$fid.'" class="action-btn"><i class="fas fa-edit" data-id="'.$fid.'"></i></a>';
				}
					
				$data_arr[] = array(
					"id"                => '',            
					"do_no"				=> '<a class="modal-links do" data-toggle="modal" data-target="#do_form" data-id="'.$fid.'">'.$do_no.'</a>',	//$requisition_no,
					"total_item"        => $total_item,              
					"create_by"         => $user_info[0]->name,
					"create_at"         => $create_at,
					"vendor"           	=> ($vendor_info) ? $vendor_info[0]->company_name : array(),
					// "rf_no"            	=> "",
					// "do"            	=> "",
					"status"            => $status,					
					"action"            => $action
					// "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_Item"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
				);

				$num++;
			}
		}
       
        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecords,
            // "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr,
			"user_info"				=> $user_info
        );
        
        echo json_encode($response);

        exit;       
    }
	
	
	public function getPoDetail(Request $request) {
        // dd($request);
		define("TABLE_COMPANY", Config::get('constants.tables.company'));
		define("TABLE_ITEM", Config::get('constants.tables.item'));
		define("TABLE_PO", Config::get('constants.tables.po'));
		define("TABLE_PO_ITEM", Config::get('constants.tables.po_item'));		
		define("TABLE_REQUISITION", Config::get('constants.tables.requisition'));
		define("TABLE_RESIDENTIAL", Config::get('constants.tables.residential'));
		define("TABLE_USER", Config::get('constants.tables.user'));		
		define("TABLE_VENDOR", Config::get('constants.tables.vendor'));		
		
        $user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;

        $materials 		= Material::getMaterial('trade', $company_id);		
		$residential 	= DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc"); 
		
		$status 		= "fail";
		$project_id     = $request['project_id'];
		$po_id     		= $request['id'];		
		$po_detail		= "";
		$po_list		= array();
		
		$company_info	= DB::table(TABLE_COMPANY)
			->select(TABLE_COMPANY.'.name AS company_name', TABLE_COMPANY.'.address AS company_addr', TABLE_RESIDENTIAL.'.name AS residential_name', TABLE_RESIDENTIAL.'.address AS residential_addr', TABLE_RESIDENTIAL.'.logo')
			->leftJoin(TABLE_RESIDENTIAL, TABLE_RESIDENTIAL.'.company_id', '=', TABLE_COMPANY.'.id')
            ->where(TABLE_COMPANY.'.id', '=', $company_id)
            ->where(TABLE_RESIDENTIAL.'.id', '=', $project_id)
            ->get(); 
		
		if($company_info && count($company_info) > 0) {
			$status = "success";
		} 
		// DB::enableQueryLog();
		$po_detail 	= DB::table(TABLE_PO)
			->select(TABLE_PO.'.*', TABLE_USER.'.name AS creator_name', TABLE_USER.'.tel AS creator_tel', TABLE_VENDOR.'.company_name AS vendor_company', TABLE_VENDOR.'.address AS vendor_addr')
			->leftJoin(TABLE_USER, TABLE_USER.'.id', '=', TABLE_PO.'.create_by')
			->leftJoin(TABLE_VENDOR, TABLE_VENDOR.'.id', '=', TABLE_PO.'.vendor_id')
			// ->leftJoin(TABLE_REQUISITION, TABLE_REQUISITION.'.id', '=', TABLE_PO.'.requisition_id')
            ->where(TABLE_PO.'.id', '=', $po_id)
            ->where(TABLE_PO.'.company_id', '=', $company_id)
            ->where(TABLE_PO.'.vendor_id', '=', $vendor_id)
            // ->where(TABLE_REQUISITION.'.company_id', '=', '9')
            ->get(); 
		
				
		$po_list[]	= DB::table(TABLE_PO_ITEM)
			->select(TABLE_PO_ITEM.'.qty', TABLE_PO_ITEM.'.remark', TABLE_PO_ITEM.'.item_id', TABLE_PO_ITEM.'.id AS po_item_id', TABLE_ITEM.'.name', TABLE_ITEM.'.description', TABLE_ITEM.'.unit', TABLE_ITEM.'.img')
			->leftJoin(TABLE_ITEM, TABLE_PO_ITEM.'.item_id', '=', TABLE_ITEM.'.id')
			->leftJoin(TABLE_PO, TABLE_PO_ITEM.'.po_id', '=', TABLE_PO.'.id')
            ->where(TABLE_PO.'.id', '=', $po_id)
            ->where(TABLE_PO.'.company_id', '=', $company_id)
            ->where(TABLE_PO.'.vendor_id', '=', $vendor_id)
			->orderBy(TABLE_ITEM.'.name', 'desc')            
            ->get();

		// dd(DB::getQueryLog()); 
			
		// if($rf_detail && count($rf_detail) > 0) {
			// $status = "success";			
		// } 
		
		// return view('material.index', compact('residential', 'user', 'role', 'materials', 'result'));
		 echo json_encode(array('status' => $status, 'company_info' => $company_info, 'po_detail' => $po_detail, 'po_list' => $po_list));
	}
	
	public function getDoDetail(Request $request) {
        // dd($request);
		define("TABLE_COMPANY", Config::get('constants.tables.company'));
		define("TABLE_ITEM", Config::get('constants.tables.item'));
		define("TABLE_DO", Config::get('constants.tables.do'));
		define("TABLE_DO_TEM", Config::get('constants.tables.do_item'));		
		define("TABLE_PO", Config::get('constants.tables.po'));
		define("TABLE_RESIDENTIAL", Config::get('constants.tables.residential'));
		define("TABLE_USER", Config::get('constants.tables.user'));		
		define("TABLE_VENDOR", Config::get('constants.tables.vendor'));		
		
        $user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;

        $materials 		= Material::getMaterial('trade', $company_id);		
		$residential 	= DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc"); 
		
		$status 		= "fail";
		$project_id     = $request['project_id'];
		$do_id     		= $request['id'];		
		$do_detail		= "";
		$do_list		= array();
		
		$company_info	= DB::table(TABLE_COMPANY)
			->select(TABLE_COMPANY.'.name AS company_name', TABLE_COMPANY.'.address AS company_addr', TABLE_RESIDENTIAL.'.name AS residential_name', TABLE_RESIDENTIAL.'.address AS residential_addr', TABLE_RESIDENTIAL.'.logo')
			->leftJoin(TABLE_RESIDENTIAL, TABLE_RESIDENTIAL.'.company_id', '=', TABLE_COMPANY.'.id')
            ->where(TABLE_COMPANY.'.id', '=', $company_id)
            ->where(TABLE_RESIDENTIAL.'.id', '=', $project_id)
            ->get(); 
		
		if($company_info && count($company_info) > 0) {
			$status = "success";
		} 
		// DB::enableQueryLog();
		$do_detail 	= DB::table(TABLE_DO)
			->select(TABLE_DO.'.*', TABLE_USER.'.name AS creator_name', TABLE_USER.'.tel AS creator_tel', TABLE_VENDOR.'.company_name AS vendor_company', TABLE_VENDOR.'.address AS vendor_addr', TABLE_PO.'.po_no')
			->leftJoin(TABLE_USER, TABLE_USER.'.id', '=', TABLE_DO.'.create_by')
			->leftJoin(TABLE_VENDOR, TABLE_VENDOR.'.id', '=', TABLE_DO.'.vendor_id')
			->leftJoin(TABLE_PO, TABLE_PO.'.id', '=', TABLE_DO.'.po_id')			
            ->where(TABLE_DO.'.id', '=', $do_id)
            ->where(TABLE_DO.'.company_id', '=', $company_id)
            ->where(TABLE_DO.'.vendor_id', '=', $vendor_id)           
            ->get();		
				
		$do_list[]	= DB::table(TABLE_DO_TEM)
			->select(TABLE_DO_TEM.'.qty', TABLE_DO_TEM.'.remark', TABLE_DO_TEM.'.item_id', TABLE_DO_TEM.'.id AS do_item_id', TABLE_DO_TEM.'.po_item_id AS po_item_id', TABLE_ITEM.'.name', TABLE_ITEM.'.description', TABLE_ITEM.'.unit', TABLE_ITEM.'.img')
			->leftJoin(TABLE_ITEM, TABLE_DO_TEM.'.item_id', '=', TABLE_ITEM.'.id')
			->leftJoin(TABLE_DO, TABLE_DO_TEM.'.do_id', '=', TABLE_DO.'.id')
            ->where(TABLE_DO.'.id', '=', $do_id)
            ->where(TABLE_DO.'.company_id', '=', $company_id)
            ->where(TABLE_DO.'.vendor_id', '=', $vendor_id)
			->orderBy(TABLE_ITEM.'.name', 'desc')            
            ->get();

		
		 echo json_encode(array('status' => $status, 'company_info' => $company_info, 'do_detail' => $do_detail, 'do_list' => $do_list));
	}
	 
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
		$user       = auth()->user();
        $role       = $user->getRole($user->id);
        $user_id    = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$vendor_id	 	= $res->vendor_id;

        $items          = Material::getMaterial('item', $company_id);
        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'"); 
        $count  = DB::select("SELECT COUNT(id) as count FROM ".Config::get('constants.tables.role_user')." WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'");        
        $count  = $count[0]->count;
       
        if($count == 0) {
            // dd("Permission not allow for the project");
            return redirect()->back(); 
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
        
        $residential= DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           
		
		$vendors 	= DB::select("SELECT * FROM ".Config::get('constants.tables.vendor')." WHERE company_id = '$company_id' order by company_name asc");   
		$po_list 	= DB::select("SELECT po.*, v.company_name FROM ".Config::get('constants.tables.po')." AS po LEFT JOIN vendor AS v ON v.id=po.company_id WHERE po.company_id = '$company_id' AND po.residential_id = '$id' order by po.id desc");   
		
        return view('vendor.do_create', compact('residential', 'user', 'role', 'items', 'company_id', 'vendors', 'po_list'));
    }
	
	/** public function po_update(Request $request)
    {        
		$user 			= auth()->user();
        $role 			= $user->getRole($user->id);
        $user_id    	= $user->id;

        $res    		= $user->getResidential($user->id);
        $residential_id = $res->residential_id;
		$company_id 	= $res->company_id;
		$vendor_id	 	= $res->vendor_id;
		
		$status			= "";		
		$po_id 			= $request['id'];
		
		$data_row = array();		
		$data_row['status']         = 2;
		$data_row['accept_by']      = $user_id;
		$data_row['accept_at']      = date("Y-m-d H:i:s");
				
		$update_result = DB::table(Config::get('constants.tables.po'))->where('id', '=', $po_id)->update($data_row);  

		if($update_result == 1) {
			$status = "success";
		}

        return response()->json(['status' => $status, 'msg' => $update_result, 'request'=>$request->all(), 'po_id'=>$po_id]);
    } **/

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user       	= auth()->user();
        $user_id    	= $user->id;
        $res        	= $user->getResidential($user->id);
        $company_id 	= $res->company_id;
		$vendor_id	 	= $res->vendor_id;
       
        $project_id = $request['project_id'];
        $po_id	 	= $request['po_id'];
        $list       = $request['list'];       
        // $vendor_id	= $request['vendor_id'];       
        $po_date	= $request['po_date'];       

        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id = '$project_id' AND company_id = '$company_id'")[0];       
       
        if($residential == false) {
            $msg = "Invalid request.";
            return response()->json(['status' => 'fail', 'msg' => $msg, 'request'=>$request->all()]);
            exit;
        }
		
		$total_do   = DB::table(Config::get('constants.tables.do'))->select(DB::raw('COUNT(*) as count'))
		->where('company_id', '=', $company_id)            
		->where('residential_id', '=', $project_id)          
		->whereRaw('Date(create_at) = CURDATE()')->value('count');

		$total_do   = $total_do + 1;
		$do_no     	= "DO-".$residential->code.date("ymd").str_pad($total_do, 3, "0", STR_PAD_LEFT);
		
		$data_row['company_id']     = $company_id;
		$data_row['residential_id'] = $request['project_id'];
		$data_row['do_no'] 			= $do_no;
		$data_row['po_id'] 			= $po_id;
		$data_row['do_file'] 		= "";
		$data_row['do_date'] 		= '0000-00-00';
		$data_row['status']         = 1;
		$data_row['vendor_id']      = $vendor_id;
		$data_row['create_by']      = $user_id;
		$data_row['create_at']      = date("Y-m-d H:i:s");

		$id = DB::table(Config::get('constants.tables.do'))->insertGetId($data_row);

        if($id) {
            $msg = "DO created! - ID: ".$id;

            foreach($list as $row)   {
                $temp = array();
                $temp['do_id'] 			= $id;               
                $temp['item_id']        = $row['id'];
                $temp['qty']           	= $row['qty'];               
                $temp['po_item_id']		= $row['po_item_id'];               
                $temp['create_by']      = $user_id;
                $temp['create_at']      = date("Y-m-d H:i:s");

                DB::table(Config::get('constants.tables.do_item'))->insert($temp);
            }
			
			$data_row = array();			
			$data_row['status']         = 2;
			$data_row['update_by']      = $user_id;
			$data_row['update_at']      = date("Y-m-d H:i:s");
			
			$update_result = DB::table(Config::get('constants.tables.po'))->where('id', '=', $po_id)->update($data_row);
        }
       
        return response()->json(['status' => 'success', 'msg' => $msg, 'request'=>$request->all(), 'do_id'=>$id]);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, $fid)
    {        
        $user 		= auth()->user();
        $role 		= $user->getRole($user->id);
        $user_id    = $user->id;

        $res    		= $user->getResidential($user->id);
        $residential_id = $res->residential_id;
		$company_id 	= $res->company_id;

        $count  = DB::select("SELECT COUNT(id) as count FROM ".Config::get('constants.tables.role_user')." WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'"); 
        // print_r($count);
        $count  = $count[0]->count;
        // echo 'COUNT : '.$count;
        if($count == 0) {
            // dd("Permission not allow for the project");
            return redirect()->back();  //->with('error', 'Permission not allow for the project');
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
		
		$do_list 	= DB::select("SELECT do.*, v.company_name FROM ".Config::get('constants.tables.do')." AS do LEFT JOIN vendor AS v ON v.id=do.vendor_id WHERE do.company_id = '$company_id' AND do.residential_id = '$id' AND do.id <> '$fid' ORDER BY do.id desc");   
		$vendors 	= DB::select("SELECT * FROM ".Config::get('constants.tables.vendor')." WHERE company_id = '$company_id' order by company_name asc"); 
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('vendor.do_create', compact('residential', 'user', 'role', 'do_list', 'vendors'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;
       
        $project_id 	= $request['project_id'];
        $list       	= $request['list'];       
        $do_no      	= $request['do_no'];              
        $do_file      	= $request['do_file'];       
        $vendor_id      = $request['vendor_id'];              
        $update_result 	= ""; 
		$status			= "";

        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id = '$project_id' AND company_id = '$company_id'")[0];       
       
        if($residential == false) {
            $msg = "Invalid request.";
            return response()->json(['status' => 'fail', 'msg' => $msg, 'request'=>$request->all()]);
            exit;
        }		
		
		$data_row = array();		
		$data_row['do_no'] 			= $do_no;
		$data_row['do_file'] 		= $do_file;
		// $data_row['vendor_id'] 		= $vendor_id;
		$data_row['status']         = 1;
		$data_row['update_by']      = $user_id;
		$data_row['update_at']      = date("Y-m-d H:i:s");		
		$update_result = DB::table(Config::get('constants.tables.do'))->where('id', '=', $id)->update($data_row);

		DB::table(Config::get('constants.tables.do_item'))->where('do_id', $id)->delete();		       

		if($id) {
			$msg = "DO updated! - ID: ".$id;

			foreach($list as $row)   {
				$temp = array();
				$temp['do_id'] 			= $id;
				$temp['po_item_id']		= $row['po_item_id'];
				$temp['item_id']        = $row['id'];
				$temp['qty']            = $row['qty'];
				// $temp['status']        	= 1;
				$temp['create_by']      = $user_id;
				$temp['create_at']      = date("Y-m-d H:i:s");
				$update_result = DB::table(Config::get('constants.tables.do_item'))->insert($temp);
			}
			
			if($update_result) {
				$status = "success";
			} else {
				$status = "fail";
				$msg 	= "Failed to update.";
			}
		}
				
		return response()->json(['status' => $status, 'msg' => $msg, 'request'=>$request->all(), 'do_id'=>$id]);
    }

	public function update_status(Request $request, $id) {
		$user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;
       
        $project_id 	= $request['project_id'];
        $list       	= $request['list'];       
        // $id      		= $request['id'];              
        $do_no      	= $request['do_no'];              
        $do_file      	= $request['do_file'];       
        $vendor_id      = $request['vendor_id'];              
        $update_status  = $request['update_status'];              
        $update_result 	= ""; 
		$status			= "";
		$msg			= "";

        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id = '$project_id' AND company_id = '$company_id'")[0];       
       
        if($residential == false) {
            $msg = "[residential][project_id: $project_id] [company_id: $company_id] Invalid request.";
            return response()->json(['status' => 'fail', 'msg' => $msg, 'request'=>$request->all()]);
            exit;
        }		
		
		$data_row = array();
		
		if($update_status == "accept") {
			$data_row['status']         = 2;
			$data_row['accept_by']      = $user_id;
			$data_row['accept_at']      = date("Y-m-d H:i:s");		
			$update_result = DB::table(Config::get('constants.tables.po'))->where('id', '=', $id)->update($data_row);
		}		
		
		if($update_result) {
			$status = "success";
		} else {
			$status = "fail";
			$msg 	= "Failed to update.";
		}
			
		return response()->json(['status' => $status, 'msg' => $msg, 'request'=>$request->all(), 'do_id'=>$id]);
	}
	
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
		//
    }
}
