<?php

namespace App\Http\Controllers;

use App\Models\Material;
use App\Models\User;
use App\Models\Role;
use App\Models\Residential;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;
use Config;

class SiteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(Gate::denies('logged-in')) {
            // dd('no access allowed');
			return redirect('/login');
        } 
		
		if(Gate::check('is-site')) {
            // $residential = Residential::all();
            // $user        = User::all();
            // $role        = Role::all();
            DB::enableQueryLog();

            $user 			= auth()->user();
            $role 			= $user->getRole($user->id);
            $user_id     	= $user->id;

            $res   		 	= $user->getResidential($user->id);
            $residential_id = $res->residential_id;
            
            $residential = DB::select("SELECT * FROM residential WHERE id IN ($residential_id) order by name asc");
          
			return view('site.index', compact('residential', 'user', 'role'));
			
        } else {
			return redirect('/login');
		}
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
