<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use App\Models\Material;
use Config;

class RequisitionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $user       = auth()->user();
        $role       = $user->getRole($user->id);
        $user_id    = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $items          = Material::getMaterial('item', $company_id);

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'"); 
        $count  = DB::select("SELECT COUNT(id) as count FROM ".Config::get('constants.tables.role_user')." WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'"); 
        // print_r($count);
        $count  = $count[0]->count;
        // echo 'COUNT : '.$count;
        if($count == 0) {
            // dd("Permission not allow for the project");
            return redirect()->back(); 
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('requisition.create', compact('residential', 'user', 'role', 'items', 'company_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd('RequisitionController > store');
        $user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;
       
        $project_id = $request['project_id'];
        $list       = $request['list'];       

        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id = '$project_id' AND company_id = '$company_id'")[0];       
       
        if($residential == false) {
            $msg = "Invalid request.";
            return response()->json(['status' => 'fail', 'msg' => $msg, 'request'=>$request->all()]);
            exit;
        }

		
		$total_rf   = DB::table(Config::get('constants.tables.requisition'))->select(DB::raw('COUNT(*) as count'))
		->where('company_id', '=', $company_id)            
		->where('residential_id', '=', $project_id)            
		->whereRaw('Date(create_at) = CURDATE()')->value('count');

		$total_rf   = $total_rf + 1;
		$rf_no      = "RF-".$residential->code.date("ymd").str_pad($total_rf, 3, "0", STR_PAD_LEFT);
		
		$data_row['company_id']     = $company_id;
		$data_row['residential_id'] = $request['project_id'];
		$data_row['requisition_no'] = $rf_no;
		$data_row['status']         = 1;
		$data_row['create_by']      = $user_id;
		$data_row['create_at']      = date("Y-m-d H:i:s");

		$id = DB::table(Config::get('constants.tables.requisition'))->insertGetId($data_row);
		       

        if($id) {
            $msg = "RF created! - ID: ".$id;

            foreach($list as $row)   {
                $temp = array();

                $temp['requisition_id'] = $id;
                $temp['item_id']        = $row['id'];
                $temp['qty']            = $row['qty'];
                $temp['status']         = 1;
                $temp['create_by']      = $user_id;
                $temp['create_at']      = date("Y-m-d H:i:s");

                DB::table(Config::get('constants.tables.requisition_item'))->insert($temp);
            }
        }

        // if($request['type'] == "trade") {
        //     $validator = Validator::make($request->all(), [
        //         'trade_name' => 'required|max:1000',    
        //     ]);


        //     $data_row['company_id'] = $company_id;
        //     $data_row['parent_id']  = isset($request['trade_parent']) ? $request['trade_parent'] : 0;
        //     $data_row['name']       = $request['trade_name'];
        //     $data_row['create_by']  = $user_id;
        //     $data_row['create_at']  = date("Y-m-d H:i:s");

        //     $id = DB::table('trade')->insertGetId($data_row);

        // } 

        return response()->json(['status' => 'success', 'msg' => $msg, 'request'=>$request->all(), 'rf_id'=>$id]);
    }  

    public function getRfList(Request $request) {
        // dd($request);
        $user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials 		= Material::getMaterial('trade', $company_id);
        $user_info		= "";
        // dd($request);

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      

        $project_id     = $request['project_id'];
        $by_status      = $request['by_status'];
        $source      	= $request['source'];
        $rf_id      	= ISSET($request['rf_id']) ? $request['rf_id'] : "";

        switch($by_status) {
            case 'pending'      : $by_status = 1;
                break;
			case 'approve'      : $by_status = 2;
                break;
            case 'po' 			: $by_status = 3;
                break;
			case 'do' 			: $by_status = 4;
                break;
            case 'completed'    : $by_status = 5;
                break;
            case 'rejected'     : $by_status = 6;
                break;
        }
        

        // $columnIndex    = "";
        // $columnName     = "name";
        // $columnSortOrder= "asc";
        // $searchValue    = "a";

        // Total records
        $totalRecords           = DB::table(Config::get('constants.tables.requisition'))->select(DB::raw('COUNT(*) as allcount'))
                ->where('residential_id', '=', $project_id)
                ->where('status', '=', $by_status)
                ->where('company_id', '=', $company_id)->value('allcount');  
        // Material::select('count(*) as allcount')->count();
        $totalRecordswithFilter = DB::table(Config::get('constants.tables.requisition'))->select(DB::raw('COUNT(*) as allcount'))
                ->where('residential_id', '=', $project_id)
                ->where('status', '=', $by_status)
                // ->where('requisition_no', 'LIKE', '%'.$searchValue.'%')
				->value('allcount');  
        //Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

        // Fetch records
        // $records = Material::orderBy($columnName,$columnSortOrder)
        // ->where('trade.name', 'like', '%' .$searchValue . '%')
        // ->select('trade.*')
        // ->skip($start)
        // ->take($rowperpage)
        // ->get();
		
		// if($by_status == 3) {
			// $records = DB::table(Config::get('constants.tables.requisition'))->orderBy($columnName,$columnSortOrder)
			// ->leftJoin(Config::get('constants.tables.po'), Config::get('constants.tables.requisition').'.id', '=', Config::get('constants.tables.po').'.requisition_id')	
            // ->where('residential_id', '=', $project_id)
            // ->where('company_id', '=', $company_id)
            // ->where('status', '=', $by_status)
            // ->where('id', '=', $rf_id)
            // ->where('requisition_no', 'LIKE', '%'.$searchValue.'%')->skip($start)->take($rowperpage)->get();  
		// } else 
			
		if($source == "po_edit" && $rf_id != "") {
			$records = DB::table(Config::get('constants.tables.requisition'))
			// ->orderBy($columnName,$columnSortOrder)
            ->where('residential_id', '=', $project_id)
            ->where('company_id', '=', $company_id)
            ->where('status', '=', $by_status)            
            ->where('id', '=', $rf_id)
            // ->where('requisition_no', 'LIKE', '%'.$searchValue.'%')->skip($start)
			->take($rowperpage)->get();  
			
		} else {
			$records = DB::table(Config::get('constants.tables.requisition'))
			// ->orderBy($columnName,$columnSortOrder)
            ->where('residential_id', '=', $project_id)
            ->where('company_id', '=', $company_id)
			->where('status', '>', 1)
			->where('status', '<', 5)
            // ->where('status', '=', $by_status)
            // ->where('requisition_no', 'LIKE', '%'.$searchValue.'%')
			// ->skip($start)
			->take($rowperpage)->get();  
		}

        $data_arr   = array();
        $num        = 1;

		if($records) {
			foreach($records as $record){
				$fid			= $record->id;
				$create_by		= $record->create_by;
				$user_info		= DB::table(Config::get('constants.tables.user'))->select('name', 'tel')
					->where('id', '=', $create_by)->get();  
					
				$requisition_no	= $record->requisition_no;
				$create_at		= $record->create_at;       
				$status			= ($record->status == 1) ? "Pending" : "";
				
				$po	= DB::table(Config::get('constants.tables.po'))->select('id', 'po_no')
					->where('requisition_id', '=', $fid)->get();  
					
				if(count($po) > 0) {
					if(Gate::check('is-site')) {
						$po_text = $po[0]->po_no;
					} else {
						$po_text = '<a class="modal-links po" data-toggle="modal" data-target="#po_form" data-id="'.$po[0]->id.'">'.$po[0]->po_no.'</a>';
					}
				} else {
					$po_text = '';
				}
				
				switch($record->status) {
					case '1'	: $status = "Pending";
						break;
					case '2'	: $status = "Approved";
						break;
					case '3'	: $status = "PO Processed";
						break;
					case '4'	: $status = "DO PRocessed";
						break;
					case '5'	: $status = "Completed";
						break;
					case '6'	: $status = "Rejected";
						break;
					
				}
				
				$total_item         = DB::table(Config::get('constants.tables.requisition_item'))->select(DB::raw('COUNT(*) as allcount'))
					->where('requisition_id', '=', $fid)->value('allcount');
					
				if($source == "po_create" || $source == "po_edit") {					
					//<button type="button" class="btn btn-success font-weight-bold btnApproveRf" data-rf-id="" data-action="approve">Approve RF</button>
					$action	= '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="'.$fid.'">Select</a>';
				} else if($record->status > 1) {
					$action = '';
				} else {
					$action = '<a href="'.$project_id.'/edit/'.$fid.'" class="action-btn"><i class="fas fa-edit" data-id="'.$fid.'"></i></a>';
				}
					
				$data_arr[] = array(
					"id"                => $fid,            
					"requisition_no"    => '<a class="modal-links" data-toggle="modal" data-target="#requisition_form" data-id="'.$fid.'">'.$requisition_no.'</a>',	//$requisition_no,
					"total_item"        => $total_item,
					"create_by"         => $user_info[0]->name,
					"create_at"         => $create_at,
					"contact"           => $user_info[0]->tel,
					"po"            	=> $po_text,
					"do"            	=> "",
					"status"            => "",	//$status,
					"action"            => $action,
					// "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_Item"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
				);

				$num++;
			}
		}
       
        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecords,
            // "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr,
			"user_info"				=> $user_info
        );
        // echo json_encode($response);

        // $response = array(
        //     "recordsTotal"  => intval( $totalRecords ),  // total number of records
		// 	"data"          => $data_arr, // total data array
		// 	"request"       => $request // total data array
        // );

        // echo json_encode(array('draw'=> '', 'recordsTotal'=>$totalData, 'recordsFiltered'=>$totalRecordswithFilter, 'data' => $data, 'request'=>$request)); 
        echo json_encode($response);

        exit;
        
    }

	public function getRfDetail(Request $request) {
        // dd($request);
		define("TABLE_PO", Config::get('constants.tables.po'));
		define("TABLE_PO_ITEM", Config::get('constants.tables.po_item'));
		define("TABLE_REQUISITION", Config::get('constants.tables.requisition'));
		define("TABLE_REQUISITION_ITEM", Config::get('constants.tables.requisition_item'));
		define("TABLE_COMPANY", Config::get('constants.tables.company'));
		define("TABLE_RESIDENTIAL", Config::get('constants.tables.residential'));
		define("TABLE_USER", Config::get('constants.tables.user'));
		define("TABLE_ITEM", Config::get('constants.tables.item'));
		
        $user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials 		= Material::getMaterial('trade', $company_id);		
		$residential 	= DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc"); 
		
		$status 		= "fail";
		$project_id     = $request['project_id'];
		$rf_id     		= $request['id'];		
		$rf_detail		= "";
		$rf_list		= array();
		
		$company_info	= DB::table(TABLE_COMPANY)
			->select(TABLE_COMPANY.'.name AS company_name', TABLE_COMPANY.'.address AS company_addr', TABLE_RESIDENTIAL.'.name AS residential_name', TABLE_RESIDENTIAL.'.address AS residential_addr', TABLE_RESIDENTIAL.'.logo')				
			->leftJoin(TABLE_RESIDENTIAL, TABLE_RESIDENTIAL.'.company_id', '=', TABLE_COMPANY.'.id')			
            ->where(TABLE_COMPANY.'.id', '=', $company_id)           
            ->where(TABLE_RESIDENTIAL.'.id', '=', $project_id)           
            ->get(); 
		
		if($company_info && count($company_info) > 0) {
			$status = "success";			
		} 
		
		$rf_detail 	= DB::table(TABLE_REQUISITION)
			->select(TABLE_REQUISITION.'.*', TABLE_USER.'.name AS creator_name', TABLE_USER.'.tel AS creator_tel')			
			->leftJoin(TABLE_USER, TABLE_USER.'.id', '=', TABLE_REQUISITION.'.create_by')			
            ->where(TABLE_REQUISITION.'.id', '=', $rf_id)
            ->where(TABLE_REQUISITION.'.company_id', '=', $company_id)
            // ->where(TABLE_REQUISITION.'.company_id', '=', '9')           
            ->get(); 
		
		
		$rf_list[]	= DB::table(TABLE_REQUISITION_ITEM)
			->select(TABLE_REQUISITION_ITEM.'.requisition_id AS requisition_id', TABLE_REQUISITION_ITEM.'.id AS rf_item_id', TABLE_REQUISITION_ITEM.'.qty', TABLE_REQUISITION_ITEM.'.remark', TABLE_REQUISITION_ITEM.'.item_id', TABLE_ITEM.'.name', TABLE_ITEM.'.description', TABLE_ITEM.'.unit', TABLE_ITEM.'.img')			
			->leftJoin(TABLE_ITEM, TABLE_REQUISITION_ITEM.'.item_id', '=', TABLE_ITEM.'.id')
			->leftJoin(TABLE_REQUISITION, TABLE_REQUISITION_ITEM.'.requisition_id', '=', TABLE_REQUISITION.'.id')
            ->where(TABLE_REQUISITION.'.id', '=', $rf_id)
            ->where(TABLE_REQUISITION.'.company_id', '=', $company_id)
			->orderBy(TABLE_ITEM.'.name', 'desc')            
            ->get();
		
		$msg	= "";
		
		if($rf_list) {
			foreach($rf_list as $row) {
				// $requisition_id	= $row[0]->requisition_id;
				// $rf_item_id		= $row[0]->rf_item_id;
				$num = 0;
				foreach($row as $rf) {	
					$sql = "";
					$requisition_id	= $rf->requisition_id;
					$rf_item_id		= $rf->rf_item_id;
					$rf_qty			= $rf->qty;
					
					DB::enableQueryLog();
					$total_qty	= DB::table(TABLE_PO_ITEM)->select(DB::raw('SUM('.TABLE_PO_ITEM.'.qty) as total_qty'))
						->leftJoin(TABLE_REQUISITION_ITEM, TABLE_PO_ITEM.'.requisition_item_id', '=', TABLE_REQUISITION_ITEM.'.id')
						->where('requisition_item_id', '=', $rf_item_id)->value('total_qty');			
					// dd(DB::getQueryLog()); 
					$sql = DB::getQueryLog();
						
					$total_qty			= ($total_qty == "") ? 0 : $total_qty;
					$text_qty_ordered	= "";
					$is_available		= "yes";
					
					if($total_qty != 0){
						if($rf_qty > $total_qty) {
							$text_qty_ordered	= '<label style="color:green;">'.$total_qty.'</label>';
							
						} else if($total_qty > $rf_qty) {
							$text_qty_ordered	= '<label style="color:red;">'.$total_qty.'</label>';
							$is_available		= "no";
							
						} else if($total_qty == $rf_qty) {
							// $text_qty_ordered	= '<label style="color:blue;">'.$total_qty.'</label>';
							$text_qty_ordered = $total_qty;
							$is_available		= "no";
							
						} else {
							$text_qty_ordered = $total_qty;
						}
					}
					
					
					$msg	.= "\n[$num] ".$rf_list[0][$num]->name;
					$rf_list[0][$num]->sql			= $sql;
					// $rf_list[0][$num]->qty_ordered 	= ($rf_qty > $total_qty && $total_qty != 0) ? '<label style="color:green;">'.$total_qty.'</label>' : $total_qty;
					$rf_list[0][$num]->qty_ordered	= $text_qty_ordered;
					$rf_list[0][$num]->is_available	= $is_available;
					
					$num++;
				}
				
				
			}
		}
		// return view('material.index', compact('residential', 'user', 'role', 'materials', 'result'));
		 echo json_encode(array('status' => $status, 'company_info' => $company_info, 'rf_detail' => $rf_detail, 'rf_list' => $rf_list, 'msg' => $msg));
	}
	 
    public function showAll_ori($id, $type){
        echo 'RequisitionController > ShowAll > '.$id;       
        // DB::enableQueryLog();
        // print_r($id);
        $user 		= auth()->user();
        $role 		= $user->getRole($user->id);
        $user_id    = $user->id;
       
        $res        = $user->getResidential($user->id);
        $residential_id = $res->residential_id;

        $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'");         
        $count  = $count[0]->count;
      
        if($count == 0) {
            // dd("Permission not allow for the project");
            return redirect()->back(); 
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.role_user')." WHERE id IN ($residential_id) ORDER BY name ASC");           

        return view('requisition.index', compact('residential', 'user', 'role'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {        
        // echo 'RequisitionController > Show > '.$id;       
        // DB::enableQueryLog();
        // print_r($id);
        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res    		= $user->getResidential($user->id);
        $residential_id = $res->residential_id;

        $count  = DB::select("SELECT COUNT(id) as count FROM ".Config::get('constants.tables.role_user')." WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'"); 
        // print_r($count);
        $count  = $count[0]->count;
        // echo 'COUNT : '.$count;
        if($count == 0) {
            // dd("Permission not allow for the project");
            return redirect()->back();  //->with('error', 'Permission not allow for the project');
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

		if(Gate::check('is-site')) {
			return view('site.requisition', compact('residential', 'user', 'role'));
		}
		
        return view('requisition.index', compact('residential', 'user', 'role'));
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, $fid, Request $request)
    {
        echo 'RequisitionController > Edit > '.$id;       
        // DB::enableQueryLog();
        // print_r($id);
        $user 		= auth()->user();
        $role 		= $user->getRole($user->id);
        $user_id    = $user->id;

        $res    = $user->getResidential($user->id);
        $residential_id = $res->residential_id;

        $count  = DB::select("SELECT COUNT(id) as count FROM ".Config::get('constants.tables.role_user')." WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'"); 
        // print_r($count);
        $count  = $count[0]->count;
        // echo 'COUNT : '.$count;
        if($count == 0) {
            // dd("Permission not allow for the project");
            return redirect()->back();  //->with('error', 'Permission not allow for the project');
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('requisition.create', compact('residential', 'user', 'role'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;
       
        $project_id = $request['project_id'];
        $list       = $request['list'];       
        $update_result 	= ""; 
		$status		= "";

        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id = '$project_id' AND company_id = '$company_id'")[0];       
       
        if($residential == false) {
            $msg = "Invalid request.";
            return response()->json(['status' => 'fail', 'msg' => $msg, 'request'=>$request->all()]);
            exit;
        }
		
		// $total_rf   = DB::table(Config::get('constants.tables.requisition'))->select(DB::raw('COUNT(*) as count'))
		// ->where('company_id', '=', $company_id)            
		// ->whereRaw('Date(create_at) = CURDATE()')->value('count');

		// $total_rf   = $total_rf + 1;
		// $rf_no      = "RF-".$residential->code.date("ymd").str_pad($total_rf, 3, "0", STR_PAD_LEFT);
		
		$data_row['company_id']     = $company_id;
		$data_row['residential_id'] = $request['project_id'];
		// $data_row['requisition_no'] = $rf_no;
		$data_row['status']         = 1;
		$data_row['create_by']      = $user_id;
		$data_row['create_at']      = date("Y-m-d H:i:s");
		
		DB::table(Config::get('constants.tables.requisition_item'))->where('requisition_id', $id)->delete();		       

        if($id) {
            $msg = "RF updated! - ID: ".$id;

            foreach($list as $row)   {
                $temp = array();

                $temp['requisition_id'] = $id;
                $temp['item_id']        = $row['id'];
                $temp['qty']            = $row['qty'];
                $temp['status']         = 1;
                $temp['create_by']      = $user_id;
                $temp['create_at']      = date("Y-m-d H:i:s");

                $update_result = DB::table(Config::get('constants.tables.requisition_item'))->insert($temp);
            }
			
			if($update_result) {
				$status = "success";
			} else {
				$status = "fail";
				$msg 	= "Failed to update.";
			}
        }
		
		return response()->json(['status' => $status, 'msg' => $msg, 'request'=>$request->all(), 'rf_id'=>$id]);
    }
	
	public function updateRf(Request $request)
	{
		$user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;
       
        $project_id 	= $request['project_id'];
        $list       	= $request['list'];       
        $rf_id       	= $request['id'];       
        $update_status  = $request['status'];       
        $update_result 	= ""; 
		$status			= "fail";

        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id = '$project_id' AND company_id = '$company_id'")[0];       
       
        if($residential == false) {
            $msg = "Invalid request.";
            return response()->json(['status' => 'fail', 'msg' => $msg, 'request'=>$request->all()]);
            exit;
        }
				
		switch($update_status) {
			case 'approve'	: $update_status = 2;
				break;
			case 'reject'	: $update_status = 6;
				break;
		}
		
		$temp = array();
		$temp['id'] 			= $rf_id;		
		$temp['status']         = $update_status;
		$temp['approve_by']     = $user_id;
		$temp['approve_at']     = date("Y-m-d H:i:s");
		try {
			$update_result = DB::table(Config::get('constants.tables.requisition'))->where('id', '=', $rf_id)->update($temp);
			$msg 		= "Update successful";
			$status 	= "success";
		} catch(Exception $e) {
			$msg 	= "Update fail.";
		}		
		
		return response()->json(['status' => $status, 'msg' => $msg, 'request'=>$request->all(), 'rf_id'=>$rf_id]);
	}

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
