<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreUserRequest;
use App\Models\User;
use App\Models\Role;
use App\Models\Residential;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(Gate::denies('logged-in')) {
            dd('no access allowed');
            // return view('auth.login');
        } 

        if(Gate::check('is-admin')) {
            // $residential = Residential::all();
            // $user        = User::all();
            // $role        = Role::all();
            DB::enableQueryLog();

            $user 		= auth()->user();
            $role 		= $user->getRole($user->id);
            $user_id	= $user->id;

            $res    	= $user->getResidential($user->id);
            $residential_id = $res->residential_id;
            
            $residential = DB::select("SELECT * FROM residential WHERE id IN ($residential_id) order by name asc");
           
            // dd(DB::getQueryLog());
            // $residential = Residential::all();
            // dd($residential);
            // print_r($role);
            echo 'residential_id: '.$residential_id;
            // print_r($residential);

            // $users = DB::table('users')->get();
            // $users = DB::table('users')->where('company_id', 'John')->first();
			return view('admin.dashboard.index', compact('residential', 'user', 'role'));
			
        } else {
			return redirect('/login');
		}

        // return view('admin.dashboard.index', ['residential' => $residential, 'user' => $user, 'role' => $role]);
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
