<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo $__env->yieldContent('title'); ?></title>

        <!-- Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />

        <!-- Styles -->
        
        <link rel="shortcut icon" href="<?php echo e(asset('media/favicon.ico')); ?>" type="image/x-icon">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/custom/fullcalendar/fullcalendar.bundle.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/global/plugins.bundle.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/custom/prismjs/prismjs.bundle.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/style.bundle.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/themes/layout/header/base/light.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/themes/layout/header/menu/light.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/themes/layout/brand/dark.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/themes/layout/aside/dark.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.css')); ?>">
        <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/custom.css')); ?>">       

         <!-- JS -->
        <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    </head>
    <body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('logged-in')): ?>
    <?php
        $header_name = "Dashboard";
        $residential_id = "";
        $user = auth()->user();
        $role = $user->getRole($user->id);
        $rolename = $role != null ? $role->name : "";
        $cur_page = Request::segment(2) == "" ? Request::segment(1) : Request::segment(2);

        if($cur_page == "admin") {
            $header_name = "Dashboard";

        } else if($cur_page == "requisition") {           
            $header_name = "Requisition Form List";
            $residential_id =  $header_name." > ".Request::segment(3);

            if(Request::segment(4) == "create") {
                $header_name = "Create Requisition";
            }

        } else if($cur_page == "ro") { 
            $header_name = "Request Order";

            if(Request::segment(3) != "") {
                $action = Request::segment(3);
                $header_name = $header_name." > ". ucfirst($action)." Request Order";
            }
         
        } else if($cur_page == "material") { 
            $header_name = "Material Setting";
            if(Request::segment(4) != "") {
                $action = Request::segment(4);
                $header_name = $header_name." > ".ucfirst($action)." ".ucfirst(Request::segment(3));
            }

        } else if($cur_page == "do") { 
            $header_name = "Delivery Order";
        
        } else if($cur_page == "stock-transfer") { 
            $header_name = "Stock Transfer";

        } else if($cur_page == "inventory") { 
            $header_name = "Inventory";

        } else if($cur_page == "users") { 
            $header_name = "Staff Setting";

        } else if($cur_page == "overview") { 
            $header_name = "Overview";
            $residential_id = Request::segment(3);

        } else {
            $header_name = "";
            
        }
        echo 'cur_page: '.$cur_page;
    ?> 
        <div id="kt_header_mobile" class="header-mobile align-items-center header-mobile-fixed">
            <a href="<?php echo e(url('/home')); ?>">
                <img alt="Logo" src="<?php echo e(asset('media/logo1.png')); ?>" width="170px" />
            </a>
            <div class="d-flex align-items-center">
                <button class="btn p-0 burger-icon burger-icon-left" id="kt_aside_mobile_toggle">
                    <span></span>
                </button>
                <button class="btn btn-hover-text-primary p-0 ml-2" id="kt_header_mobile_topbar_toggle">
                    <span class="svg-icon svg-icon-xl">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                            height="24px" viewBox="0 0 24 24" version="1.1">
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <polygon points="0 0 24 0 24 24 0 24" />
                                <path
                                    d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z"
                                    fill="#000000" fill-rule="nonzero" opacity="0.3" />
                                <path
                                    d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z"
                                    fill="#000000" fill-rule="nonzero" />
                            </g>
                        </svg>
                    </span>
                </button>
            </div>
        </div>

        <div class="d-flex flex-column flex-root">
            <div class="d-flex flex-row flex-column-fluid page">
                <?php echo $__env->make('layouts.side', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>           
        
                <div class="d-flex flex-column flex-row-fluid wrapper" id="kt_wrapper">
                    <div id="kt_header" class="header header-fixed">
                        <div class="container-fluid d-flex align-items-stretch justify-content-between">
                            <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap head-title mr-15">
                                <div class="d-flex align-items-center flex-wrap">
                                    <ul class="logo-title">
                                        <li><img src="<?php echo e(asset('media/tachometer-alt-solid.svg')); ?>" class="svg-icon"></li>
                                        <li><h5><?php echo e($header_name); ?></h5></li>
                                    </ul>
                                </div>
                            </div>

                            <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
                                <div class="topbar">
                                    <div class="dropdown">
                                        <div class="topbar-item" data-toggle="dropdown" data-offset="10px,0px">
                                            <div class="btn btn-icon btn-icon-mobile w-auto d-flex align-items-center btn-lg px-2">
                                                <h6 class="mb-0">Good day, <?php echo e($user->name); ?>!</h6>
                                            </div>
                                        </div>
                                        <div class="dropdown-menu p-0 m-0 dropdown-menu-right dropdown-menu-anim-up dropdown-menu-md profile-dropdown">
                                            <div class="row px-10 py-5">
                                                <div class="symbol symbol-100 mr-5">
                                                    <span class="symbol symbol-lg-60 symbol-25 symbol-light-success">
                                                        <span class="symbol-label font-size-h1 font-weight-bold"></span>
                                                    </span>
                                                </div>
                                                <div class="d-flex flex-column">
                                                    <div class="text-muted"><a href="hq-profile.html">Edit Profile</a></div>
                                                    <div class="text-muted"><?php echo e($rolename); ?></div>
                                                    <div class="navi mt-1">
                                                        <a href="<?php echo e(route('logout')); ?>" class="btn btn-sm btn-light-primary font-weight-bolder py-2 px-5" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Sign Out</a>
                                                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display:none">
                                                            <?php echo csrf_field(); ?>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php echo $__env->make('partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    
                    <?php echo $__env->yieldContent('content'); ?>
                
                </div>  
            </div>
        </div>
        <!-- Scrolltop-->
        <div id="kt_scrolltop" class="scrolltop">
            <span class="svg-icon">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                    height="24px" viewBox="0 0 24 24" version="1.1">
                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <polygon points="0 0 24 0 24 24 0 24" />
                        <rect fill="#000000" opacity="0.3" x="11" y="10" width="2" height="10" rx="1" />
                        <path
                            d="M6.70710678,12.7071068 C6.31658249,13.0976311 5.68341751,13.0976311 5.29289322,12.7071068 C4.90236893,12.3165825 4.90236893,11.6834175 5.29289322,11.2928932 L11.2928932,5.29289322 C11.6714722,4.91431428 12.2810586,4.90106866 12.6757246,5.26284586 L18.6757246,10.7628459 C19.0828436,11.1360383 19.1103465,11.7686056 18.7371541,12.1757246 C18.3639617,12.5828436 17.7313944,12.6103465 17.3242754,12.2371541 L12.0300757,7.38413782 L6.70710678,12.7071068 Z"
                            fill="#000000" fill-rule="nonzero" />
                    </g>
                </svg>
            </span>
        </div>    
    <?php else: ?>
        <main class="container">
            <?php echo $__env->make('partials.alerts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->yieldContent('content'); ?>
        </main>        
    <?php endif; ?>      
        
    </body>
</html>

<script src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/common.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/global/plugins.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/custom/prismjs/prismjs.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('js/scripts.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/custom/fullcalendar/fullcalendar.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('js/pages/widgets.js')); ?>"></script>
<script src="<?php echo e(asset('js/pages/features/charts/apexcharts.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
<script src="<?php echo e(asset('js/datatable-custom.js')); ?>"></script>
<?php echo $__env->yieldContent('custom_js'); ?>
<?php /**PATH D:\laravel\inventory\resources\views/layouts/app.blade.php ENDPATH**/ ?>