<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\OverviewController;
use App\Http\Controllers\RequisitionController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\RequestOrderController;
use App\Http\Controllers\MaterialController;
use App\Http\Controllers\DeliveryOrderController;
use App\Http\Controllers\InventoryController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\StockTransferController;
use App\Http\Controllers\ImageUploadController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('auth.login');
// })->middleware(['auth']);

Route::get('/inventory', function () {
    // return view('index');
    return redirect('/login');
});

// Route::get('/logout', function () {
    // auth()->logout();
    // Session()->flush();

    // return Redirect::to('/');
// })->name('logout');

// Route::view('/', 'auth.login');

Route::get('redirects', 'App\Http\Controllers\HomeController@index');

//Admin Routes
// Route::prefix('admin')->name('admin.')->group(function () {
//     Route::resource('/users', UserController::class);
//     // Route::resource('/users', UserController::class);
// }); 
// Route::get('/admin/requisition/{id}/{type}','RequisitionController@show_all')->name('admin.requisition.show.all');


Route::prefix('admin')->middleware(['auth', 'auth.isAdmin'])->name('admin.')->group(function() {    
    Route::resource('/', AdminController::class);
	
	Route::post('/profile', [UserController::class, 'profile']);
	Route::get('/profile', [UserController::class, 'profile']);
	Route::put('/profile/update', [UserController::class, 'updateProfile']);
	
    Route::post('/users/list', [UserController::class, 'getUserList']);
    Route::put('/users/store', [UserController::class, 'store']);
    Route::get('/users/show/{id}', [UserController::class, 'show']);
    Route::post('/users/update/{id}', [UserController::class, 'update']); 
    Route::resource('/users', UserController::class);
      
    Route::resource('/overview', OverviewController::class); 
    // Route::get('/requisition/{id}/{type}/show', [RequisitionController::class, 'showAll']);
    // Route::get('/requisition/{id}/list', [RequisitionController::class, 'show']);
	Route::post('/requisition/detail', [RequisitionController::class, 'getRfDetail']);
    Route::get('/requisition/detail', [RequisitionController::class, 'getRfDetail']);
    Route::post('/requisition/list', [RequisitionController::class, 'getRfList']);
    Route::get('/requisition/list', [RequisitionController::class, 'getRfList']);
    Route::get('/requisition/{id}/create', [RequisitionController::class, 'create']);
    Route::get('/requisition/{id}/edit/{fid}', [RequisitionController::class, 'edit']);
    Route::put('/requisition/store', [RequisitionController::class, 'store']);    
    Route::put('/requisition/update/{id}', [RequisitionController::class, 'update']);    
    Route::put('/requisition/update_rf', [RequisitionController::class, 'updateRf']);    
    Route::resource('/requisition', RequisitionController::class);    

	Route::post('/po/detail', [PurchaseOrderController::class, 'getPoDetail']);
    Route::get('/po/detail', [PurchaseOrderController::class, 'getPoDetail']);
	Route::post('/po/list', [PurchaseOrderController::class, 'getPoList']);
	Route::get('/po/list', [PurchaseOrderController::class, 'getPoList']);
	Route::get('/po/{id}/create', [PurchaseOrderController::class, 'create']);
    Route::get('/po/{id}/edit/{fid}', [PurchaseOrderController::class, 'edit']);
	Route::put('/po/store', [PurchaseOrderController::class, 'store']);    
	Route::put('/po/update/{id}', [PurchaseOrderController::class, 'update']); 
    Route::resource('/po', PurchaseOrderController::class);
	
    Route::resource('/ro', RequestOrderController::class);
    
    Route::get('/material/trade', [MaterialController::class, 'show_trade']);
    Route::post('/material/trade/list', [MaterialController::class, 'getTradeList']);
    Route::get('/material/trade/list', [MaterialController::class, 'getTradeList']);
    Route::get('/material/{type}/create', [MaterialController::class, 'create']);
    Route::post('/material/{type}/create', [MaterialController::class, 'store']);
    Route::get('/material/{type}/edit/{id}', [MaterialController::class, 'edit']);
    Route::post('/material/{type}/edit/{id}', [MaterialController::class, 'edit']);
    Route::post('/material/{type}/update/{id}', [MaterialController::class, 'update']);
    Route::get('/material/item', [MaterialController::class, 'show_item']);   
    Route::post('/material/item/list', [MaterialController::class, 'getItemList']);   
    Route::get('/material/item/list', [MaterialController::class, 'getItemList']);   
    Route::post('/material/{type}/import', [MaterialController::class, 'import']);
    Route::get('/material/{type}/import', [MaterialController::class, 'import']);    
    Route::get('/material/category', [MaterialController::class, 'show_category']);
    Route::get('/material/category/list', [MaterialController::class, 'getCategoryList']);
    Route::post('/material/category/list', [MaterialController::class, 'getCategoryList']);
    Route::post('/material/search', [MaterialController::class, 'search_material']);
    Route::resource('/material', MaterialController::class);
	
	Route::post('/do/detail', [DeliveryOrderController::class, 'getDoDetail']);
	Route::get('/do/detail', [DeliveryOrderController::class, 'getDoDetail']);
	Route::post('/do/list', [DeliveryOrderController::class, 'getDoList']);
	Route::get('/do/list', [DeliveryOrderController::class, 'getDoList']);
	Route::put('/do/update_status/{id}', [DeliveryOrderController::class, 'update_status']); 
	Route::resource('/do', DeliveryOrderController::class);
	
	Route::post('/inventory/log', [InventoryController::class, 'getInventoryLog']);
	Route::get('/inventory/log', [InventoryController::class, 'getInventoryLog']);
	Route::get('/inventory/{id}/detail', [InventoryController::class, 'edit']);
	Route::post('/inventory/list', [InventoryController::class, 'getInventoryList']);
	Route::get('/inventory/list', [InventoryController::class, 'getInventoryList']);
    Route::resource('/inventory', InventoryController::class);
	
    Route::resource('/stock-transfer', StockTransferController::class);

    Route::get('/imageUpload', [ImageUploadController::class, 'imageUpload']);
    Route::post('/imageUpload/delete', [ImageUploadController::class, 'deleteImage']);
    Route::post('/imageUpload', [ImageUploadController::class, 'imageUploadPost'])->name('imageUpload');
	
	Route::get('/fileUpload', [ImageUploadController::class, 'imageUpload']);
    Route::post('/fileUpload/delete', [ImageUploadController::class, 'deleteFile']);
    Route::post('/fileUpload', [ImageUploadController::class, 'fileUploadPost'])->name('fileUpload');
    // Route::get('/requisition/{id}/{type}','RequisitionController@show')->name('admin.requisition.show');
    
    // Route::resource('/admin', UserController::class);
    // Route::get('/admin/dashboard', function() {
    //     return view('admin.dashboard.index');
    // });

    // Route::resource('/dashboard', AdminController::class);
});

Route::prefix('site')->middleware(['auth.isSite'])->name('site.')->group(function() {
	Route::resource('/', SiteController::class);
	Route::resource('/overview', OverviewController::class);
	
	Route::post('/profile', [UserController::class, 'profile']);
	Route::get('/profile', [UserController::class, 'profile']);
	Route::put('/profile/update', [UserController::class, 'updateProfile']);
	
	Route::post('/requisition/detail', [RequisitionController::class, 'getRfDetail']);
    Route::get('/requisition/detail', [RequisitionController::class, 'getRfDetail']);
    Route::post('/requisition/list', [RequisitionController::class, 'getRfList']);
    Route::get('/requisition/list', [RequisitionController::class, 'getRfList']);
    Route::get('/requisition/{id}/create', [RequisitionController::class, 'create']);
    Route::get('/requisition/{id}/edit/{fid}', [RequisitionController::class, 'edit']);
    Route::put('/requisition/store', [RequisitionController::class, 'store']);    
    Route::put('/requisition/update/{id}', [RequisitionController::class, 'update']);    
    Route::put('/requisition/update_rf', [RequisitionController::class, 'updateRf']);    
    Route::resource('/requisition', RequisitionController::class);
	
	Route::post('/po/detail', [PurchaseOrderController::class, 'getPoDetail']);
    Route::get('/po/detail', [PurchaseOrderController::class, 'getPoDetail']);
	Route::post('/po/list', [PurchaseOrderController::class, 'getPoList']);
	Route::get('/po/list', [PurchaseOrderController::class, 'getPoList']);
	// Route::get('/po/{id}/create', [PurchaseOrderController::class, 'create']);
    // Route::get('/po/{id}/edit/{fid}', [PurchaseOrderController::class, 'edit']);
	// Route::put('/po/store', [PurchaseOrderController::class, 'store']);    
	// Route::put('/po/update/{id}', [PurchaseOrderController::class, 'update']); 
	Route::resource('/po', PurchaseOrderController::class);
	
	Route::post('/do/detail', [DeliveryOrderController::class, 'getDoDetail']);
	Route::get('/do/detail', [DeliveryOrderController::class, 'getDoDetail']);
	Route::post('/do/list', [DeliveryOrderController::class, 'getDoList']);
	Route::get('/do/list', [DeliveryOrderController::class, 'getDoList']);
	Route::put('/do/update_status/{id}', [DeliveryOrderController::class, 'update_status']); 
	Route::resource('/do', DeliveryOrderController::class);
	
	Route::post('/inventory/log', [InventoryController::class, 'getInventoryLog']);
	Route::get('/inventory/log', [InventoryController::class, 'getInventoryLog']);
	Route::get('/inventory/{id}/detail', [InventoryController::class, 'edit']);
	Route::post('/inventory/list', [InventoryController::class, 'getInventoryList']);
	Route::get('/inventory/list', [InventoryController::class, 'getInventoryList']);
	Route::resource('/inventory', InventoryController::class);
});

//Route::prefix('admin')->middleware(['auth', 'auth.isAdmin'])->name('admin.')->group(function() {    
Route::prefix('vendors')->middleware(['auth.isVendor'])->name('vendors.')->group(function() {    
    Route::resource('/overview', OverviewController::class);
	
	Route::post('/profile', [UserController::class, 'profile']);
	Route::get('/profile', [UserController::class, 'profile']);
	Route::put('/profile/update', [UserController::class, 'updateProfile']);
	
	Route::put('/do/update/{id}', [VendorController::class, 'update']); 
	Route::put('/do/update_status/{id}', [VendorController::class, 'update_status']); 
	Route::put('/do/store', [VendorController::class, 'store']);
	Route::get('/do/{id}/create', [VendorController::class, 'create']);
	Route::get('/do/{id}/edit/{fid}', [VendorController::class, 'edit']);
	Route::post('/do/detail', [VendorController::class, 'getDoDetail']);
	Route::get('/do/detail', [VendorController::class, 'getDoDetail']);
	Route::post('/do/list', [VendorController::class, 'getDoList']);
	Route::get('/do/list', [VendorController::class, 'getDoList']);
	Route::get('/do/{id}', [VendorController::class, 'show_do']);
	Route::resource('/do', VendorController::class);
	
	// Route::put('/po/store', [VendorController::class, 'store']);    
	// Route::post('/po/update', [VendorController::class, 'po_update']);
	Route::put('/po/update/{id}', [VendorController::class, 'update']); 
	Route::put('/po/update_status/{id}', [VendorController::class, 'update_status']); 	
	Route::post('/po/detail', [VendorController::class, 'getPoDetail']);
    Route::get('/po/detail', [VendorController::class, 'getPoDetail']);
	Route::post('/po/list', [VendorController::class, 'getPoList']);
	Route::get('/po/list', [VendorController::class, 'getPoList']);
	Route::get('/po/{id}', [VendorController::class, 'show_po']);
	Route::resource('/', VendorController::class);
	
	Route::get('/fileUpload', [ImageUploadController::class, 'imageUpload']);
    Route::post('/fileUpload/delete', [ImageUploadController::class, 'deleteFile']);
    Route::post('/fileUpload', [ImageUploadController::class, 'fileUploadPost'])->name('fileUpload');
});

