@extends('layouts.app')
@section('title') Material | Import @endsection

@php
    $type = Request::segment(3);
@endphp

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{$title}}</h3>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    {{-- @if(session()->has('success'))
                    <div class="alert alert-success">
                        {{ session()->get('success') }}
                    </div>
                    @endif --}}

                    <form role="form" method="post" action="{{ url('/admin/material/'.$type.'/import') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label>Document (.xlsx) <small style="color: red">*</small></label>
                            <input type="file" name="file1" class="form-control" required>
                            <a href="{{$template}}">Download Template</a>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-success">SUBMIT</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection