@extends('layouts.app')

@section('title') Trade | Edit @endsection

@section('content')

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">    
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="alert alert-danger print-error-msg" style="display:none">
                <ul></ul>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <form id="form_trade">                       
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Parent trade :</label>
                            <div class="col-lg-9">
                                <select name="trade_parent" class="form-control selectpicker" data-live-search="true" data-size="4">
                                    <option data-tokens="-">-</option>
                                @foreach ($trades as $trade)
                                    <option data-tokens="{{ $trade->id }}">{{ $trade->name }}</option>
                                @endforeach                                    
                                </select>
                            </div>
                        </div>
                         <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Trade Name :</label>
                            <div class="col-lg-9">
                                <input class="form-control" type="text" name="trade_name" value="{{ $material_details[0]->name }}" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Trade Description :</label>
                            <div class="col-lg-9">
                                <textarea class="form-control" type="text" rows="4" name="trade_desc"></textarea>
                            </div>
                        </div>
                       
                    </form>
                    
                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <a href="#" class="btn btn-primary font-weight-bolder btnSaveTrade">Save</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
			
@endsection

@section('custom_js')
<script src="{{ asset('js/material.js') }}"></script>
@endsection