@extends('layouts.app')

@section('title') Item | Edit @endsection

@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <form id="form_item">
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Trade :</label>
                            <div class="col-lg-9">
                                <select id="trade" class="form-control selectpicker" multiple data-live-search="true" data-size="4">
                                    <option data-tokens="-">-</option>
                                @foreach ($trades as $trade)
                                    <option value="{{ $trade->id }}" data-tokens="{{ $trade->id }}" {{ $trade->id == $item_details[0]->trade_id ? 'selected' : '' }} >{{ $trade->name }}</option>
                                @endforeach        
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Item Name :</label>
                            <div class="col-lg-9">
                                <input class="form-control" type="text" name="item_name" value="{{ $item_details[0]->name }}" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Item Description :</label>
                            <div class="col-lg-9">
                                <textarea class="form-control" type="text" rows="4" name="item_desc">{{ $item_details[0]->description }}</textarea>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Unit :</label>
                            <div class="col-lg-9">
                                <select id="item_unit" class="form-control selectpicker" data-live-search="true" data-size="4">
                                @foreach ($measurements as $measurement)
                                    <option data-tokens="{{ $measurement->name }}" {{ $measurement->name == $item_details[0]->unit ? 'selected' : '' }}>{{ $measurement->name }}</option>
                                @endforeach                                   
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Upload Image :</label>
                            <div class="col-lg-9">
                                <div></div>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" id="item_image"/>
                                    <label class="custom-file-label" for="item_image">Choose file</label>
                                </div>
                                @php
                                    $img = $item_details[0]->img;
                                @endphp
                               
                                <div class="img_preview mt-5">
                                    @if($img != "")                           
                                    <div class="img_item" data-file="{{ $img }}">
                                        <a href="#img1">
                                            <div class="thumb_img" style="background-image: url({{ asset('images') }}/{{ $company_id }}/{{ $img }});"></div>
                                        </a>
                                        <a href="#" class="delete_img" data-toggle="modal" data-file="{{ $img }}" data-target="#ConfirmDelete" data-id="{{ $item_details[0]->id }}"><i class="fas fa-times"></i></a>
                                        <a href="#" class="lightbox" id="img1">
                                            <span style="background-image: url({{ asset('images') }}/{{ $company_id }}/{{ $img }})"></span>
                                        </a>
                                    </div>  
                                    @endif                                 
                                </div>                               
                            </div>
                        </div>
                        
                    </form>
                    
                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <a href="#" class="btn btn-primary font-weight-bolder btnSaveItem" data-id="{{ $item_details[0]->id }}">Save</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
			
@endsection

@section('custom_js')
<script src="{{ asset('js/material.js') }}"></script>
<script>
    const ui = {
        confirm: async (message) => createConfirm(message)
    }

    const createConfirm = (message) => {
        return new Promise((complete, failed)=>{
            $('#confirmMessage').text(message)

            $('#confirmYes').off('click');
            $('#confirmNo').off('click');
            
            $('#confirmYes').on('click', ()=> { $('.confirm').hide(); complete(true); });
            $('#confirmNo').on('click', ()=> { $('.confirm').hide(); complete(false); });
            
            $('.confirm').show();
        });
    }
                        
    const save = async () => {
        const confirm = await ui.confirm('Are you sure to update the user?');
        
        if(confirm){
            alert('yes clicked');
        } else{
            alert('no clicked');
        }
    }
</script>
@endsection

