<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>@yield('title')</title>

        <!-- Fonts -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" />

        <!-- Styles -->
        <link rel="stylesheet" href="{{ asset('css/app.css') }}" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="{{ asset('plugins/custom/fullcalendar/fullcalendar.bundle.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('plugins/global/plugins.bundle.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('plugins/custom/prismjs/prismjs.bundle.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('css/style.bundle.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('css/themes/layout/header/base/light.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('css/themes/layout/header/menu/light.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('css/themes/layout/brand/dark.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('css/themes/layout/aside/dark.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('plugins/custom/datatables/datatables.bundle.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('css/custom.css') }}">
        <link rel="shortcut icon" href="{{ asset('media/logo.png') }}" />

         <!-- JS -->
        <script src="{{ asset('js/app.js') }}" defer></script>
    </head>
    <body>
        <nav class="navbar navbar-expand-lg bg-dark">
            <div class="container">
                <a class="navbar-brand" href="#">Inventory</a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>              
                <div class="form-inline my-2 my-lg-0">            
                    @if (Route::has('login'))
                        <div>
                            @auth
                                <a href="{{ url('/home') }}">Home</a>
                                
                                <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">Logout</a>

                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display:none">
                                    @csrf
                                </form>
                            @else                                   
                                <a href="{{ route('login') }}">Login</a>

                                @if (Route::has('register'))
                                    <a href="{{ route('register') }}">Register</a>
                                @endif
                            @endauth
                        </div>
                    @endif
                </div>                    
            </div>
        </nav>
        @can('logged-in')
        <nav class="navbar sub-nav navbar-expand-lg">
            <div class="container-fluid">                
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                        <li class="nav-item">
                            <a class="nav-link active" aria-current="page" href="#">Home</a>
                        </li>
                    @can('is-admin')
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('admin.users.index') }}">Users</a>
                        </li>    
                    @endcan                                            
                    </ul>                    
                </div>
            </div>
        </nav>
        @endcan
       
        <main class="container">
            @include('partials.alerts')
            @yield('content')
        </main>
        
    </body>
</html>
