@extends('layouts.app')
@section('title')
    Users
@endsection

@php
    
@endphp
@section('content')
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="d-flex align-items-stretch justify-content-between mb-2">
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap mr-15">
                    
                </div>

                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
                    <a href="" class="btn btn-primary font-weight-bold btnAddUser" data-toggle="modal" data-target="#edit_User"><i class="la la-plus"></i>Add User</a>
                    {{-- <a href="{{ url('admin/users/create') }}" class="btn btn-primary font-weight-bolder"><i class="la la-plus"></i>Add User</a> --}}
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12" id="ListTable">                   
                    <!-- Datatable (JS in datatable-custom.js) -->
                    <table class="table table-bordered mt-15 table_pm_staff_settings table-hover" id="pm_staff_settings">
                        <thead>
                            <tr>
                                <th>#</th>                                                         
                                <th>Name</th>
                                <th>Email</th>
                                <th>Contact</th>
                                <th>Role</th>
                                <th>Project</th>                           
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        @php
                            $count = 0;
                            
                        @endphp
                        @foreach ($users as $user)
                        @php                       
                            // $user = $user[0];   
                            $status = ($user->status) == 0 ? "Inactive" : "Active";                  
                            $count++;
                        @endphp
                            <tr>
                                <td>{{ $count }}</td>                                
                                <td style="text-align:left;">{{ $user->name }}</td>
                                <td style="text-align:left;">{{ $user->email }}</td>
                                <td>{{ $user->tel }}</td>
                                <td>{{ $user->role }}</td>
                                <td>Arte Cheras</td>      
                                <td>{{ $status }}</td>
                                <td data-id="{{ $user->id }}"></td>
                            </tr>
                        @endforeach                            
                        </tbody>
                    </table>
                </div>

                {{-- <div class="col-sm-12 mt-5">
                    <a href="" class="btn btn-primary font-weight-bold" data-toggle="modal" data-target="#add_User">Add User</a>
                </div> --}}
            </div>


            <!-- Modal Edit User -->
            {{-- <div class="modal fade" id="edit_User" tabindex="-1" role="dialog" aria-labelledby="edit_User" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-12 text-center">
                                    <i class="fas fa-exclamation-circle text-danger font-size-h1"></i>
                                    <p class="font-size-h3 mt-3">Are you sure to update the user?</p>
                                    <h3>Cyndy Wong</h3>
                                    <form>
                                        <table class="table table_editUser table-bordered">
                                            <tr>
                                                <th>Project</th>
                                                <th>Role</th>
                                                <th>Name</th>
                                                <th>Contact</th>
                                                <th>Email</th>
                                                <th>Status</th>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <select class="form-control selectpicker" data-size="3">
                                                        <option>Arte Cheras</option>
                                                        <option>Arte MK</option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <select class="form-control selectpicker" data-size="3">
                                                        <option>Site Office Admin</option>
                                                        <option>Stock Officer</option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <input class="form-control" type="text" value="Cyndy Wong">
                                                </td>
                                                <td>
                                                    <input class="form-control" type="text" value="012-225 9887">
                                                </td>
                                                <td>
                                                    <input class="form-control" type="email" value="cyndy.wong@kpm.com.my">
                                                </td>
                                                <td>
                                                    <select class="form-control selectpicker" data-size="3">
                                                        <option>Active</option>
                                                        <option>Inactive</option>
                                                    </select>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-success font-weight-bold">Confirm</button>
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div> --}}

            <div class="modal fade" id="edit_User" tabindex="-1" role="dialog" aria-labelledby="edit_User" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title user-name"></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <i aria-hidden="true" class="ki ki-close"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form>
                                <div class="form-group row">
                                    {{-- <div class="col-lg-6">
                                        <label>Project</label>
                                        <select class="form-control selectpicker" multiple data-size="3">
                                            <option selected>Arte Cheras</option>
                                            <option>Arte MK</option>
                                        </select>
                                    </div> --}}
                                    <div class="col-lg-6">
                                        <label>Role</label>
                                        <select class="form-control selectpicker" data-size="3" id="user-role">
										<option disabled selected>Select Role</option>
                                        @foreach ($role_list as $list)
                                            <option value="{{ $list->id }}">{{ $list->name }}</option>
                                        @endforeach                                           
                                        </select>
                                    </div>
                                </div>
								<div id="vendor_dropdown" class="form-group row" style="display:none;">                                   
                                    <div class="col-lg-6">
                                        <label>Vendor Company</label>
                                        <select class="form-control selectpicker" data-size="3" id="user-vendor">
										<option disabled selected>Select Vendor Company</option>
                                        @foreach ($vendor_list as $vendor)
                                            <option value="{{ $vendor->id }}">{{ $vendor->company_name }} ({{ $vendor->company_no }})</option>
                                        @endforeach                                           
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group" id="user-project">
                                    <label>Projects</label>
                                    <div class="checkbox-inline row">
                                    @foreach ($res_list as $list)
                                        <div class="col-sm-4">
                                            <label class="checkbox">
                                                <input type="checkbox" name="project" value="{{ $list->id }}" />
                                                <span></span>
                                                {{ $list->name }} - {{ $list->id }}
                                            </label>
                                        </div>
                                    @endforeach
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <div class="col-lg-6">
                                        <label>Name</label>
                                        <input id="user-name" class="form-control user-name" type="text" value="">
                                    </div>
                                    <div class="col-lg-6">
                                        <label>Contact</label>
                                        <input id="user-contact" class="form-control" type="text" value="">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-lg-6">
                                        <label>Email</label>
                                        <input id="user-email" class="form-control" type="email" value="">
                                    </div>
                                    <div class="col-lg-6">
                                        <label>Status</label>
                                        <select class="form-control selectpicker" data-size="3" id="user-status">
                                            <option value="1">Active</option>
                                            <option value="0">Inactive</option>
                                        </select>
                                    </div>
                                </div>
								<div class="form-group row">
                                    <div class="col-lg-6">
                                        <label>Password</label>
                                        <input id="user-pass" class="form-control user-pass" type="password" value="">
                                    </div>
                                    <div class="col-lg-6">
                                        <label>Confirm Password</label>
                                        <input id="user-confirm-pass" class="form-control user-confirm-pass" type="password" value="">
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-success font-weight-bold btnSaveStaff" data-id="">Save</button>
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Cancel</button>
                        </div>

                        <div class="confirm">
                            <div></div>
                            <div>
                                <div id="confirmMessage">Confirm text</div>
                                <div>
                                    <input class="btn btn-sm btn-light-success font-weight-bold" id="confirmYes" type="button" value="Yes" />
                                    <input class="btn btn-sm btn-light-primary font-weight-bold" id="confirmNo" type="button" value="No" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal Add User -->           
            {{-- <div class="modal fade" id="add_User" tabindex="-1" role="dialog" aria-labelledby="add_User" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Add User</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <i aria-hidden="true" class="ki ki-close"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            
                            <div id="kt_repeater_1">
                                <div class="form-group row mb-0">
                                    <div class="col-sm-12">
                                        <table class="table table-bordered table_add_user">
                                            <tr>
                                                <th>Project</th>
                                                <th>Role</th>
                                                <th>Name</th>
                                                <th>Contact</th>
                                                <th>Email</th>
                                                <th>Action</th>
                                            </tr>
                                            <tbody data-repeater-list="">
                                                <tr data-repeater-item="">
                                                    <td>
                                                        <select class="form-control selectpicker" data-size="3">
                                                            <option selected disabled>Select Project</option>
                                                            <option>Arte Cheras</option>
                                                            <option>Arte MK</option>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select class="form-control selectpicker" data-size="3">
                                                            <option selected disabled>Select Role</option>
                                                            <option>Site Office Admin</option>
                                                            <option>Stock Officer</option>
                                                        </select>
                                                    </td>
                                                    <td><input type="text" class="form-control" placeholder="Staff Name" /></td>
                                                    <td><input type="text" class="form-control" placeholder="Contact" /></td>
                                                    <td><input type="email" class="form-control" placeholder="Email" /></td>
                                                    <td>
                                                        <a href="javascript:;" data-repeater-delete=""
                                                            class="btn btn-sm font-weight-bolder btn-light-danger">
                                                            <i class="fas fa-trash-alt"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-12">
                                        <a href="javascript:;" data-repeater-create="" class="btn btn-sm font-weight-bolder btn-light-primary">
                                            <i class="la la-plus"></i>Add
                                        </a>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-success font-weight-bold">Confirm</button>
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div> --}}

        </div>
    </div>
</div>

@endsection

@section('custom_js')
<script type="text/javascript" src="{{ asset('js/user.js') }}"></script>
@endsection