$(function () {
    console.log('requisition.js');

    var arrRF       = [];
    var cur_url     = window.location.pathname;
    var arr_url     = cur_url.split('/');
    var project_id  = 0;

    console.log('arr_url[2] --> '+arr_url[2]);
    console.log('arr_url[3] --> '+arr_url[3]);
    console.log('arr_url[4] --> '+arr_url[4]);

    if(arr_url[2] == "requisition") {
        project_id = arr_url[3];

        if(arr_url[4] == undefined) {
            ListRfTable(project_id, 'pending');
        }
    }     

    $(document).on('click', '#rflist_Tab li.nav-item', function() {
        var selected = $(this).find('a').attr('href');
            selected = selected.replace('#', '');
        console.log('[#rflist_Tab li.nav-item] [selected:'+selected+'] '+ $(this).find('a').attr('href'));
        ListRfTable(project_id, selected);
    })

    $(document).on('click', 'table.table_rf_new_item .btnDelete', function() {
        var id      = $(this).data('id');
        console.log('[btnDelete] Clicked! id: '+id);

        arrRF = arrRF.filter(function(item) {
            // console.log('[arrRF - loop] item" ',item);
            return item !== id;
        });

        $('table.table_rf_new_item tr#'+id).remove();

        console.log('[arrRF] ',arrRF);
        // console.log('[arrRF] ',arrRF);
    });

    $('#SearchItem').bind("enterKey",function(e){       
        SearchMaterial();
    });

    $('#SearchItem').keyup(function(e){
        if(e.keyCode == 13){
            $(this).trigger("enterKey");
        }
     });

    $(document).on('click', '.btnProceed', function() {
        var total_empty = 0;
        var total_row   = 0;

        var arr_selected = $("table.table_rf_new_item input[name=qty]").map(function(){ 
            var id      = $(this).data('id');
            var qty     = $(this).val();
            var remark  = $('table.table_rf_new_item input[name=remark_'+id+']').val();

            var temp = {
                'id'        : id,
                'qty'       : qty,
                'remark'    : remark,                
            };    

            total_row++;

            if(qty == "") {               
                total_empty++;
                return;
            } else {                
                return temp;
            }
            // console.log('[.btnProceed] [id:'+id+'] [qty: '+qty+']');
        }).get();

        if(total_row == 0) {
            alert("Please add at least one(1) item into the Requisition Form.");
            return;
        }

        if(total_empty > 0) {
            alert("Please fill in the quantity.");
            return;
        }                

        console.log('[.btnProceed()] [arr_selected]', arr_selected);
        var ajax_url    = APP_URL + '/admin/requisition/store/';

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url : ajax_url,
            type: 'PUT',           
            data: {
                'project_id'    : project_id,
                'list'          : arr_selected,                 
            },
            success: function(data) {                
                console.log('Create RF Success!');        
                console.log('Error: ', data.error);       

                if(data.status == "success"){
                    alert(data.msg);
                }else{
                    printErrorMsg(data.error);
                    
                }               
            },
        });

    });

    $(document).on('click', '#add_newReqItem .btnConfirm', function() {
        var row = '';
        var searchIDs = $("#add_newReqItem table.new_req input:checkbox:checked").map(function(){
            var id      = $(this).data('id');
            var name    = $(this).closest('td').next('td').text();
            var desc    = $(this).closest('tr').find('td').eq(2).text();
            var unit    = $(this).closest('tr').find('td').eq(3).text();
            var img     = $(this).closest('tr').find('td').eq(4).data('img');
            // console.log('[img] ', $(this).closest('tr').find('td').eq(2));

            if(arrRF.includes(id) == false) {
                arrRF.push(id);
                var temp = {
                    'id'    : id,
                    'name'  : name,
                    'desc'  : desc,
                    'unit'  : unit,
                    'img'   : img
                };    

                row += '<tr id="'+id+'">';
                row += '<td></td>';
                row += '<td class="text-left">'+name+' - '+desc+'</td>';
                row += '<td>'+unit+'</td>';
                row += '<td><input type="number" name="qty" class="form-control" placeholder="Qty" min="0" data-id="'+id+'" /></td>';
                row += '<td><input type="text" name="remark_'+id+'" class="form-control" placeholder="Remarks" /></td>';
                row += '<td><a href="javascript:;" data-repeater-delete=""  data-toggle="modal" data-target="#delete_rf_item" class="btn btn-sm font-weight-bolder btn-light-danger btnDelete" data-id="'+id+'"><i class="fas fa-trash-alt"></i></a></td>';
                row += '</tr>';

                return temp;
            } else {
                return;
            }
        }).get();

        $("table.table_rf_new_item").append(row);
        $('#add_newReqItem').modal('hide');

        console.log('[.btnConfirm] searchIDs: ',searchIDs);
        console.log('[arrRF] ', arrRF);
    });

    $(document).on('click', '.btnAddNew', function() {
        console.log('[.btnAddNew] Clicked!');
        $('#add_newReqItem #SearchItem').val('');
        $('#add_newReqItem #ListSearch').empty();
    });

    $(document).on('click', '#add_newReqItem .btnSearchItem', function() {
        SearchMaterial();
    });

    function SearchMaterial() {
        var search_data = $('#SearchItem').val();
        $('#add_newReqItem #ListSearch').empty();
        console.log('[search_data]', search_data);

        var formData = {
			'type'	    : "item",
            'search'    : search_data			
		};

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url: APP_URL + '/admin/material/search',
            type: "POST",
            data: {
                'type'      : 'item',
                'search'    : search_data
            },
            // contentType: false,
			// processData: false,       
            // dataType: 'json',            
            success:function(data){
                console.log(data);
                $('#ConfirmDelete').modal('hide');
                var row = '';
                if(data.status == "success" ){
                    row += 'Total '+data.total+' records found.';

                    if(data.total > 0) {
                        row += '<table class="table table-bordered table_do_detail_update new_req">';
                        row += '<tr>';
                        row += '<th></th>';
                        row += '<th>Item Name</th>';
                        row += '<th>Description</th>';
                        row += '<th>Unit</th>';
                        row += '<th>Image</th>';
                        row += '</tr>';                    

                        $.each(data.materials, function(index, item) {
                            row += '<tr>';
                            row += '<td><label class="checkbox"><input type="checkbox" name="item" data-id="'+item.id+'"><span></span></label> '+item.id+'</td>';
                            row += '<td class="text-left">'+item.name+'</td>';
                            row += '<td>'+item.description+'</td>';
                            if(item.unit == null || item.unit == '') {
                                row += '<td></td>';                            
                            } else {
                                row += '<td>'+item.unit+'</td>'; 
                            }
                            if(item.img == null || item.img == '') {
                                row += '<td data-img=""></td>';                                 
                            } else {
                                row += '<td data-img="'+item.img+'"><a href="#img2"><div class="reqItem_img" style="background-image: url(/images/'+item.company_id+'/'+item.img+'?'+index+');"></div></a><a href="#" class="lightbox" id="img2"><span style="background-image: url(/images/'+item.company_id+'/'+item.img+')"></span></a></td>';
                            }
                            
                            row += '</tr>';
                            
                        });                       
                        
                        row += '</table>';
                    }   

                    $('#add_newReqItem #ListSearch').append(row);

                } else{
                    printErrorMsg(data.status);
                }
                // window.location.href = window.location.href;
            },

        });
    }

    function ListRfTable(project_id, by_status) {
        console.log('ListRfTable()');
        var date	= new Date();
		var month 	= date.getMonth() + 1;
			month 	= (month < 10) ? '0'+month : month;
		var today	= date.getFullYear() + month + date.getDay();      
        var tableName   = "rflist_"+by_status;

        // switch(by_status) {
        //     case 'pending'      : tableId = "rflist_pending";
        //         break;
        //     case 'completed'    : tableId = "rflist_completed";
        //         break;
        //     case 'rejected'     : tableId = "rflist_rejected";
        //         break;
        // }

        var row = '';
		row += '<table id="'+tableName+'" class="table table-bordered mt-15 table_rflist_'+by_status+' table-hover" data-category="0">';
		row += '<thead>';
		row += '<tr>';
		row += '<th style="width:5%">#</th>';

        if(by_status == "pending") {
            row += '<th class="excelExport" style="width:10%">Requisition No.</th>';		
            row += '<th class="excelExport" style="width:5%">Total Item</th>';		
            row += '<th class="excelExport" style="width:15%">Create Date</th>';		
            row += '<th class="excelExport" style="width:15%">Requested by</th>';		
            row += '<th class="excelExport" style="width:10%">Contact</th>';		
		    row += '<th class="excelExport" style="width:6%">Status</th>';

        } else if(by_status == "completed") {
            row += '<th class="excelExport" style="width:10%">Requisition No.</th>';				
            row += '<th class="excelExport" style="width:15%">Create Date</th>';		
            row += '<th class="excelExport" style="width:30%">Requested by</th>';		
            row += '<th class="excelExport" style="width:30%">Contact</th>';		
		    row += '<th class="excelExport" style="width:6%">Status</th>';

        } else if(by_status == "completed") {
            row += '<th class="excelExport" style="width:30%">Requisition No.</th>';		
            // row += '<th class="excelExport" style="width:30%">Item</th>';		
            row += '<th class="excelExport" style="width:30%">Requested</th>';		
            row += '<th class="excelExport" style="width:30%">Requested by</th>';		
            row += '<th class="excelExport" style="width:30%">Contact</th>';		
		    row += '<th class="excelExport" style="width:6%">Status</th>';
        }    
		
		row += '<th style="width:6%">Action</th>';
		row += '</tr>';
		row += '</thead>';
		row += '<tbody>';
		row += '</tbody>';
		row += '</table>';
		$('#rflistTabContent #'+by_status).html(row);

        var formData = {
			'by_status'	    : by_status,
			'project_id'	: project_id,			
		};
        
        console.log('ajax_url ==>  ' + APP_URL + '/admin/requisition/list',);
        console.log('[tableName: '+tableName+'] formData ==>  ', formData);

        var rf_table = $('#'+tableName).DataTable({
            processing  : true,
            serverSide  : true,
            dom		    : 'lBfrtip',
            ajax        : {
				headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: APP_URL + '/admin/requisition/list',
				type: "post",  		
				data: formData,
				error: function(){  
					console.log("error");
				}
			}, 
            columnDefs: [				
				{
					"targets"	: [0,2,3],
					"className"	: "text-center",
				}
			],
            buttons: [
				{
					text: "<i class='fa fa-download' style='vertical-align:middle;'></i> <label style='margin:5px;'>Export</label>",
					extend: 'excelHtml5',
                    exportOptions: {
						columns: '.excelExport'
					},
					filename: 'Requisition_List_'+today,
					title: '',
					className: 'btn-export',
					action: function (e, dt, button, config) {
						var that = this;
						if(confirm("Do you want to export requisition listing to Excel file?")) {
							console.log('Confirm == OK');
							that.processing(true);
							that.disable();
							setTimeout(function () {
								console.log('[excelHtml5]button',button);
								$.fn.dataTable.ext.buttons.excelHtml5.action.call(that, e, dt, button, config);
								
							}, 500);
							that.enable();
						} else {
							console.log('Confirm == Cancel');
						}
					}
				},
			],			
            // ajax        : "{{route('admin.getTradeList')}}",
            columns: [
                // { data: 'id', name: 'id' },
                { "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },
                { data: 'requisition_no', name: 'requisition_no' },                  
                { data: 'total_item', name: 'total_item' },                  
                { data: 'create_at', name: 'create_at' },                  
                { data: 'create_by', name: 'create_by' },                  
                { data: 'contact', name: 'contact' },                  
                { data: 'status', name: 'status' },                  
                { data: 'action', name: 'action'},
            ],
            order: [[1, 'asc']]
        });         
        
    }


});