$(function () {
    console.log('requisition-site.js');

    var arrRF       = [];
    var cur_url     = window.location.pathname;
    var arr_url     = cur_url.split('/');
    var project_id  = 0;
	var arrPO		= [];

    console.log('arr_url[2] --> '+arr_url[2]);
    console.log('arr_url[3] --> '+arr_url[3]);
    console.log('arr_url[4] --> '+arr_url[4]);

    if(arr_url[3] == "requisition") {
        project_id = arr_url[4];

        if(arr_url[5] == undefined) {
            ListRfTable(project_id, 'pending');
			
        } else if(arr_url[5] == "edit") {
			var id 	= arr_url[6];
			EditGetRfDetail(project_id, id);
		}
    }     
	
	$(document).on('click', '.modal-links.po', function() {
		var id = $(this).data('id');
		console.log('[RF Modal] ID: '+id);
		
		GetPoDetail(project_id, id);
		// GetRfDetail(project_id, id);
	});
	
	$(document).on('click', '#requisition_form .btnCreatePO', function() {
		var rf_id 		= $(this).data('rf-id');
		var total_row   = 0;
		var total_empty	= 0;
		 
		console.log('[.btnCreatePO] [RF Modal] RFID: '+rf_id);
		
		var po_selected = $("#requisition_form table.table-rf input[name=rf_checkbox]:checked").map(function(){ 
            var id      = $(this).data('id');
            var qty     = $('#requisition_form table.table-rf input[name=po_qty_'+id+']').val();
            var remark  = $('#requisition_form table.table-rf input[name=po_remark_'+id+']').val();
			
            var temp = {
                'id'        : id,
                'qty'       : qty,
                'remark'    : remark,                
            };    

            total_row++;

            if(qty == "") {               
                total_empty++;
                return;
            } else {                
                return temp;
            }
            // console.log('[.btnProceed] [id:'+id+'] [qty: '+qty+']');
        }).get();
		
		if(total_row == 0) {
            alert("[total_row: '+total_row+'] Please select at least one(1) in order to create Purchase Order.");
            return;
        }

        if(total_empty > 0) {
            alert("Please fill in the quantity.");
            return;
        }         
		
		console.log('[.btnCreatePO()] [po_selected]', po_selected);
		$('#requisition_form').modal('hide');
		
		// window.location
	});
	
	$(document).on('click', '#requisition_form .btnApproveRf, #requisition_form .btnRejectRf', function() {
		var id 		= $(this).data('rf-id');
		var action 	= $(this).data('action');
		
		var text	= "Update ";
		console.log('[.btnApproveRf / .btnRejectRf] [action: '+ action +'] ID: '+ id);
		
		if(action == "approve") {
			text += "Approve ID :" + id + "?";
			
		} else if(action == "reject") {
			text = "Reject ID :" + id + "?";
		}
				
		if(confirm(text) == true) {
			UpdateRf(id, action);
		} else {
			return;
		}
	});
	
	$(document).on('click', '.modal-links', function() {
		var id = $(this).data('id');
		console.log('[RF Modal] ID: '+id);
		
		GetRfDetail(project_id, id);
	});

    $(document).on('click', '#rflist_Tab li.nav-item', function() {
        var selected = $(this).find('a').attr('href');
            selected = selected.replace('#', '');
        console.log('[#rflist_Tab li.nav-item] [selected:'+selected+'] '+ $(this).find('a').attr('href'));
        ListRfTable(project_id, selected);
    })

    $(document).on('click', 'table.table_rf_new_item .btnDelete', function() {
        var id      = $(this).data('id');
        console.log('[btnDelete] Clicked! id: '+id);

        arrRF = arrRF.filter(function(item) {
            // console.log('[arrRF - loop] item" ',item);
            return item !== id;
        });

        $('table.table_rf_new_item tr#'+id).remove();
        console.log('[arrRF] ',arrRF);        
    });

    $('#SearchItem').bind("enterKey",function(e){       
        SearchMaterial();
    });

    $('#SearchItem').keyup(function(e){
        if(e.keyCode == 13){
            $(this).trigger("enterKey");
        }
    });

    $(document).on('click', '.btnProceed', function() {
        var total_empty = 0;
        var total_row   = 0;
		var type		= 'new';
		var rf_id		= 0;
		
        var arr_selected = $("table.table_rf_new_item input[name=qty]").map(function(){ 
            var id      = $(this).data('id');
            var qty     = $(this).val();
            var remark  = $('table.table_rf_new_item input[name=remark_'+id+']').val();
			
            var temp = {
                'id'        : id,
                'qty'       : qty,
                'remark'    : remark,                
            };    

            total_row++;

            if(qty == "") {               
                total_empty++;
                return;
            } else {                
                return temp;
            }
            // console.log('[.btnProceed] [id:'+id+'] [qty: '+qty+']');
        }).get();

        if(total_row == 0) {
            alert("Please add at least one(1) item into the Requisition Form.");
            return;
        }

        if(total_empty > 0) {
            alert("Please fill in the quantity.");
            return;
        }                

        console.log('[.btnProceed()] [arr_selected]', arr_selected);
        var ajax_url    = APP_URL + '/site/requisition/store/';
		
		if(arr_url[5] == "edit") {
			rf_id		= arr_url[6];
			ajax_url    = APP_URL + '/site/requisition/update/'+rf_id;
		}

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url : ajax_url,
            type: 'PUT',           
            data: {				
                'project_id'    : project_id,
                'list'          : arr_selected,       
                'rf_id'         : rf_id,   			
            },
            success: function(data) {                
                console.log('Create RF Success!');        
                console.log('Error: ', data.error);       

                if(data.status == "success"){
                    alert(data.msg);
                }else{
                    printErrorMsg(data.error);
                }               
            },
        });

    });

    $(document).on('click', '#add_newReqItem .btnConfirm', function() {
        var row = '';
        var searchIDs = $("#add_newReqItem table.new_req input:checkbox:checked").map(function(){
            var id      = $(this).data('id');
            var name    = $(this).closest('td').next('td').text();
            var desc    = $(this).closest('tr').find('td').eq(2).text();
            var unit    = $(this).closest('tr').find('td').eq(3).text();
            var img     = $(this).closest('tr').find('td').eq(4).data('img');
            // console.log('[img] ', $(this).closest('tr').find('td').eq(2));

            if(arrRF.includes(id) == false) {
                arrRF.push(id);
                var temp = {
                    'id'    : id,
                    'name'  : name,
                    'desc'  : desc,
                    'unit'  : unit,
                    'img'   : img
                };    

                row += '<tr id="'+id+'">';
                row += '<td></td>';
                row += '<td class="text-left">'+name+' - '+desc+'</td>';
                row += '<td>'+unit+'</td>';
                row += '<td><input type="number" name="qty" class="form-control" placeholder="Qty" min="0" data-id="'+id+'" /></td>';
                row += '<td><input type="text" name="remark_'+id+'" class="form-control" placeholder="Remarks" /></td>';
                row += '<td><a href="javascript:;" data-repeater-delete=""  data-toggle="modal" data-target="#delete_rf_item" class="btn btn-sm font-weight-bolder btn-light-danger btnDelete" data-id="'+id+'"><i class="fas fa-trash-alt"></i></a></td>';
                row += '</tr>';

                return temp;
            } else {
                return;
            }
        }).get();

        $("table.table_rf_new_item").append(row);
        $('#add_newReqItem').modal('hide');

        console.log('[.btnConfirm] searchIDs: ',searchIDs);
        console.log('[arrRF] ', arrRF);
    });

    $(document).on('click', '.btnAddNew', function() {
        console.log('[.btnAddNew] Clicked!');
        $('#add_newReqItem #SearchItem').val('');
        $('#add_newReqItem #ListSearch').empty();
    });

    $(document).on('click', '#add_newReqItem .btnSearchItem', function() {
        SearchMaterial();
    });

    function SearchMaterial() {
        var search_data = $('#SearchItem').val();
        $('#add_newReqItem #ListSearch').empty();
        console.log('[search_data]', search_data);

        var formData = {
			'type'	    : "item",
            'search'    : search_data			
		};

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url: APP_URL + '/site/material/search',
            type: "POST",
            data: {
                'type'      : 'item',
                'search'    : search_data
            },
            // contentType: false,
			// processData: false,       
            // dataType: 'json',            
            success:function(data){
                console.log(data);
                $('#ConfirmDelete').modal('hide');
                var row = '';
                if(data.status == "success" ){
                    row += 'Total '+data.total+' records found.';

                    if(data.total > 0) {
                        row += '<table class="table table-bordered table_do_detail_update new_req">';
                        row += '<tr>';
                        row += '<th></th>';
                        row += '<th>Item Name</th>';
                        row += '<th>Description</th>';
                        row += '<th>Unit</th>';
                        row += '<th>Image</th>';
                        row += '</tr>';                    

                        $.each(data.materials, function(index, item) {
                            row += '<tr>';
                            row += '<td><label class="checkbox"><input type="checkbox" name="item" data-id="'+item.id+'"><span></span></label> '+item.id+'</td>';
                            row += '<td class="text-left">'+item.name+'</td>';
                            row += '<td>'+item.description+'</td>';
                            if(item.unit == null || item.unit == '') {
                                row += '<td></td>';                            
                            } else {
                                row += '<td>'+item.unit+'</td>'; 
                            }
                            if(item.img == null || item.img == '') {
                                row += '<td data-img=""></td>';                                 
                            } else {
                                row += '<td data-img="'+item.img+'"><a href="#img2"><div class="reqItem_img" style="background-image: url('+APP_URL+'/images/'+item.company_id+'/'+item.img+'?'+index+');"></div></a><a href="#" class="lightbox" id="img2"><span style="background-image: url('+APP_URL+'/images/'+item.company_id+'/'+item.img+')"></span></a></td>';
                            }
                            
                            row += '</tr>';
                            
                        });                       
                        
                        row += '</table>';
                    }   

                    $('#add_newReqItem #ListSearch').append(row);

                } else{
                    printErrorMsg(data.status);
                }
                // window.location.href = window.location.href;
            },

        });
    }
	
	function printErrorMsg (msg) {
		console.log(msg);
        // $(".print-error-msg").find("ul").html('');
        // $(".print-error-msg").css('display','block');
        // $.each( msg, function( key, value ) {
            // $(".print-error-msg").find("ul").append('<li>'+value+'</li>');
        // });
    }
	
    function ListRfTable(project_id, by_status, source) {
        console.log('ListRfTable() ==> status: ' + by_status);
        var date	= new Date();
		var month 	= date.getMonth() + 1;
			month 	= (month < 10) ? '0'+month : month;
		var day		= date.getDate();			
		var today	= date.getFullYear() + month + day;      
        var tableName   = "rflist_"+by_status;

        // switch(by_status) {
        //     case 'pending'      : tableId = "rflist_pending";
        //         break;
        //     case 'completed'    : tableId = "rflist_completed";
        //         break;
        //     case 'rejected'     : tableId = "rflist_rejected";
        //         break;
        // }

        var row = '';
		row += '<table id="'+tableName+'" class="table table-bordered mt-15 table_rflist_'+by_status+' table-hover" data-category="0">';
		row += '<thead>';
		row += '<tr>';
		row += '<th style="width:5%">#</th>';
		row += '<th class="excelExport" style="width:12%">RF #</th>';	

        if(by_status == "pending" || by_status == "approve" || by_status == "completed" || by_status == "rejected") {
            row += '<th class="excelExport" style="width:5%">Total Item</th>';
            row += '<th class="excelExport" style="width:15%">Requested by</th>';
			row += '<th class="excelExport" style="width:10%">PO #</th>';	
			row += '<th class="excelExport" style="width:10%">DO #</th>';
			
		} else if(by_status == "po") {			            
			row += '<th class="excelExport" style="width:5%">Total Item</th>';
            row += '<th class="excelExport" style="width:20%">Requested by</th>';
            row += '<th class="excelExport" style="width:12%">PO #</th>';
		   
		} else if(by_status == "do") {
			row += '<th class="excelExport" style="width:5%">Total Item</th>';
            row += '<th class="excelExport" style="width:20%">Requested by</th>';
            row += '<th class="excelExport" style="width:12%">DO #</th>';
			row += '<th class="excelExport" style="width:5%">Total Item</th>';

		} 
		row += '<th class="excelExport" style="width:6%">Status</th>';
		row += '<th class="excelExport" style="width:10%">Create Date</th>';
		
		if(by_status == "pending") {
			row += '<th style="width:6%">Action</th>';
		}
		
		row += '</tr>';
		row += '</thead>';
		row += '<tbody>';
		row += '</tbody>';
		row += '</table>';
		$('#rflistTabContent #'+by_status).html(row);

        var formData = {
			'by_status'	    : by_status,
			'project_id'	: project_id,			
			'source'		: 'requisition_page',			
		};
        
        console.log('ajax_url ==>  ' + APP_URL + '/site/requisition/list',);
        console.log('[tableName: '+tableName+'] formData ==>  ', formData);

		var columns = "";
		
		if(by_status == "pending") {
			columns 	= [
				{ "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },				
                { data: 'requisition_no', name: 'requisition_no' },                  
                { data: 'total_item', name: 'total_item' },    
                { data: 'create_by', name: 'create_by' },                  
                { data: 'po', name: 'po' },                  
                { data: 'do', name: 'do' },                  
                { data: 'status', name: 'status' }, 
				{ data: 'create_at', name: 'create_at' },				
                { data: 'action', name: 'action'},
			];
			
		} else if(by_status == "approve" || by_status == "completed"  || by_status == "rejected") {
			columns 	= [
				{ "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },				
                { data: 'requisition_no', name: 'requisition_no' },                  
                { data: 'total_item', name: 'total_item' },    
                { data: 'create_by', name: 'create_by' },                  
                { data: 'po', name: 'po' },                  
                { data: 'do', name: 'do' },                  
                { data: 'status', name: 'status' }, 
				{ data: 'create_at', name: 'create_at' },				
                // { data: 'action', name: 'action'},
			];
			
		} else if(by_status == "po") {
			columns 	= [
				{ "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },				
                { data: 'requisition_no', name: 'requisition_no' },                  
                { data: 'total_item', name: 'total_item' },    
                { data: 'create_by', name: 'create_by' },                  
                { data: 'po', name: 'po' },                                      
                { data: 'status', name: 'status' }, 
				{ data: 'create_at', name: 'create_at' },				
                // { data: 'action', name: 'action'},
			];
		} else if(by_status == "do") {
			columns 	= [
				{ "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },				
                { data: 'requisition_no', name: 'requisition_no' },                  
                { data: 'total_item', name: 'total_item' },    
                { data: 'create_by', name: 'create_by' },                  
                { data: 'do', name: 'do' },                                      
                { data: 'status', name: 'status' }, 
				{ data: 'create_at', name: 'create_at' },				
                // { data: 'action', name: 'action'},
			];
			
		} else {
			columns 	= [
				{ "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },				
                { data: 'requisition_no', name: 'requisition_no' },  
				// { data: 'total_item', name: 'total_item' }, 				
                { data: 'create_by', name: 'create_by' },                  
                { data: 'contact', name: 'contact' },                  
                { data: 'status', name: 'status' },    
				{ data: 'create_at', name: 'create_at' },				
                // { data: 'action', name: 'action'},
			];
		}
		
		// console.log('[columns]', columns);
		
        var rf_table = $('#'+tableName).DataTable({
            processing  : true,
            serverSide  : false,
			responsive: true,
            // dom		    : 'lBfrtip',
			dom: `
				<'row'<'col-sm-12 col-md-5 text-left'f><'col-sm-12 col-md-7 text-right dataTables_pager'lB>>
				<'row'<'col-sm-12'tr>>
				<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 'p>>`,
            ajax        : {
				headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: APP_URL + '/site/requisition/list',
				type: "post",  		
				data: formData,
				error: function(){  
					console.log("error");
				}
			}, 
            columnDefs: [				
				{
					"targets"	: [0,2,3, 4, 5, 6],
					"className"	: "text-center",
				}
			],
			buttons: [
				{
					extend: 'collection',
					text: 'Export',
					buttons: [
						'copy',		
						{ extend: 'csv', filename: 'RequisitionList_'+by_status+'_'+today },
						{ extend: 'excel', filename: 'RequisitionList_'+by_status+'_'+today },						
						{ extend: 'pdf', filename: 'RequisitionList_'+by_status+'_'+today },										
						'print'
					]
				}
			],
			// buttons: [
				// { extend: 'excelHtml5', exportOptions: {columns: '.excelExport'}, filename: 'RequisitionList_'+by_status+'_'+today },
				// { extend: 'pdfHtml5', exportOptions: {columns: '.excelExport'}, filename: 'RequisitionList_'+today },
				// { extend: 'print', exportOptions: {columns: '.excelExport'}, filename: 'RequisitionList_'+today },
				// { extend: 'copy', exportOptions: {columns: '.excelExport'}, filename: 'RequisitionList_'+today },
			// ],
            // buttons: [
				// {
					// text: "<i class='fa fa-download' style='vertical-align:middle;'></i> <label style='margin:5px;'>Export</label>",
					// extend: 'excelHtml5',
                    // exportOptions: {
						// columns: '.excelExport'
					// },
					// filename: 'Requisition_List_'+today,
					// title: '',
					// className: 'btn-export',
					// action: function (e, dt, button, config) {
						// var that = this;
						// if(confirm("Do you want to export requisition listing to Excel file?")) {
							// console.log('Confirm == OK');
							// that.processing(true);
							// that.disable();
							// setTimeout(function () {
								// console.log('[excelHtml5]button',button);
								// $.fn.dataTable.ext.buttons.excelHtml5.action.call(that, e, dt, button, config);
								
							// }, 500);
							// that.enable();
						// } else {
							// console.log('Confirm == Cancel');
						// }
					// }
				// },
			// ],			
            // ajax        : "{{route('admin.getTradeList')}}",
            // columns: [               
                // { "data": null,"sortable": false, 
                    // render: function (data, type, row, meta) {
                                // return meta.row + meta.settings._iDisplayStart + 1;
                    // }  
                // },
                // { data: 'requisition_no', name: 'requisition_no' },                  
                // { data: 'total_item', name: 'total_item' },                  
                // { data: 'create_at', name: 'create_at' },                  
                // { data: 'create_by', name: 'create_by' },                  
                // { data: 'contact', name: 'contact' },                  
                // { data: 'status', name: 'status' },                  
                // { data: 'action', name: 'action'},
            // ],
			columns: columns,
            order: [[1, 'desc']]
        });         
        
    }

	function GetRfDetail(res_id, id) {
		// var formData = {
			// 'by_status'	    : by_status,
			// 'project_id'	: project_id,			
		// };
		$('#requisition_form .table-rf').empty();
		$("#requisition_form .rf_no").html('No. : ');
		
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url: APP_URL + '/site/requisition/detail',
            type: "POST",
            data: {
				// 'project_id'	: project_id,	
				'project_id'	: project_id,	
                'id'      		: id,         
            },
            // contentType: false,
			// processData: false,       
            dataType: 'json',            
            success:function(data){
                $('#requisition_form .request-info').empty();				
				var company_info	= data.company_info[0]; 
				var rf_detail 		= data.rf_detail[0];
				var rf_list			= data.rf_list; 
				// return;
				// console.log('[company_info_length: '+ data.company_info.length+ '] [rf_detail_length: '+data.rf_detail.length+']');
				console.log('rf_detail: ', data.rf_detail[0]);
				// console.log('rf_list: ', data.rf_list[0]);
                // $('#ConfirmDelete').modal('hide');
                var row 	= '';				
                if(data.status == "success" ){	
					if(data.company_info.length > 0) {						
						$("#requisition_form .address-box").html('<div>'+company_info.residential_name+', </div>'+'<div>'+company_info.residential_addr+'</div><div>Tel:</div>');
						$("#requisition_form .to-info").html('<strong>To:</strong><br>Headquarters<br>'+company_info.company_addr);  
						$("#requisition_form .logo-rf").css('background-image', 'url('+ APP_URL + '/images/logo/' + company_info.logo + ')');
					}
					
					if(data.rf_detail.length > 0) {
						var create_dt 	= new Date(rf_detail.create_at);
							create_dt 	= ('0' + create_dt.getDate()).slice(-2) + '/' + ('0' + (create_dt.getMonth() + 1)).slice(-2) + '/' + create_dt.getFullYear();
						
						var creator_name= (rf_detail.creator_name == null) ? "" : rf_detail.creator_name;
						var creator_tel	= (rf_detail.creator_tel == null) ? "" : rf_detail.creator_tel;
						
						$("#requisition_form .rf_no").html('No. : '+rf_detail.requisition_no);
						row += '<table class="table table-borderless">';
						row += '<tr><td>Request Date :</td><td>'+ create_dt +'</td></tr>';
						row += '<tr><td>Requested by :</td><td>'+ creator_name +'</td></tr>';
						row += '<tr><td>Contact # :</td><td>'+ creator_tel +'</td></tr>';
						row += '</table>';
						
						$('#requisition_form .request-info').append(row);
						
						$('#requisition_form .btnRejectRf').show();
						$('#requisition_form .btnApproveRf').show();
						
						if(rf_detail.status > 1 && rf_detail.status < 6) {
							$('#requisition_form .btnApproveRf').hide();
							
						} else if(rf_detail.status == 6) {
							$('#requisition_form .btnApproveRf').hide();
							$('#requisition_form .btnRejectRf').hide();
						}
					}
					
					if(data.rf_list.length > 0) { 
						var row2 	= '';						
						row2 += '<tr><th>#</th><th>Item Name</th><th>Item Description</th><th>Unit</th><th>Qty</th><th>RF Remarks</th></tr>';
					
						$.each(rf_list, function(i, row) {									
							$.each(row, function(idx, item) {
								var num 	= idx + 1;
								var remark	=  (item.remark == null) ? "" : item.remark;
								var item_id	= item.item_id;
								
								// console.log(idx+' [rf_list] item: ', item);
								// row2 += '<tr><td><input type="checkbox" name="rf_checkbox" data-id="'+item_id+'"></td>';
								row2 += '<tr><td>'+num+'</td>';
								row2 += '<td style="text-align:left;">'+item.name+'</td>';
								row2 += '<td style="text-align:left;">'+item.description+'</td>';
								
								if(item.unit == null) {
									row2 += '<td>-</td>';
								} else {
									row2 += '<td style="text-align:center;">'+item.unit+'</td>';
								}								
								row2 += '<td style="text-align:center;">'+item.qty+'</td>';
								row2 += '<td>'+ remark +'</td>';
								// row2 += '<td style="text-align:center;"><input type="number" name="po_qty_'+item_id+'" class="form-control" min="0" max="'+item.qty+'"></td>';
								// row2 += '<td><textarea class="form-control" name="po_remark_'+item_id+'"></textarea></td>';
								row2 += '</tr>';
							}); 
							
								
						});
						
						$('#requisition_form .table-rf').append(row2);
						$('#requisition_form .btnCreatePO').data("rf-id", id);
						$('#requisition_form .btnApproveRf').data("rf-id", id);
						$('#requisition_form .btnRejectRf').data("rf-id", id);
						
						
					}
					
                } else{
                    printErrorMsg(data.status);
                }
                // window.location.href = window.location.href;
            },

        });
	}
	
	function EditGetRfDetail(res_id, id) {		
		$('#requisition_form .table-rf').empty();
		$("#requisition_form .rf_no").html('No. : ');
		
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url: APP_URL + '/site/requisition/detail',
            type: "POST",
            data: {
				// 'project_id'	: project_id,	
				'project_id'	: project_id,	
                'id'      		: id,         
            },
            // contentType: false,
			// processData: false,       
            dataType: 'json',            
            success:function(data){
                $('#requisition_form .request-info').empty();				
				var company_info	= data.company_info[0]; 
				var rf_detail 		= data.rf_detail[0];
				var rf_list			= data.rf_list; 
				
				console.log('[company_info_length: '+ data.company_info.length+ '] [rf_detail_length: '+data.rf_detail.length+']');
				console.log('rf_detail: ', data.rf_detail[0]);
				console.log('rf_list: ', data.rf_list[0]);
                // $('#ConfirmDelete').modal('hide');
                var row 	= '';				
                if(data.status == "success" ){	
					// if(data.company_info.length > 0) {						
						// $("#requisition_form .address-box").html('<div>'+company_info.residential_name+', </div>'+'<div>'+company_info.residential_addr+'</div><div>Tel:</div>');
						// $("#requisition_form .to-info").html('<strong>To:</strong><br>Headquarters<br>'+company_info.company_addr);  
						// $("#requisition_form .logo-rf").css('background-image', 'url('+ APP_URL + '/images/logo/' + company_info.logo + ')');
					// }
					
					// if(data.rf_detail.length > 0) {
						// var create_dt 	= new Date(rf_detail.create_at);
							// create_dt 	= ('0' + create_dt.getDate()).slice(-2) + '/' + ('0' + (create_dt.getMonth() + 1)).slice(-2) + '/' + create_dt.getFullYear();
						
						// var creator_name= (rf_detail.creator_name == null) ? "" : rf_detail.creator_name;
						// var creator_tel	= (rf_detail.creator_tel == null) ? "" : rf_detail.creator_tel;
						
						// $("#requisition_form .rf_no").html('No. : '+rf_detail.requisition_no);
						// row += '<table class="table table-borderless">';
						// row += '<tr><td>Request Date :</td><td>'+ create_dt +'</td></tr>';
						// row += '<tr><td>Requested by :</td><td>'+ creator_name +'</td></tr>';
						// row += '<tr><td>Contact # :</td><td>'+ creator_tel +'</td></tr>';
						// row += '</table>';
						
						// $('#requisition_form .request-info').append(row);
					// }
					
					if(data.rf_list.length > 0) { 
						// var row2 	= '';						
						// row2 += '<tr><th>#</th><th>Item Name</th><th>Item Description</th><th>Unit</th><th>Qty</th><th>Remarks</th></tr>';
						$("#kt_content .container .rf_no").text(rf_detail.requisition_no);
					
						$.each(rf_list, function(i, line) {									
							$.each(line, function(idx, item) {								
								var item_id	=  (item.item_id == null) ? "" : item.item_id;
								var name	=  (item.name == null) ? "" : item.name;
								var unit	=  (item.unit == null) ? "" : item.unit;
								var qty		=  (item.qty == null) ? "" : item.qty;
								var desc	=  (item.description == null) ? "" : item.description;
								var remark	=  (item.remark == null) ? "" : item.remark;
								var img		=  (item.img == null) ? "" : item.img;
								
								if(arrRF.includes(item_id) == false) {
									arrRF.push(item_id);
									 
									var temp = {
										'id'    : item_id,
										'name'  : name,
										'desc'  : desc,
										'unit'  : unit,
										'img'   : img
									};  
				
									row += '<tr id="'+ item_id+'">';								
									row += '<td></td>';
									row += '<td class="text-left">'+name+' - '+desc+'</td>';
									row += '<td>'+unit+'</td>';
									row += '<td><input type="number" name="qty" class="form-control" placeholder="Qty" min="0" data-id="'+ item_id +'" value="'+qty+'" /></td>';
									row += '<td><input type="text" name="remark_'+ item.item_id +'" class="form-control" placeholder="Remarks" /></td>';
									row += '<td><a href="javascript:;" data-repeater-delete=""  data-toggle="modal" data-target="#delete_rf_item" class="btn btn-sm font-weight-bolder btn-light-danger btnDelete" data-id="'+ item_id +'"><i class="fas fa-trash-alt"></i></a></td>';
									row += '</tr>';
								
									return temp;
								} else {
									return;
								}
								
							}); 							
								
						});
												
						// $('#requisition_form .table-rf').append(row2);
						$("#kt_repeater_2 table.table_rf_new_item").append(row);
					}
					
                } else{
                    printErrorMsg(data.status);
                }
                // window.location.href = window.location.href;
            },

        });
	}


	function UpdateRf(id, status) {
		console.log('UpdateRf() - Status: '+status);
		$('#requisition_form .table-rf').empty();
		$("#requisition_form .rf_no").html('No. : ');
		
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url: APP_URL + '/site/requisition/update_rf',
            type: "PUT",
            data: {
				// 'project_id'	: project_id,	
				'project_id'	: project_id,	
                'id'      		: id,
				'status'		: status,
            },
            // contentType: false,
			// processData: false,       
            dataType: 'json',            
            success:function(data){           
               	console.log('[UpdateRf()] data:', data);
                if(data.status == "success" ){	
					// $("#rflist_Tab li.nav-item.nav-link.approve").trigger('click');
					$('#requisition_form').modal('hide');
					ListRfTable(project_id, 'pending');
					
					// $("#rflist_Tab .nav-link").removeClass('active');
					//$(document).on('click', '#rflist_Tab li.nav-item', function() {
					
					// $("#rflist_Tab .nav-link.approve").addClass('active');
                } else{
                    printErrorMsg(data.status);
                }
                // window.location.href = window.location.href;
            },
		});
	}
	
	function GetPoDetail(project_id, id) {
		// var formData = {
			// 'by_status'	    : by_status,
			// 'project_id'	: project_id,			
		// };
		$('#po_form .table-po').empty();
		$("#po_form .po_no").html('No. : ');
		
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },           
            url: APP_URL + '/site/po/detail',
            type: "POST",
            data: {					
				'project_id'	: project_id,
                'id'      		: id,
            },
            // contentType: false,
			// processData: false,       
            dataType: 'json',            
            success:function(data){
                $('#po_form .request-info').empty();				
				var company_info	= data.company_info[0]; 
				var po_detail 		= data.po_detail[0];
				var po_list			= data.po_list; 
				// return;
				console.log('[company_info_length: '+ data.company_info.length+ '] [rf_detail_length: '+data.po_detail.length+']');
				console.log('po_detail: ', data.po_detail[0]);
				console.log('po_list: ', data.po_list[0]);
                // $('#ConfirmDelete').modal('hide');
                var row 	= '';				
                if(data.status == "success" ){	
					if(data.company_info.length > 0) {						
						$("#po_form .address-box").html('<div>'+company_info.residential_name+', </div>'+'<div>'+company_info.residential_addr+'</div><div>Tel:</div>');
						$("#po_form .to-info").html('<strong>To:</strong><br>Headquarters<br>'+company_info.company_addr);  
						$("#po_form .logo-rf").css('background-image', 'url('+ APP_URL + '/images/logo/' + company_info.logo + ')');
					}
					
					if(data.po_detail.length > 0) {
						var create_dt 	= new Date(po_detail.create_at);
							create_dt 	= ('0' + create_dt.getDate()).slice(-2) + '/' + ('0' + (create_dt.getMonth() + 1)).slice(-2) + '/' + create_dt.getFullYear();
						
						var po_date		= (po_detail.po_date == null) ? "" : po_detail.po_date;
						var creator_name= (po_detail.creator_name == null) ? "" : po_detail.creator_name;
						var creator_tel	= (po_detail.creator_tel == null) ? "" : po_detail.creator_tel;
						var vendor_company	= (po_detail.vendor_company == null) ? "" : po_detail.vendor_company;
						var vendor_addr	= (po_detail.vendor_addr == null) ? "" : po_detail.vendor_addr;
						
						$("#po_form .po_no").html('No. : '+po_detail.po_no);						
						$("#po_form .to-info").html('<strong>To:</strong><br>'+vendor_company+'<br>'+ vendor_addr);  
						row += '<table class="table table-borderless">';
						row += '<tr><td>PO Date :</td><td>'+ create_dt +'</td></tr>';
						row += '<tr><td>Created by :</td><td>'+ creator_name +'</td></tr>';
						// row += '<tr><td>Vendor :</td><td>'+ vendor_company +' - - '+vendor_company+'</td></tr>';
						// row += '<tr><td>Contact # :</td><td>'+ creator_tel +'</td></tr>';
						row += '</table>';
						
						$('#po_form .request-info').append(row);
					}
					
					if(data.po_list.length > 0) { 
						var row2 	= '';						
						row2 += '<tr><th>#</th><th>Item Name</th><th>Item Description</th><th>Unit</th><th>Qty</th><th>Remarks</th></tr>';
					
						$.each(po_list, function(i, row) {									
							$.each(row, function(idx, item) {
								var num 	= idx + 1;
								var remark	=  (item.remark == null) ? "" : item.remark;
								
								console.log(idx+' [po_list] item: ', item);
								row2 += '<tr><td style="text-align:center;">'+num+'</td>';
								row2 += '<td style="text-align:left;">'+item.name+'</td>';
								row2 += '<td style="text-align:left;">'+item.description+'</td>';
								
								if(item.unit == null) {
									row2 += '<td>-</td>';
								} else {
									row2 += '<td style="text-align:center;">'+item.unit+'</td>';
								}								
								row2 += '<td style="text-align:center;">'+item.qty+'</td>';
								row2 += '<td>'+ remark +'</td>';
								row2 += '</tr>';
							}); 
							
								
						});
						
						$('#po_form .table-po').append(row2);
					}
					
                } else{
                    printErrorMsg(data.status);
                }
                // window.location.href = window.location.href;
            },

        });
	}
	
});