<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Gate::define('logged-in', function($user){
            return $user;
        });

        Gate::define('is-admin', function($user) {
            return $user->hasAnyRoles(['Project Manager', 'Director', 'HQ Admin']);
            // return $user->hasAnyRoles(['Project Manager', 'Director', 'HQ Admin', 'Site Admin']);
            // return $user->hasAnyRole('project manager');
        });

        Gate::define('is-director', function($user) {
            return $user->hasAnyRole('Director');
        });

        Gate::define('is-pm', function($user) {
            return $user->hasAnyRole('Project Manager');
        });

        Gate::define('is-hq', function($user) {
            return $user->hasAnyRole('HQ Admin');
        });

        Gate::define('is-site', function($user) {
            return $user->hasAnyRole('Site Admin');
        });

        Gate::define('is-vendor', function($vendor) {
            return $vendor->hasAnyRole('Vendor');
        });

        //
    }
}
