<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Residential;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class OverviewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(Gate::denies('logged-in')) {
            dd('no access allowed');
        } 

        return view('overview.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        echo 'OverviewController > Show > '.$id;       
        // DB::enableQueryLog();

        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res    = $user->getResidential($user->id);
        $residential_id = $res->residential_id;

        $sql    = "SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id) AND user_id = '$user_id'";
        $count  = DB::select($sql); 
        // print_r($count);
        $count  = $count[0]->count;
        // echo '<br>sql : '.$sql;
        // echo '<br>COUNT : '.$count;
        if($count == 0) {
            dd("Permission not allow for the project");
            //  return view('overview.index', compact('residential', 'user', 'role'));
        }
        
        $residential = DB::select("SELECT * FROM residential WHERE id IN ($residential_id) order by name asc");           

        return view('overview.index', compact('residential', 'user', 'role'));
    }

    /**
     * Show the form for editing the specified resource.    
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
