<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\IOFactory;
use App\Models\Material;
use Validator;
use Config;

// include(app_path().'/includes/config.php');
// include(app_path().'/includes/table.php');

class MaterialController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // echo 'MaterialController > index';       
        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res    = $user->getResidential($user->id);
        $residential_id = $res->residential_id;

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)");        
        // $count  = $count[0]->count;        
        // if($count == 0) {
        //     dd("Permission not allow for the project");           
        // }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('material.index', compact('residential', 'user', 'role'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($type)
    {
        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res    = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)");        
        // $count  = $count[0]->count;        
        // if($count == 0) {
        //     dd("Permission not allow for the project");
        // }              

        $residential    = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");    
        $trades         = Material::getTrades($company_id);      
        $materials      = Material::getMaterial($type, $company_id);      
        $measurements   = Material::getMeasurements();
        $categories     = Material::getCategories($company_id);

        if($type == "trade") {         
            return view('material.create_trade', compact('residential', 'user', 'role', 'materials', 'trades'));

        } else if($type == "category") {
            return view('material.create_category', compact('residential', 'user', 'role', 'categories', 'categories'));   

        }
        
        return view('material.create_item', compact('residential', 'user', 'role', 'trades', 'measurements'));   
    }   

    public function import(Request $request, $type) 
    {
        $user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;

        
        $title = "Import Spreadsheet";
        $template = url('documents/template-trade.xlsx');

        if($_POST) {
            // dd($type);
            if($type == "trade") {
                $sheet_name = "TRADE DATA";
                $path       = public_path('uploads'.DIRECTORY_SEPARATOR.'trade'.DIRECTORY_SEPARATOR);  
                $columns = [
                    // "A"=>"id",
                    "A"=>"name",
                    // "C"=>"company_id",
                    // "D"=>"address"
                ];
                $table_name = Config::get('constants.tables.trade');

            } else if($type == "item") {
                $sheet_name = "ITEM DATA";
                $path       = public_path('uploads'.DIRECTORY_SEPARATOR.'item'.DIRECTORY_SEPARATOR);  
                $columns = [                 
                    "A" => "name",
                    "B" => "description",           
                ];          
                $table_name = Config::get('constants.tables.item');
            
            } else if($type == "category") {
                $sheet_name = "CATEGORY DATA";
                $path       = public_path('uploads'.DIRECTORY_SEPARATOR.'category'.DIRECTORY_SEPARATOR);  
                $columns = [                 
                    "A" => "name",                         
                ];          
                $table_name = Config::get('constants.tables.category');

            }

            if(!file_exists($path)) {
                File::makeDirectory($path, $mode = 777, true, true);
            }

            $request->validate([
                'file1' => 'required|mimes:xlsx|max:10000'
            ]);
            $file = $request->file('file1');
            $name = time().'.xlsx';
           

            if ( $file->move($path, $name) ){
                $inputFileName  = $path.$name;
                $reader         = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                $reader->setReadDataOnly(true);
                $reader->setLoadSheetsOnly([$sheet_name]);
                $spreadSheet    = $reader->load($inputFileName);
                $workSheet      = $spreadSheet->getActiveSheet();
                $startRow       = 2;
                $max            = $workSheet->getHighestRow();             

                $data_insert    = [];

                for($i=$startRow; $i <= $max; $i++){
                    $got_data = 1;
                    // echo "<br>i: $i";
                    // $id = $workSheet->getCell("A$i")->getValue();
                    // if(empty( $id)||!is_numeric( $id ))continue;

                    $data_row = [];

                    $data_row['company_id'] = $company_id;                    
                    $data_row['create_by']  = $user_id;
                    $data_row['create_at']  = date("Y-m-d H:i:s");

                    if($type == "trade") {
                        $data_row['parent_id']  = 0;

                    } else if($type == "category") {
                        $data_row['parent_id']  = 0;

                    } 

                    foreach ($columns as $col=>$field) {
                        $val = $workSheet->getCell("$col$i")->getValue();
                       
                        if($field == "name" && $val == "") {
                            $got_data = 0;
                            break;
                        } else {
                            $data_row[$field] = $val;
                        }                       
                    }                    

                    // print_r($data_row);
                    // echo "<br><br>";
                    if($got_data == 0) {
                        continue;
                    }

                    $data_insert[] = $data_row;
                   
                }

                // dd($data_insert);
                // DB::table('trade')->truncate();
                DB::table($table_name)->insert($data_insert);

                return redirect('admin/material/'.$type.'/import')->with('success', 'Data imported successfully! '.$max);
            }
        }

         // print_r($id);
         $user      = auth()->user();
         $role      = $user->getRole($user->id);
         $user_id    = $user->id;
 
         $res       = $user->getResidential($user->id);
         $residential_id = $res->residential_id;
 
         // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)"); 
         // // print_r($count);
         // $count  = $count[0]->count;
         // // echo 'COUNT : '.$count;
         // if($count == 0) {
         //     dd("Permission not allow for the project");
         //     //  return view('overview.index', compact('residential', 'user', 'role'));
         // }
         
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");     

        return view("material.import", compact("title", "template", "residential", "role", "user"));
    }
    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user       = auth()->user();
        $user_id    = $user->id;
        $res        = $user->getResidential($user->id);
        $company_id = $res->company_id;

        if($request['type'] == "trade") {
            $validator = Validator::make($request->all(), [
                'trade_name' => 'required|max:1000',    
            ]);

        } else if($request['type'] == "category") {
            $validator = Validator::make($request->all(), [
                'category_name' => 'required|max:1000',    
            ]);

        } else {
            $validator = Validator::make($request->all(), [
                'trade'         => 'required',    
                'item_name'     => 'required|max:1000',    
                // 'item_desc'     => 'required|max:3000',    
                'item_unit'     => 'required',                   
            ]);
        }

        if ($validator->passes()) {
            $data_row = [];

            if($request['type'] == "trade") {
                $data_row['company_id'] = $company_id;
                $data_row['parent_id']  = isset($request['trade_parent']) ? $request['trade_parent'] : 0;
                $data_row['name']       = $request['trade_name'];
                $data_row['create_by']  = $user_id;
                $data_row['create_at']  = date("Y-m-d H:i:s");

                $id = DB::table('trade')->insertGetId($data_row);

            } else if($request['type'] == "category") {
                $data_row['company_id'] = $company_id;
                $data_row['parent_id']  = isset($request['parent_cat']) ? $request['parent_cat'] : 0;
                $data_row['name']       = $request['category_name'];
                $data_row['create_by']  = $user_id;
                $data_row['create_at']  = date("Y-m-d H:i:s");

                $id = DB::table('category')->insertGetId($data_row);

            } else {
                $data_row['company_id'] = $company_id;               
                $data_row['name']       = $request['item_name'];
                $data_row['description']= $request['item_desc'];
                $data_row['unit']       = $request['item_unit'];
                $data_row['img']        = $request['filename'];
                $data_row['create_by']  = $user_id;
                $data_row['create_at']  = date("Y-m-d H:i:s");

                $id = DB::table('item')->insertGetId($data_row);
            }           

            return response()->json(['success'=>'Added new records.', 'id' => $id, 'request'=>$request->all()]);
        }

        // dd($request);
       
        return response()->json(['error'=>$validator->errors()->all(), 'request'=>$request->all()]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show_trade(Request $request)
    {
        //  echo 'MaterialController > Show Trade';       
        // DB::enableQueryLog();
        // print_r($id);
        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials = Material::getMaterial('trade', $company_id);

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)"); 
        // // print_r($count);
        // $count  = $count[0]->count;
        // // echo 'COUNT : '.$count;
        // if($count == 0) {
        //     dd("Permission not allow for the project");
        //     //  return view('overview.index', compact('residential', 'user', 'role'));
        // } 
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('material.index', compact('residential', 'user', 'role', 'materials'));
    }

    public function getTradeList(Request $request) {
        // dd($request);
        $user    = auth()->user();
        $role    = $user->getRole($user->id);
        $user_id = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials = Material::getMaterial('trade', $company_id);

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      

        // $columnIndex    = "";
        // $columnName     = "name";
        // $columnSortOrder= "asc";
        // $searchValue    = "a";

        // Total records
        $totalRecords           = DB::table(Config::get('constants.tables.trade'))->select(DB::raw('COUNT(*) as allcount'))->where('company_id', '=', $company_id)->value('allcount');  
        // Material::select('count(*) as allcount')->count();
        $totalRecordswithFilter = DB::table(Config::get('constants.tables.trade'))->select(DB::raw('COUNT(*) as allcount'))->where('name', 'LIKE', '%'.$searchValue.'%')->value('allcount');  
        //Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

        // Fetch records
        // $records = Material::orderBy($columnName,$columnSortOrder)
        // ->where('trade.name', 'like', '%' .$searchValue . '%')
        // ->select('trade.*')
        // ->skip($start)
        // ->take($rowperpage)
        // ->get();

        $records = DB::table(Config::get('constants.tables.trade'))->orderBy($columnName,$columnSortOrder)
            ->where('company_id', '=', $company_id)
            ->where('name', 'LIKE', '%'.$searchValue.'%')->skip($start)->take($rowperpage)->get();  

        $data_arr   = array();
        $num        = 1;

        foreach($records as $record){
            $id     = $record->id;            
            $name   = $record->name;
            $status = ($record->status == 0) ? "Inactive" : "Ok";

            $data_arr[] = array(
                "id"        => '',            
                "name"      => $name,
                "status"    => $status,
                "action"    => '<a href="trade/edit/'.$id.'" class="action-btn"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
                // "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_Item"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
            );

            $num++;
        }

        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr
        );
        // echo json_encode($response);

        // $response = array(
        //     "recordsTotal"  => intval( $totalRecords ),  // total number of records
		// 	"data"          => $data_arr, // total data array
		// 	"request"       => $request // total data array
        // );

        // echo json_encode(array('draw'=> '', 'recordsTotal'=>$totalData, 'recordsFiltered'=>$totalRecordswithFilter, 'data' => $data, 'request'=>$request)); 
        echo json_encode($response);

        exit;
        
    }

    public function show_item(Request $request)
    {
        //  echo 'MaterialController > Show Item';       
        // DB::enableQueryLog();
        // print_r($id);
        $user       = auth()->user();
        $role       = $user->getRole($user->id);
        $user_id    = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials      = Material::getMaterial('item', $company_id);
        $measurements   = Material::getMeasurements();

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)"); 
        // // print_r($count);
        // $count  = $count[0]->count;
        // // echo 'COUNT : '.$count;
        // if($count == 0) {
        //     dd("Permission not allow for the project");
        //     //  return view('overview.index', compact('residential', 'user', 'role'));
        // }
        
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('material.index', compact('residential', 'user', 'role', 'materials', 'measurements'));
    }

    public function getItemList(Request $request) {
        // dd($request);
        $user    = auth()->user();
        $role    = $user->getRole($user->id);
        $user_id = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials = Material::getMaterial('trade', $company_id);

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      

        // $columnIndex    = "";
        // $columnName     = "name";
        // $columnSortOrder= "asc";
        // $searchValue    = "a";

        // Total records
        $totalRecords           = DB::table(Config::get('constants.tables.item'))->select(DB::raw('COUNT(*) as allcount'))->where('company_id', '=', $company_id)->value('allcount');  
        // Material::select('count(*) as allcount')->count();
        $totalRecordswithFilter = DB::table(Config::get('constants.tables.item'))->select(DB::raw('COUNT(*) as allcount'))->where('name', 'LIKE', '%'.$searchValue.'%')->value('allcount');  
        //Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

        // Fetch records
        // $records = Material::orderBy($columnName,$columnSortOrder)
        // ->where('trade.name', 'like', '%' .$searchValue . '%')
        // ->select('trade.*')
        // ->skip($start)
        // ->take($rowperpage)
        // ->get();

        $records = DB::table(Config::get('constants.tables.item'))->orderBy($columnName,$columnSortOrder)
            ->where('company_id', '=', $company_id)
            ->where('name', 'LIKE', '%'.$searchValue.'%')->skip($start)->take($rowperpage)->get();  

        $data_arr   = array();
        $num        = 1;

        foreach($records as $record){
            $id     = $record->id;            
            $name   = $record->name;
            $status = ($record->status == 0) ? "Inactive" : "Ok";

            $data_arr[] = array(
                "id"        => '',            
                "name"      => $name,
                "status"    => $status,
                //{{ url('admin/material/'.$type.'/create') }}
                "action"    => '<a href="item/edit/'.$id.'" class="action-btn"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
            );

            $num++;
        }

        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr
        );
        // echo json_encode($response);

        // $response = array(
        //     "recordsTotal"  => intval( $totalRecords ),  // total number of records
		// 	"data"          => $data_arr, // total data array
		// 	"request"       => $request // total data array
        // );

        // echo json_encode(array('draw'=> '', 'recordsTotal'=>$totalData, 'recordsFiltered'=>$totalRecordswithFilter, 'data' => $data, 'request'=>$request)); 
        echo json_encode($response);

        exit;
        
    }

    public function show_category(Request $request)
    {
        //  echo 'MaterialController > Show Category';       
        // DB::enableQueryLog();
        // print_r($id);
        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials = Material::getMaterial('category', $company_id);
       
        $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");           

        return view('material.index', compact('residential', 'user', 'role', 'materials'));
    }

    public function getCategoryList(Request $request) {
        // dd($request);
        $user    = auth()->user();
        $role    = $user->getRole($user->id);
        $user_id = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $materials = Material::getMaterial('trade', $company_id);

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      

        // $columnIndex    = "";
        // $columnName     = "name";
        // $columnSortOrder= "asc";
        // $searchValue    = "a";

        // Total records
        $totalRecords           = DB::table(Config::get('constants.tables.category'))->select(DB::raw('COUNT(*) as allcount'))->where('company_id', '=', $company_id)->value('allcount');  
        // Material::select('count(*) as allcount')->count();
        $totalRecordswithFilter = DB::table(Config::get('constants.tables.category'))->select(DB::raw('COUNT(*) as allcount'))->where('name', 'LIKE', '%'.$searchValue.'%')->value('allcount');  
        //Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

        // Fetch records
        // $records = Material::orderBy($columnName,$columnSortOrder)
        // ->where('trade.name', 'like', '%' .$searchValue . '%')
        // ->select('trade.*')
        // ->skip($start)
        // ->take($rowperpage)
        // ->get();

        $records = DB::table(Config::get('constants.tables.category'))->orderBy($columnName,$columnSortOrder)
            ->where('company_id', '=', $company_id)
            ->where('name', 'LIKE', '%'.$searchValue.'%')->skip($start)->take($rowperpage)->get();  

        $data_arr   = array();
        $num        = 1;

        foreach($records as $record){
            $id     = $record->id;            
            $name   = $record->name;
            $status = ($record->status == 0) ? "Inactive" : "Ok";

            $data_arr[] = array(
                "id"        => '',            
                "name"      => $name,
                "status"    => $status,
                "action"    => '<a href="category/edit/'.$id.'" class="action-btn"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
                // "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_Item"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
            );

            $num++;
        }

        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr
        );
        // echo json_encode($response);

        // $response = array(
        //     "recordsTotal"  => intval( $totalRecords ),  // total number of records
		// 	"data"          => $data_arr, // total data array
		// 	"request"       => $request // total data array
        // );

        // echo json_encode(array('draw'=> '', 'recordsTotal'=>$totalData, 'recordsFiltered'=>$totalRecordswithFilter, 'data' => $data, 'request'=>$request)); 
        echo json_encode($response);

        exit;
        
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($type, $id, Request $request)
    {
        $user           = auth()->user();
        $role           = $user->getRole($user->id);
        $user_id        = $user->id;
        $res            = $user->getResidential($user->id);
        $company_id     = $res->company_id;      
        $residential_id = $res->residential_id;

        $trades         = Material::getTrades($company_id);
        $materials      = Material::getMaterial('trade', $company_id);
        $measurements   = Material::getMeasurements();
        $categories     = Material::getCategories($company_id);

        $residential    = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");        
        

        if($type == "trade") {       
            $material_details   = DB::select("SELECT * FROM ".Config::get('constants.tables.trade')." WHERE id = '$id' AND company_id = '$company_id'");
            if(@$material_details)
                return back();

            return view('material.edit_trade', compact('residential', 'user', 'role', 'materials', 'material_details', 'trades'));   
        
        } else  if($type == "category") {       
            $category_details   = DB::select("SELECT * FROM ".Config::get('constants.tables.category')." WHERE id = '$id' AND company_id = '$company_id'");
            if($category_details)
                $category_details[0]->cat_id = 2;
            else
                return back();

            return view('material.edit_category', compact('residential', 'user', 'role', 'materials', 'category_details', 'categories'));   

        } else {
            $item_details = DB::select("SELECT * FROM ".Config::get('constants.tables.item')." WHERE id = '$id' AND company_id = '$company_id'");
            if($item_details)
                $item_details[0]->trade_id = 2;
            else
                return back();
            // dd($item_details);
            
            return view('material.edit_item', compact('residential', 'user', 'role', 'materials', 'item_details', 'measurements', 'trades', 'company_id'));   
        }
        
       
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($type, $id, Request $request)
    {
        $user           = auth()->user();
        $role           = $user->getRole($user->id);
        $user_id        = $user->id;
        $res            = $user->getResidential($user->id);
        $company_id     = $res->company_id;      
        $residential_id = $res->residential_id;

        $trades         = Material::getTrades($company_id);
        $materials      = Material::getMaterial('trade', $company_id);
        $measurements   = Material::getMeasurements();
        $categories     = Material::getCategories($company_id);

        $residential    = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");        

        if($type == "item") {       
            DB::enableQueryLog(); 
            $filename   = $request->filename;
            $folder     = public_path('images'.DIRECTORY_SEPARATOR.$company_id);
            $msg = "";

            if(!file_exists($folder)) {
                File::makeDirectory($folder, $mode = 777, true, true);
            }
            $file_ext   = explode('.', $filename);
            $new_filename= "item_".$id.".".$file_ext[1];

            $from_path  = public_path($filename);  
            $to_path    = public_path('images'.DIRECTORY_SEPARATOR.$company_id.DIRECTORY_SEPARATOR.$new_filename); 

            $msg = "[from_path: $from_path] [to_path: $to_path]";

            if(file_exists($from_path)) {
                if(File::move($from_path, $to_path)) {
                    $msg .= "\n [OK] Move file [from_path: $from_path] [to_path: $to_path]";
                } else {
                    $msg .= "\n [FAIL] Move file [from_path: $from_path] [to_path: $to_path]";
                }
            }

            $result = DB::table(Config::get('constants.tables.item'))
                ->where('id', $id)
                ->where('company_id', $company_id)
                ->update([
                    'name'          => $request->item_name,
                    'description'   => $request->item_desc,
                    'unit'          => $request->item_unit,
                    'img'           => $new_filename,
                    'update_by'     => $user_id
                ]);

            $count = DB::table(Config::get('constants.tables.trade_item'))->select(DB::raw('COUNT(*) as count'))->where('item_id', '=', $id)->value('count');  

            if($count == 1) {
                DB::table(Config::get('constants.tables.trade_item'))
                ->where('item_id', $id)
                ->delete();
            } 
           
            // dd($request->trade);
            $total_trade = count($request->trade);
            for($i = 0; $i < $total_trade; $i++) {
                DB::table(Config::get('constants.tables.trade_item'))
                ->insert([
                    'company_id'   => $company_id,                    
                    'item_id'      => $id,                    
                    'trade_id'      => $request->trade[$i],                    
                    'create_by'     => $user_id,
                    'create_at'     => now()
                ]);

            }
            
                // dd(DB::getQueryLog());
            // return redirect()->back()->with('status', 'Item Updated Successfully!');   
            return response()->json(['success'=>'Record updated successfully!', 'msg' => $msg, 'request'=>$request->all()]);
        }
        
    }


    public function search_material(Request $request) {
        $user           = auth()->user();
        $role           = $user->getRole($user->id);
        $user_id        = $user->id;
        $res            = $user->getResidential($user->id);
        $company_id     = $res->company_id;      
        $residential_id = $res->residential_id;

        $trades         = Material::getTrades($company_id);
        $materials      = Material::getMaterial('trade', $company_id);
        $measurements   = Material::getMeasurements();
        $categories     = Material::getCategories($company_id);

        $msg            = "";
        $total          = 0;
        $type           = $request->type;

        $msg .= "[type: $type]";
 
        DB::enableQueryLog(); 
        if($type == "item") {
            $materials   = DB::select("SELECT * FROM ".Config::get('constants.tables.item')." WHERE ( name LIKE '%".$request->search."%' OR description LIKE '%".$request->search."%') AND company_id = '$company_id'");
            $total       = DB::table(Config::get('constants.tables.item'))->select(DB::raw('COUNT(*) as count'))
                            ->where('company_id', '=', $company_id)
                            ->where('name', 'LIKE %', $request->search.'%')
                            ->orWhere('description', 'LIKE', '%'.$request->search.'%')->value('count'); 
            
            $totalRecords= DB::table(Config::get('constants.tables.item'))->select(DB::raw('COUNT(*) as count'))
                            ->where('company_id', '=', $company_id)
                            ->where('name', 'LIKE', '%'.$request->search.'%')
                            ->orWhere('description', 'LIKE', '%'.$request->search.'%')->value('count');             
            // dd(DB::getQueryLog());
        }
        
        return response()->json(['status' => 'success', 'total'=>$totalRecords, 'msg' => $msg, 'request'=>$request->all(), 'materials'=>$materials]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
