<?php

namespace App\Http\Controllers\Admin;

use App\Actions\Fortify\CreateNewUser;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreUserRequest;
use App\Models\User;
use App\Models\Role;
use Illuminate\Http\Request;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Config;
use Exception;

// include(app_path().'/includes/config.php');
// include(app_path().'/includes/table.php');

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $users = User::all();
        // return view('admin.users.index')->with(['users' => User::all()]);

        // DB::enableQueryLog();

        $user = auth()->user();
        $role = $user->getRole($user->id);
        $user_id     = $user->id;

        $res    = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $arr_res = explode(',', $residential_id);

        $sql = "SELECT ru.* FROM role_user AS ru LEFT JOIN users AS u ON u.id = ru.user_id WHERE";
        $i = 0;
        foreach($arr_res as $res_id) {           
            $sql .= ($i == 0) ? " FIND_IN_SET($res_id, ru.residential_id) " : " OR FIND_IN_SET($res_id, ru.residential_id)";
            $i++;
        }
        $sql .= " ORDER BY u.name";
        // $sql .= ")";
        $result = DB::select($sql);

        $temp = array();
        // $i = 0;
        foreach($result as $row) {
            // $row = $row[0];
            $user_id = $row->user_id;
            $role_id = $row->role_id;

            $user  = DB::select("SELECT * FROM users WHERE id = '$user_id' LIMIT 1");            
            $role  = DB::select("SELECT name FROM roles WHERE id = '$role_id'");
            
            $user[0]->role = $role[0]->name;
            $temp[] = $user[0];
            // $i++;
        }
            // echo '<br>[res_id: '.$res_id.']';
        //    dd($temp);
        // $company_id = DB::select("SELECT * FROM residential WHERE company_id = '$company_id' order by u.name asc");

        // $users = DB::select("SELECT * FROM residential WHERE company_id = '$company_id' order by u.name asc");

        // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)");        
        // $count  = $count[0]->count;        

        $residential = DB::select("SELECT * FROM residential WHERE id IN ($residential_id) order by name asc");

        // $res_list   = DB::table(TABLE_RESIDENTIAL)->where('company_id', '=', $company_id)->where('status', '=', '1')->get();
        // $role_list  = DB::table(TABLE_ROLE)->get();
		$res_list   = DB::table(Config::get('constants.tables.residential'))->where('company_id', '=', $company_id)->where('status', '=', '1')->get();
        $role_list  = DB::table(Config::get('constants.tables.roles'))->get();
        $vendor_list= DB::table(Config::get('constants.tables.vendor'))->get();


        if(Gate::denies('logged-in')) {
            // dd('no access allowed');
			return redirect('/login');
        } 
        
        // $users = User::where($sql);
        // dd(DB::getQueryLog()); 
        // if(Gate::allows('is-hq')) {
        // return view('admin.users.index', ['users' => User::all()]);
        return view('admin.users.index', ['users' => $temp, 'residential' => $residential, 'res_list' => $res_list, 'role_list' => $role_list, 'vendor_list'=>$vendor_list]);
        // return view('admin.users.index')->with(['users' => User::where()]);
        // }
    }
	
	public function profile() {
		$user 			= auth()->user();
        $role 			= $user->getRole($user->id);
        $user_id     	= $user->id;
        $res    		= $user->getResidential($user->id);
        $residential_id = $res->residential_id;

        $residential 	= DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc"); 

        return view('layouts.profile', compact('residential', 'user', 'role'));
	}
	
	public function updateProfile(Request $request) {
		define("TABLE_USER", Config::get('constants.tables.user'));
		define("TABLE_RESIDENTIAL", Config::get('constants.tables.residential'));
		
		$user    		= auth()->user();
        $role    		= $user->getRole($user->id);
        $user_id 		= $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        // $materials 		= Material::getMaterial('trade', $company_id);
		// $residential 	= DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");
		
		$status			= "success";
		$msg			= "";
		
		try {
			$password 			= $request->pass;
			$confirm_password	= $request->pass_again;
			
			if($password != "") {
				if($password == $confirm_password) {
					$data	= array();			
					$data['updated_by']	= $user_id;
					$data['updated_at']	= date("Y-m-d H:i:s");
					$data['password']	= Hash::make($password);
					
					$result = DB::table(Config::get('constants.tables.user'))
					->where('id', $user_id)
					->update($data);
					
				} else {
					$msg = "'New Password' and 'New Password Again' must match.";
					return response()->json(['status'=>'fail 1', 'request'=>$request->all(), 'msg'=>$msg]);
					exit;
				}
			}

            // dd(DB::getQueryLog());
		} catch(\Exception $e) {
			$status = "fail";
			// $errorCode = $e->errorInfo[1];
			$errorCode = $e->getCode();	//'000';
			// if($errorCode == '1062'){
				// dd('Duplicate Entry');
				// $msg 	= "Email (".$request->email.") already exists!";
				// $status = "fail";
			// } else {
				// $msg 	= "[ErrCode: ".$errorCode."] Failed to update user.";
			// }
			$msg 	= "[ErrCode: ".$errorCode."] Failed to update user.";
			// report($e);
			return response()->json(['status'=>$status, 'msg'=>$msg, 'e'=>$e->getMessage()]);
			// exit;
		}
		
		return response()->json(['status' => $status, 'msg' => $msg, 'request'=>$request->all()]);
	}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.users.create', ['roles' => Role::all()]);
    }

    public function store(Request $request)
    {
        // dd('UserController > Store');
        $user       = auth()->user();
        $role       = $user->getRole($user->id);
        $user_id    = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        $user_email = $request->email;

        DB::enableQueryLog();
        $id = "";

        $msg = ""; 
        $count = DB::table(Config::get('constants.tables.user'))->select(DB::raw('COUNT(*) as count'))                
                ->where('email', '=', $user_email)->value('count');

        // dd(DB::getQueryLog());
        if($count == 0) {
			// $newUser 	= new CreateNewUser();
			// $add_user 	= $newUser->create($request->only(['name', 'email', 'password', 'password_confirmation']));
			// $add_user->roles()->sync($request->roles);
			$password 			= $request->password;
			$confirm_password	= $request->confirm_password;
		
			if($password == $confirm_password) {
				 $id = DB::table(Config::get('constants.tables.user'))                
					->insertGetId([
						'name'          => $request->name,
						'tel'           => $request->tel,
						'email'         => $request->email,
						'status'        => $request->status,
						'email'         => $request->email,                       
						'password'		=> Hash::make($password),              
						'created_by'    => $user_id,
						'created_at'    => now() 
					]);     
			} else {
				$msg = "'Password' and 'Confirm password' must match.";
				return response()->json(['status'=>'fail 1', 'request'=>$request->all(), 'msg'=>$msg]);
				exit;
			}

        } else {
            $msg = "User already exists.";
            return response()->json(['status'=>'fail 2', 'request'=>$request->all(), 'msg'=>$msg]);
            exit;
        }

        $count = DB::table(Config::get('constants.tables.role_user'))->select(DB::raw('COUNT(*) as count'))
                ->where('user_id', '=', $id)
                ->where('company_id', '=', $company_id)->value('count');        
        
        if($count == 0) {
            $projects   = implode(',', $request->project);

            $result     = DB::table(Config::get('constants.tables.role_user'))
            ->insert([
                'role_id'       => $request->role,
                'residential_id'=> $projects,
                'user_id'       => $id,
                'company_id'    => $company_id,
				'vendor_id'     => $request->vendor, 
                'created_by'    => $user_id,
                'created_at'    => now()
            ]);

        } else {
            $msg = "User already exists.";
            return response()->json(['status'=>'fail 3', 'request'=>$request->all(), 'msg'=>$msg]);
        }
                
        return response()->json(['status'=>'success', 'request'=>$request->all(), 'user_id'=>$id, 'msg'=>$msg]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store_old(StoreUserRequest $request)
    {
        // $validatedData = $request->validated();
        // $user = User::create($validatedData);

        // $user = User::create($request->except(['_token', 'roles']));

        $newUser = new CreateNewUser();
        $user = $newUser->create($request->only(['name','email','password', 'password_confirmation']));

        $user->roles()->sync($request->roles);
        $request->session()->flash('success', 'You have created the user');
        
        return redirect(route('admin.users.index'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
        // echo 'UserController > Show > '.$id;
        
        $user       = auth()->user();
        $role       = $user->getRole($user->id);
        $user_id    = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        // DB::enableQueryLog();        
        $projects       = $user->getResidential($id);        
        $details        = $user->getUserData($id);       
        
        $user_role  = DB::table(Config::get('constants.tables.role_user'))->where('user_id', '=', $id)->first();
        $res_list   = DB::table(Config::get('constants.tables.residential'))->where('company_id', '=', $company_id)->where('status', '=', '1')->get();
        $role_list  = DB::table(Config::get('constants.tables.roles'))->get();

        // dd(DB::getQueryLog());
        // $materials = Material::getMaterial('trade', $company_id);
        // return response()->json(['status'=>'Failed to delete image.', 'request'=>$request->all()]);

        if(!$details) {
            return response()->json(['status'=>'error', 'msg'=>'Failed to load data.']);
        }

        return response()->json(['status'=>'success', 'request'=>$request->all(), 'user_id'=>$id, 'projects' => $projects, 'details'=>$details[0], 'user_role'=>$user_role]);

    }

    public function getUserList(Request $request) {
        // dd($request);
        $user    = auth()->user();
        $role    = $user->getRole($user->id);
        $user_id = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;

        ## Read value
        $draw           = $request->get('draw');
        $start          = $request->get("start");
        $rowperpage     = $request->get("length"); // Rows display per page

        $columnIndex_arr= $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr      = $request->get('order');
        $search_arr     = $request->get('search');

        $columnIndex    = $columnIndex_arr[0]['column']; // Column index
        $columnName     = $columnName_arr[$columnIndex]['data']; // Column name
        $columnSortOrder= $order_arr[0]['dir']; // asc or desc
        $searchValue    = $search_arr['value']; // Search value      
        
        // Total records
        $totalRecords           = DB::table(Config::get('constants.tables.role_user'))->select(DB::raw('COUNT('. Config::get('constants.tables.role_user') .'.id) as allcount'))
                                    ->leftJoin(Config::get('constants.tables.user'), Config::get('constants.tables.user') .'.id', '=', Config::get('constants.tables.role_user') . '.user_id')
                                    ->where(Config::get('constants.tables.role_user') .'.company_id', '=', $company_id)->value('allcount');  
        // Material::select('count(*) as allcount')->count();
        $totalRecordswithFilter = DB::table(Config::get('constants.tables.role_user'))->select(DB::raw('COUNT('. Config::get('constants.tables.role_user') .'.id) as allcount'))
                    ->leftJoin(Config::get('constants.tables.user'), Config::get('constants.tables.user') .'.id', '=', Config::get('constants.tables.role_user') . '.user_id') 
                    ->where(Config::get('constants.tables.role_user') .'.company_id', '=', $company_id)  
                    ->where(Config::get('constants.tables.user').'.name', 'LIKE', '%'.$searchValue.'%')->value('allcount');  
        //Material::select('count(*) as allcount')->where('name', 'like', '%' .$searchValue . '%')->count();

        // Fetch records
        // $records = Material::orderBy($columnName,$columnSortOrder)
        // ->where('trade.name', 'like', '%' .$searchValue . '%')
        // ->select('trade.*')
        // ->skip($start)
        // ->take($rowperpage)
        // ->get();

        $records = DB::table(Config::get('constants.tables.role_user'))
            ->leftJoin(Config::get('constants.tables.user'), Config::get('constants.tables.user') .'.id', '=', Config::get('constants.tables.role_user') . '.user_id') 
            ->orderBy($columnName,$columnSortOrder)
            ->where(Config::get('constants.tables.role_user') .'.company_id', '=', $company_id)
            ->where(Config::get('constants.tables.user') .'.name', 'LIKE', '%'.$searchValue.'%')->skip($start)->take($rowperpage)->get();  

        $data_arr   = array();

        foreach($records as $record){
            $id     = $record->id;            
            $name   = $record->name;
            $email  = $record->email;
            $tel    = $record->tel;            
            $role_id= $record->role_id;            
            $status = ($record->status == 0) ? "Inactive" : "Active";

            $role  = DB::select("SELECT name FROM roles WHERE id = '$role_id'");          

            $data_arr[] = array(
                "id"        => '',            
                "name"      => $name,
                "email"      => $email,
                "tel"       => $tel,
                "role"      => $role[0]->name,
                "status"    => $status,
                "project"   => '',
                "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_User"><i class="fas fa-edit" data-id="'.$id.'"></i></a>',
                "record"    => $record
                // "action"    => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_Item"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
            );          
        }

        $response = array(
            "draw"                  => intval($draw),
            "iTotalRecords"         => $totalRecords,
            "iTotalDisplayRecords"  => $totalRecordswithFilter,
            "aaData"                => $data_arr
        );
        // echo json_encode($response);

        // $response = array(
        //     "recordsTotal"  => intval( $totalRecords ),  // total number of records
		// 	"data"          => $data_arr, // total data array
		// 	"request"       => $request // total data array
        // );

        // echo json_encode(array('draw'=> '', 'recordsTotal'=>$totalData, 'recordsFiltered'=>$totalRecordswithFilter, 'data' => $data, 'request'=>$request)); 
        echo json_encode($response);

        exit;
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        return view('admin.users.edit', [
            'roles' => Role::all(),
            'user' => User::find($id)
        ]);
    }

    public function update(Request $request, $id)
    {
        $user       = auth()->user();
        $role       = $user->getRole($user->id);
        $user_id    = $user->id;

        $res            = $user->getResidential($user->id);
        $residential_id = $res->residential_id;
        $company_id     = $res->company_id;
		$status 		= "success";
		
		$email 	= DB::table(Config::get('constants.tables.user'))->select(DB::raw('email'))
                ->where('id', '=', $id)->value('email');
               
       // DB::enableQueryLog();
		try {
			$password 			= $request->password;
			$confirm_password	= $request->confirm_password;
			
			$data	= array();
			$data['name']			= $request->name;
			$data['tel']			= $request->tel;			
			$data['status']			= $request->status;			
			$data['updated_by']		= $user_id;
			$data['updated_at']		= date("Y-m-d H:i:s");
			
			if($email != $request->email) {
				$data['email']		= $request->email;
			}
			
			if($password != "" && $password == $confirm_password) {
				$data['password']	= Hash::make($password);				
			} else {
				
			}
			
			$result = DB::table(Config::get('constants.tables.user'))
				->where('id', $id)
				->update($data);
			
            // dd(DB::getQueryLog());
		} catch(\Exception $e) {
			$status = "fail";
			// $errorCode = $e->errorInfo[1];
			$errorCode = $e->getCode();	//'000';
			// if($errorCode == '1062'){
				// dd('Duplicate Entry');
				// $msg 	= "Email (".$request->email.") already exists!";
				// $status = "fail";
			// } else {
				// $msg 	= "[ErrCode: ".$errorCode."] Failed to update user.";
			// }
			$msg 	= "[ErrCode: ".$errorCode."] Failed to update user.";
			// report($e);
			return response()->json(['status'=>$status, 'msg'=>$msg, 'e'=>$e->getMessage()]);
			// exit;
		}

        $count = DB::table(Config::get('constants.tables.role_user'))->select(DB::raw('COUNT(*) as count'))
                ->where('user_id', '=', $id)
                ->where('company_id', '=', $company_id)->value('count');

        if($count > 0) {
            $projects   = implode(',', $request->project);

			try {
				DB::table(Config::get('constants.tables.role_user'))
					->where('user_id', $id)
					->where('company_id', $company_id)
					->update([
						'role_id'       => $request->role,
						'residential_id'=> $projects,
						'updated_by'    => $user_id,
						'updated_at'    => now()
					]);
				
			} catch(Exception $e) {
				// $errorCode = $e->errorInfo[1];
				// if($errorCode == '1062'){
					// dd('Duplicate Entry');
					// $status = "Email (".$request->email.") duplicate entry!";
					// $status = "fail";
				// }
				// report($e);
				return response()->json(['status'=>$status, 'request'=>$request->all(), 'user_id'=>$id]);
				exit;
			}
			
			
		
        } else {
            return response()->json(['status'=>$status, 'request'=>$request->all(), 'user_id'=>$id]);
        }
        
        
        return response()->json(['status'=>$status, 'request'=>$request->all(), 'user_id'=>$id]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update_old(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name'  => 'required|max:255',
            'email' => 'required|max:255:unique:users',
            // 'password' => 'required|min:6|max:150'
        ]);

        // $user = User::findOrFail($id);
        $user = User::find($id);

        DB::enableQueryLog();        

        if(!$user) {
            $request->session()->flash('error', 'You cannot edit this user');
            // dd(DB::getQueryLog());

            return redirect(route('admin.users.index'));

        } else {
            DB::enableQueryLog();
            $user->update($request->except(['_token', 'roles']));
            $user->roles()->sync($request->roles);

            // dd(DB::getQueryLog());
            $request->session()->flash('success', 'You have updated the user');
            return redirect(route('admin.users.index'));
        }
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, Request $request)
    {
        // User::destroy($id);

        // $request->session()->flash('success', 'You have deleted the user');

        return redirect(route('admin.users.index'));
    }
}
