$(function () {
    console.log('user.js');
    ListTable();

    $('#vendor_dropdown').hide();

    $('#user-role').change(function() {
        if ($(this).val() == '5') { 
            $('#vendor_dropdown').show(); 
        } else {
            $('#vendor_dropdown').hide().find('select').val(0);
        }
    }).change();

    $('#edit_User').on('shown.bs.modal', function() {
        $('#user-role').change();
    });

    $(document).on('click', '.btnAddUser', function() {
        console.log('[Add User] Clicked!');
        $("#edit_User .user-name").text('Add User');

        $('input[type=text]').each(function() {            
            $(this).val('');           
        });
        $('#user-role').val('');
        $('input[type=checkbox][name=project]').each(function() {            
            $(this).prop('checked', false);           
        }); 

        $('#edit_User .btnSaveStaff').data('id', '');
    });

     /* When click show user */
    $(document).on('click', '#pm_staff_settings .fa-edit', function () {
        var user_id = $(this).data('id');
        $('#edit_User .btnSaveStaff').data('id', user_id);

        $('input[type=checkbox][name=project]').each(function() {            
            $(this).prop('checked', false);           
        });      

        $.ajax({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },            
            url     : base_url + 'admin/users/show/'+user_id,
            type    : 'GET',           
            data: {
            },
            success: function(data) {                
                console.log('Get User Data Success! '+user_id);                      

                if(data.status == "success"){
                    // alert(data.status);
                    var detail      = data.details;
                    var user_role   = data.user_role;
                    var arr_res     = new Array();

                    if(data.projects != "") {
                        arr_res = data.projects.split(',');
                        console.log(arr_res);
                        $('input[type=checkbox][name=project]').each(function() {
                            var cur_val = $(this).val();
                            if(arr_res.includes(cur_val)){
                                $(this).prop('checked', true);
                            }
                        });
                    }                                       

                    $("#edit_User .user-name").text(detail.name);
                    $("#edit_User .user-name").val(detail.name);
                    $("#edit_User #user-contact").val(detail.tel);
                    $("#edit_User #user-email").val(detail.email);
                    $("#edit_User #user-role").val(user_role);
                    $("#edit_User #user-status").val(detail.status);

                    $('.selectpicker').selectpicker('refresh');

                }else{
                    printErrorMsg(data.msg);
                    
                }
             
            },
        });
    });

    $(document).on('click', '#edit_User .btnSaveStaff', function() {
        var user_id = $('#edit_User .btnSaveStaff').data('id');        
        console.log('[.btnSaveStaff] [user_id: '+user_id+'] Clicked!');
        
        var name    = $("#edit_User #user-name").val();
        var vendor_id    = $("#edit_User #user-vendor").val();
        var tel     = $("#edit_User #user-contact").val();
        var email   = $("#edit_User #user-email").val();
        var role    = $("#edit_User #user-role").val();
        var status  = $("#edit_User #user-status").val(); 
        var pass		= $("#edit_User #user-pass").val(); 
        var confirm_pass= $("#edit_User #user-confirm-pass").val(); 
        var project = [];

        $("input:checkbox[name=project]:checked").each(function(){
            project.push($(this).val());
        });

        var formData = JSON.stringify({
			'action'	: "update_user",
            'name'      : name,
            'tel'       : tel,
            'email'     : email,
            'role'      : role,
            'status'    : status,
            'project'   : project,
            'password'	: pass,
            'confirm_password'  : confirm_pass,
            'vendor_id':vendor_id
		});

        var ajaxURL = base_url + 'admin/users/update/'+user_id;
        var method  = 'POST';

        if(user_id == "undefined" || user_id == "") {
            ajaxURL = base_url + 'admin/users/store';
            method  = 'PUT';
        }

        console.log('[ajaxURL]' + ajaxURL);
       
        $.ajax({
            headers : {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url     : ajaxURL,
            type    : method,           
            data    : formData,
            success : function(data) {                
                if(data.status == "success"){
					var msg = "<strong>Success</strong><br>Data has been saved.";
					SuccessPopup(msg);
                    $("#pm_staff_settings").remove();
                    $('#edit_User').modal('hide');					
                    ListTable();

                }else{

					var msg = "<strong>ERROR</strong><br>"+ data.msg;
					AlertPopup(msg);
                }
             
            },
        });
    });

    function ListTable() {
        $("#pm_staff_settings").remove();

        var date	= new Date();
		var month 	= date.getMonth() + 1;
			month 	= (month < 10) ? '0'+month : month;
		var today	= date.getFullYear() + month + date.getDay();
        var tableName = "pm_staff_settings";
        var row = '';
		row += '<table id="'+tableName+'" class="table table-bordered mt-15 table_pm_staff_settings table-hover" data-category="0">';
		row += '<thead>';
		row += '<tr>';
		row += '<th>#</th>';
		row += '<th class="excelExport">Name</th>';		
		row += '<th class="excelExport">Email</th>';
		row += '<th class="excelExport">Contact</th>';
		row += '<th class="excelExport">Role</th>';
		row += '<th class="excelExport">Project</th>';		
		row += '<th class="excelExport">Status</th>';		
		row += '<th style="width:6%">Action</th>';
		row += '</tr>';
		row += '</thead>';
		row += '<tbody>';
		row += '</tbody>';
		row += '</table>';
		$('#ListTable').html(row);

        var formData = {
			'action'	: "listing",			
		};
        
        var user_table = $('#pm_staff_settings').DataTable({
            processing  : true,
            serverSide  : false,
            dom: `
            <'row'<'col-sm-12 col-md-5 text-left'f><'col-sm-12 col-md-7 text-right dataTables_pager'lB>>
            <'row'<'col-sm-12'tr>>
            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 'p>>`,
            ajax        : {
				headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: base_url + 'admin/users/list',
				type: "post",  
				data: formData,
				error: function(){  
					console.log("error");
				}
			}, 
            columnDefs: [				
				{
					"targets"	: [0,2,3,4,5,6,7],
					"className"	: "text-center",
				},               
			],
            buttons: [
				{
					text: "<i class='fa fa-download' style='vertical-align:middle;'></i> <label style='margin:5px;'>Export</label>",
					extend: 'excelHtml5',
                    exportOptions: {
						columns: '.excelExport'
					},
					filename: 'Trade_List_'+today,
					title: '',
					className: 'btn-export',
					action: function (e, dt, button, config) {
						var that = this;
						if(confirm("Do you want to export trade listing to Excel file?")) {
							console.log('COnfirm == OK');
							that.processing(true);
							that.disable();
							setTimeout(function () {
								console.log('[excelHtml5]button',button);
								$.fn.dataTable.ext.buttons.excelHtml5.action.call(that, e, dt, button, config);
								
							}, 500);
							that.enable();
						} else {
							console.log('Confirm == Cancel');
						}
					}
				},
			],			           
            columns: [                
                { "data": null,"sortable": false, 
                    render: function (data, type, row, meta) {
                                return meta.row + meta.settings._iDisplayStart + 1;
                    }  
                },
                { data: 'name', name: 'name' },                  
                { data: 'email', name: 'email' },                  
                { data: 'tel', name: 'tel' },                  
                { data: 'role', name: 'role' },                  
                { data: 'project', name: 'project' },                  
                { data: 'status', name: 'status' },                  
                { data: 'action', name: 'action'},
            ],
            createdRow : function(row, data, index) {


                if(data.status == "Active") {
                    $('td', row).eq(6).addClass('active');
                } else {
                    $('td', row).eq(6).addClass('inactive');
                }
            }
        });         
       
    }
});