$(function () {
	console.log("overview.js");

	var cur_url = window.location.pathname;
	var arr_url = cur_url.split("/");
	var project_id = 0;
	var rolecat = arr_url[3];
	console.log("arr_url[4] --> " + arr_url[4]);

	if (arr_url[4] == "overview") {
		project_id = arr_url[5];
		ListRfTable(project_id);
	}

	$(document).on("click", ".modal-links", function () {
		var id = $(this).data("id");
		GetRfDetail(project_id, id);
	});

	function printErrorMsg(msg) {
		console.log(msg);
	}

	function ListRfTable(project_id) {
		var date = new Date();
		var month = date.getMonth() + 1;
		month = month < 10 ? "0" + month : month;
		var day = date.getDate();
		var today = date.getFullYear() + month + day;
		var tableName = "rflist_overview";

		var row = "";
		row += '<table id="' + tableName + '" class="table table-bordered mt-15 rflist_overview table-hover" data-category="0">';
		row += "<thead>";
		row += "<tr>";
		row += '<th style="width:5%">Date</th>';

		row += '<th class="excelExport" style="width:12%">RF #</th>';
		row += '<th class="excelExport" style="width:15%">Requested by</th>';
		row += '<th class="excelExport" style="width:10%">Contact #</th>';
		row += '<th class="excelExport" style="width:6%">Status</th>';
		row += '<th style="width:6%">Action</th>';

		row += "</tr>";
		row += "</thead>";
		row += "<tbody>";
		row += "</tbody>";
		row += "</table>";
		$("#rflistTabContent").html(row);

		console.log("ajax_url ==>  " + base_url + rolecat + "/requisition/list");
		console.log("[tableName: " + tableName + "] formData ==>  ", formData);

		columns = [
			{
				data: "create_at",
				name: "create_at",
			},
			{data: "requisition_no", name: "requisition_no"},
			{data: "create_by", name: "create_by"},
			{data: "contact", name: "contact"},
			{
				data: "status",
				name: "status",
				createdCell: function (td, cellData) {
					if (cellData == "InComplete") {
						$(td).css({"background-color": "#e6bfbf"});
					} else if (cellData == "Complete") {
						$(td).css({"background-color": "#cce6bf"});
					}
				},
			},
			{data: "action", name: "action", orderable: false},
		];

		console.log("[columns]", columns);
		var formData = {
			project_id: project_id,
			source: "overview",
		};
		$("#" + tableName).DataTable({
			processing: true,
			serverSide: false,
			responsive: true,
			dom: `
				<'row'<'col-sm-12 col-md-5 text-left'f><'col-sm-12 col-md-7 text-right dataTables_pager'lB>>
				<'row'<'col-sm-12'tr>>
				<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 'p>>`,
			ajax: {
				headers: {
					"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
				},
				url: base_url + rolecat + "/requisition/list",
				type: "post",
				data: formData,
				error: function () {
					console.log("error");
				},
			},
			columnDefs: [
				{
					targets: [0, 2, 3, 4, 5],
					className: "text-center",
				},
				{
					targets: 4,
					render: function (data, type, row) {
						if (row.status === "incomplete") {
							return '<span class="incomplete">' + data + "</span>";
						} else {
							return data;
						}
					},
				},
			],
			buttons: [
				{
					extend: "collection",
					text: "Export",
					buttons: [
						"copy",
						{extend: "csv", filename: "OverviewList_" + today},
						{extend: "excel", filename: "OverviewList_" + today},
						{extend: "pdf", filename: "OverviewList_" + today},
						"print",
					],
				},
			],
			columns: columns,
			order: [[0, "desc"]],
		});
	}

	function GetRfDetail(res_id, id) {
		$("#requisition_form .table-rf").empty();
		$("#requisition_form .rf_no").html("No. : ");

		$.ajax({
			headers: {
				"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
			},
			url: base_url + rolecat + "/requisition/detail",
			type: "POST",
			data: {
				project_id: project_id,
				id: id,
			},
			dataType: "json",
			success: function (data) {
				$("#requisition_form .request-info").empty();
				var company_info = data.company_info[0];
				var rf_detail = data.rf_detail[0];
				var rf_list = data.rf_list;

				console.log("[company_info_length: " + data.company_info.length + "] [rf_detail_length: " + data.rf_detail.length + "]");
				console.log("rf_detail: ", data.rf_detail[0]);
				console.log("rf_list: ", data.rf_list[0]);

				var row = "";
				if (data.status == "success") {
					if (data.company_info.length > 0) {
						$("#requisition_form .address-box").html(
							"<div>" + company_info.residential_name + ", </div>" + "<div>" + company_info.residential_addr + "</div>"
						);
						$("#requisition_form .to-info").html("<strong>To:</strong><br>Headquarters<br>" + company_info.company_addr);
						$("#requisition_form .logo-rf").css("background-image", "url(" + base_url + "/images/logo/" + company_info.logo + ")");
					}

					if (data.rf_detail.length > 0) {
						var create_dt = new Date(rf_detail.create_at);
						create_dt = ("0" + create_dt.getDate()).slice(-2) + "/" + ("0" + (create_dt.getMonth() + 1)).slice(-2) + "/" + create_dt.getFullYear();

						var creator_name = rf_detail.creator_name == null ? "" : rf_detail.creator_name;
						var creator_tel = rf_detail.creator_tel == null ? "" : rf_detail.creator_tel;

						$("#requisition_form .rf_no").html("No. : " + rf_detail.requisition_no);
						row += '<table class="table table-borderless">';
						row += "<tr><td>Request Date :</td><td>" + create_dt + "</td></tr>";
						row += "<tr><td>Requested by :</td><td>" + creator_name + "</td></tr>";
						row += "<tr><td>Contact # :</td><td>" + creator_tel + "</td></tr>";
						row += "</table>";

						$("#requisition_form .request-info").append(row);

						$("#requisition_form .btnRejectRf").show();
						$("#requisition_form .btnApproveRf").show();

						if (rf_detail.status > 1 && rf_detail.status < 6) {
							$("#requisition_form .btnApproveRf").hide();
						} else if (rf_detail.status == 6) {
							$("#requisition_form .btnApproveRf").hide();
							$("#requisition_form .btnRejectRf").hide();
						}
					}

					if (data.rf_list.length > 0) {
						var row2 = "";
						row2 += "<tr><th>#</th><th>Item Name</th><th>Item Description</th><th>Unit</th><th>Qty</th><th>RF Remarks</th></tr>";

						$.each(rf_list, function (idx, item) {
							var num = idx + 1;
							var remark = item.remark == null ? "" : item.remark;
							var item_id = item.item_id;

							row2 += "<tr><td>" + num + "</td>";
							row2 += '<td style="text-align:left;">' + item.name + "</td>";
							row2 += '<td style="text-align:left;">' + item.description + "</td>";

							if (item.unit == null) {
								row2 += "<td>-</td>";
							} else {
								row2 += '<td style="text-align:center;">' + item.unit + "</td>";
							}
							row2 += '<td style="text-align:center;">' + item.qty + "</td>";
							row2 += "<td>" + remark + "</td>";
							row2 += "</tr>";
						});

						$("#requisition_form .table-rf").append(row2);
					}
				} else {
					printErrorMsg(data);
				}
			},
		});
	}

	
});
