$(function () {
	console.log("material.js");

	var cur_url = window.location.pathname;
	var arr_url = cur_url.split("/");
	var deleteImgClicked = false;
	if (arr_url[4] == "material") {
		if (arr_url[5] == "trade") {
			ListTradeTable();
		} else if (arr_url[5] == "item") {
			ListItemTable();
		}
		// else {
		// 	ListCategoryTable();
		// }
	}

	// $(document).on("click", ".btnSaveCategory", function () {
	// 	console.log("[.btnSaveCategory] Clicked!");

	// 	var parent_cat = $("input[name='parent_cat']").val();
	// 	var cat_name = $("input[name='category_name']").val();
	// 	var cat_desc = $("input[name='category_desc']").val();

	// 	console.log("[cat_name: " + cat_name + "] ");

	// 	$.ajax({
	// 		headers: {
	// 			"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
	// 		},
	// 		URL: $(this).attr("action"),
	// 		type: "POST",
	// 		data: {
	// 			type: "category",
	// 			parent_cat: parent_cat,
	// 			category_name: cat_name,
	// 			category_desc: cat_desc,
	// 		},
	// 		success: function (data) {
	// 			console.log("Create Category Success!");
	// 			console.log("Error: ", data.error);

	// 			if ($.isEmptyObject(data.error)) {
	// 				alert(data.success);
	// 			} else {
	// 				printErrorMsg(data.error);
	// 			}
	// 		},
	// 	});
	// });

	$(document).on("click", ".btnSaveTrade", function () {
		console.log("[.btnSaveTrade] Clicked!");
		var trade_name = $("input[name='trade_name']").val();
		var trade_desc = $("textarea[name='trade_desc']").val();
		var item_id = $(this).data("id");
		console.log("[trade_name: " + trade_name + "] ");
		console.log("[trade_desc: " + trade_desc + "] ");

		if (!trade_name) {
			AlertPopup("<strong>WARNING</strong><br>Please fill in the Trade Name.");
			return;
		}

		if (item_id == "" || item_id == undefined) {
			ajax_url = base_url + "admin/material/trade/create";
		} else {
			ajax_url = base_url + "admin/material/trade/update/" + item_id;
		}

		$.ajax({
			headers: {
				"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
			},
			url: ajax_url,
			type: "POST",
			data: {
				type: "trade",
				trade_name: trade_name,
				trade_desc: trade_desc,
				item_id: item_id,
			},
			success: function (data) {
				if (data.status == "success") {
					SuccessPopup("<strong>Success</strong><br>Trade has been created.");
					$("#success-ok-button").on("click", function () {
						window.location = base_url + "admin/material/trade";
					});
					$("#SuccessPopup").on("hide.bs.modal", function () {
						$("#success-ok-button").off("click");
					});
				} else {
					// AlertPopup("<strong>Error</strong><br>Failed to create Trade.");
					printErrorMsg(data.msg);
				}
			},
		});
	});

	$(document).on("change", "#item_image", function () {
		var id = $(this).attr("id");
		var files = document.getElementById("item_image").files[0];

		var formData = new FormData();

		formData.append("id", id);
		formData.append("image", files);

		console.log("[POST data]", formData.get("image"));

		$.ajax({
			headers: {
				"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
			},
			url: base_url + "admin/imageUpload",
			type: "POST",
			data: formData,
			contentType: false,
			processData: false,
			cache: false,
			// dataType: 'json',
			success: function (data) {
				console.log(data);
				var row = "";
				if (data.status == "success") {
					$(".img_preview").empty();

					row += '<div class="img_item" data-file="' + data.filename + '">';
					row += '<a href="#img1"><div class="thumb_img" style="background-image: url(' + base_url + data.path + ');"></div></a>';
					row +=
						'<a href="#" class="delete_img" data-id="0" data-file="' +
						data.filename +
						'" data-toggle="modal" data-target="#ConfirmDelete"><i class="fas fa-times"></i></a>';
					row += '<a href="#" class="lightbox" id="img1"><span style="background-image: url(' + base_url + data.path + ')"></span></a>';
					row += "</div>";

					$(".img_preview").append(row);
					// alert('Image Upload Successfully.');
				} else {
					printErrorMsg(data.error);
				}
				// window.location.href = window.location.href;
			},
		});
	});

	$(document).on("click", ".delete_img", function () {
		console.log("[.delete_img] Clicked");
		var filename = $(this).data("file");
		var id = $(this).data("id");
		$("#ConfirmDelete p").html("Are you sure you want to delete this image?");
		$("#ConfirmDelete .btnConfirm").data("file", filename);
		$("#ConfirmDelete").data("id", id);
		deleteImgClicked = true; // Set the flag to true
	});

	$(document).on("click", "#ConfirmDelete .btnConfirm", function () {
		$("#ConfirmDelete").modal("hide");
		$(".img_preview").empty();
		$(".custom-file-label").text("Choose image");
	});

	$(document).on("click", ".btnSaveItem", function () {
		var trade = $("#trade").val();
		var item_id = $(this).data("id");
		var item_unit = $("#item_unit").val();
		var item_name = $("input[name='item_name']").val();
		var item_desc = $("textarea[name='item_desc']").val();
		var filename = $(".img_preview .img_item").data("file");
		var file_data = $("#item_image").prop("files")[0];
		var ajax_url = "";

		if (item_id == "" || item_id == undefined) {
			ajax_url = base_url + "admin/material/item/create";
		} else {
			ajax_url = base_url + "admin/material/item/update/" + item_id;
		}

		var formData = new FormData();
		formData.append("type", "item");
		formData.append("trade", trade);
		formData.append("item_name", item_name);
		formData.append("item_desc", item_desc);
		formData.append("item_unit", item_unit);
		formData.append("filename", filename);
		formData.append("file_data", file_data);

		$.ajax({
			headers: {
				"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
			},
			url: ajax_url,
			type: "POST",
			data: formData, // Use FormData
			processData: false, // Do not process data
			contentType: false, // Do not set contentType
			success: function (data) {
				if ($.isEmptyObject(data.error)) {
					if (!deleteImgClicked) {
						SuccessPopup("<strong>Success</strong><br>Item has been Updated.");
						$("#success-ok-button").on("click", function () {
							window.location.reload(true);
						});
						$("#SuccessPopup").on("hide.bs.modal", function () {
							$("#success-ok-button").off("click");
						});
					}
					// If deleteImgClicked is true, perform the delete operation
					if (deleteImgClicked) {
						var id = $("#ConfirmDelete").data("id");
						var filename = $("#ConfirmDelete .btnConfirm").data("file");

						var formData = new FormData();
						formData.append("id", id);
						formData.append("filename", filename);
						formData.append("source", "material_item");

						$.ajax({
							headers: {
								"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
							},
							url: base_url + "admin/imageUpload/delete",
							type: "POST",
							data: formData,
							contentType: false,
							processData: false,
							success: function (data) {
								console.log(data);
								if (data.status == "success") {
									$(".img_preview").empty();
									$(".custom-file-label").text("Choose image");
									SuccessPopup("<strong>Success</strong><br>Item has been Updated.");
									$("#success-ok-button").on("click", function () {
										window.location.reload(true);
									});
									$("#SuccessPopup").on("hide.bs.modal", function () {
										$("#success-ok-button").off("click");
									});
								} else {
									printErrorMsg(data.status);
									AlertPopup("<strong>WARNING</strong><br>" + data.status);

								}
							},
						});
						deleteImgClicked = false; // reset the flag
					}
				} else {
					printErrorMsg(data.error);
				}
			},
		});
	});

	function printErrorMsg(msg) {
		$(".print-error-msg").find("ul").html("");
		$(".print-error-msg").css("display", "block");
		$.each(msg, function (key, value) {
			$(".print-error-msg")
				.find("ul")
				.append("<li>" + value + "</li>");
		});
	}

	function ListTradeTable() {
		var date = new Date();
		var month = date.getMonth() + 1;
		month = month < 10 ? "0" + month : month;
		var today = date.getFullYear() + month + date.getDay();
		var tableName = "hq_material_settings";
		var row = "";
		row += '<table id="' + tableName + '" class="table table-bordered mt-15 table_material_settings table-hover" data-category="0" style="width:100%;">';
		row += "<thead>";
		row += "<tr>";
		row += '<th style="width:5%">#</th>';
		row += '<th class="excelExport" style="width:30%">Item Name</th>';
		row += '<th class="excelExport" style="width:6%">Status</th>';
		row += '<th style="width:6%">Action</th>';
		row += "</tr>";
		row += "</thead>";
		row += "<tbody>";
		row += "</tbody>";
		row += "</table>";
		$("#ListTable").html(row);

		var formData = {
			action: "listing",
		};

		$("#hq_material_settings").DataTable({
			processing: true,
			serverSide: false,
			dom: `
             <'row'<'col-sm-12 col-md-5 text-left'f><'col-sm-12 col-md-7 text-right dataTables_pager'lB>>
             <'row'<'col-sm-12'tr>>
             <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 'p>>`,
			ajax: {
				headers: {
					"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
				},
				url: base_url + "admin/material/trade/list",
				type: "post",
				data: formData,
				error: function () {
					console.log("error");
				},
			},
			columnDefs: [
				{
					targets: [0, 2, 3],
					className: "text-center",
				},
			],
			buttons: [
				{
					text: "<i class='fa fa-download' style='vertical-align:middle;'></i> <label style='margin:5px;'>Export</label>",
					extend: "excelHtml5",
					exportOptions: {
						columns: ".excelExport",
					},
					filename: "Trade_List_" + today,
					title: "",
					className: "btn-export",
					action: function (e, dt, button, config) {
						var that = this;
						if (confirm("Do you want to export trade listing to Excel file?")) {
							console.log("COnfirm == OK");
							that.processing(true);
							that.disable();
							setTimeout(function () {
								console.log("[excelHtml5]button", button);
								$.fn.dataTable.ext.buttons.excelHtml5.action.call(that, e, dt, button, config);
							}, 500);
							that.enable();
						} else {
							console.log("Confirm == Cancel");
						}
					},
				},
			],
			columns: [
				{
					data: null,
					sortable: false,
					render: function (data, type, row, meta) {
						return meta.row + meta.settings._iDisplayStart + 1;
					},
				},
				{data: "name", name: "name"},
				{data: "status", name: "status"},
				{data: "action", name: "action"},
			],
			order: [[1, "asc"]],
		});
	}

	function ListItemTable() {
		var date = new Date();
		var month = date.getMonth() + 1;
		month = month < 10 ? "0" + month : month;
		var today = date.getFullYear() + month + date.getDay();
		var tableName = "hq_material_settings";
		var row = "";
		row += '<table id="' + tableName + '" class="table table-bordered mt-15 table_material_settings table-hover" data-category="0" style="width:100%;">';
		row += "<thead>";
		row += "<tr>";
		row += '<th style="width:5%">#</th>';
		row += '<th class="excelExport" style="width:30%">Item Description</th>';
		row += '<th class="excelExport" style="width:6%">Status</th>';
		row += '<th style="width:6%">Action</th>';
		row += "</tr>";
		row += "</thead>";
		row += "<tbody>";
		row += "</tbody>";
		row += "</table>";
		$("#ListTable").html(row);

		var formData = {
			action: "listing",
			// 'user_ID'	: user_ID
		};

		$("#hq_material_settings").DataTable({
			processing: true,
			serverSide: false,
			dom: `
             <'row'<'col-sm-12 col-md-5 text-left'f><'col-sm-12 col-md-7 text-right dataTables_pager'lB>>
             <'row'<'col-sm-12'tr>>
             <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 'p>>`,
			ajax: {
				headers: {
					"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
				},
				url: base_url + "admin/material/item/list",
				type: "post",
				data: formData,
				error: function () {
					console.log("error");
				},
			},
			columnDefs: [
				{
					targets: [0, 2, 3],
					className: "text-center",
				},
			],
			buttons: [
				{
					text: "<i class='fa fa-download' style='vertical-align:middle;'></i> <label style='margin:5px;'>Export</label>",
					extend: "excelHtml5",
					exportOptions: {
						columns: ".excelExport",
					},
					filename: "Item_List_" + today,
					title: "",
					className: "btn-export",
					action: function (e, dt, button, config) {
						var that = this;
						if (confirm("Do you want to export item listing to Excel file?")) {
							console.log("COnfirm == OK");
							that.processing(true);
							that.disable();
							setTimeout(function () {
								console.log("[excelHtml5]button", button);
								$.fn.dataTable.ext.buttons.excelHtml5.action.call(that, e, dt, button, config);
							}, 500);
							that.enable();
						} else {
							console.log("Confirm == Cancel");
						}
					},
				},
			],
			columns: [
				{
					data: null,
					sortable: false,
					render: function (data, type, row, meta) {
						return meta.row + meta.settings._iDisplayStart + 1;
					},
				},
				{data: "name", name: "name"},
				{data: "status", name: "status"},
				{data: "action", name: "action"},
			],
			order: [[1, "asc"]],
		});
	}

	// function ListCategoryTable() {
	// 	var date = new Date();
	// 	var month = date.getMonth() + 1;
	// 	month = month < 10 ? "0" + month : month;
	// 	var today = date.getFullYear() + month + date.getDay();
	// 	var tableName = "hq_material_settings";
	// 	var row = "";
	// 	row += '<table id="' + tableName + '" class="table table-bordered mt-15 table_material_settings table-hover" data-category="0" style="width:100%;">';
	// 	row += "<thead>";
	// 	row += "<tr>";
	// 	row += '<th style="width:5%">#</th>';
	// 	row += '<th class="excelExport" style="width:30%">Category Name</th>';
	// 	row += '<th class="excelExport" style="width:6%">Status</th>';
	// 	row += '<th style="width:6%">Action</th>';
	// 	row += "</tr>";
	// 	row += "</thead>";
	// 	row += "<tbody>";
	// 	row += "</tbody>";
	// 	row += "</table>";
	// 	$("#ListTable").html(row);

	// 	var formData = {
	// 		action: "listing",
	// 	};

	// 	$("#hq_material_settings").DataTable({
	// 		processing: true,
	// 		serverSide: false,
	// 		dom: `
	//         <'row'<'col-sm-12 col-md-5 text-left'f><'col-sm-12 col-md-7 text-right dataTables_pager'lB>>
	//         <'row'<'col-sm-12'tr>>
	//         <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 'p>>`,
	// 		ajax: {
	// 			headers: {
	// 				"X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
	// 			},
	// 			url: base_url + "admin/material/category/list",
	// 			type: "post",
	// 			data: formData,
	// 			error: function () {
	// 				console.log("error");
	// 			},
	// 		},
	// 		columnDefs: [
	// 			{
	// 				targets: [0, 2, 3],
	// 				className: "text-center",
	// 			},
	// 		],
	// 		buttons: [
	// 			{
	// 				text: "<i class='fa fa-download' style='vertical-align:middle;'></i> <label style='margin:5px;'>Export</label>",
	// 				extend: "excelHtml5",
	// 				exportOptions: {
	// 					columns: ".excelExport",
	// 				},
	// 				filename: "Category_List_" + today,
	// 				title: "",
	// 				className: "btn-export",
	// 				action: function (e, dt, button, config) {
	// 					var that = this;
	// 					if (confirm("Do you want to export category listing to Excel file?")) {
	// 						console.log("COnfirm == OK");
	// 						that.processing(true);
	// 						that.disable();
	// 						setTimeout(function () {
	// 							console.log("[excelHtml5]button", button);
	// 							$.fn.dataTable.ext.buttons.excelHtml5.action.call(that, e, dt, button, config);
	// 						}, 500);
	// 						that.enable();
	// 					} else {
	// 						console.log("Confirm == Cancel");
	// 					}
	// 				},
	// 			},
	// 		],
	// 		columns: [
	// 			{
	// 				data: null,
	// 				sortable: false,
	// 				render: function (data, type, row, meta) {
	// 					return meta.row + meta.settings._iDisplayStart + 1;
	// 				},
	// 			},
	// 			{data: "name", name: "name"},
	// 			{data: "status", name: "status"},
	// 			{data: "action", name: "action"},
	// 		],
	// 		order: [[1, "asc"]],
	// 	});
	// } done unuse
});
