<?php

$uri = service('uri');
$page = $uri->getSegment(4);
$title = "Create";
$residential_id = $uri->getSegment(3);
if ($page == "edit")
{
    $title = "Edit";
} ?>

<?= $this->extend('layouts/app.php') ?>
<?= $this->section('content') ?>

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <h4>PO Details</h4>
                    <form id="PoDetail" data-po-id="">
                        <div class="form-group row">
                           
                        <div class="col-sm-6">
								<label class="col-form-label text-right mr-5">PO#:</label>
								<input id="po_no" type="text" class="form-control" placeholder="Fill in PO#" />
							</div>

                                <div class="col-sm-6">
                                    <div class="col-sm-12">
                                        <label class="col-form-label text-right mr-5">PO Date:</label>
                                        <input type="text" class="form-control datepicker" id="kt_datepicker_4_3"
                                            data-date-format="dd-mm-yyyy" placeholder="Select PO Date" />
                                    </div>
                                </div>

                        </div>
                        <div class="form-group row">
                            <div class="col-sm-6">
                                <label class="col-form-label text-right mr-5">Select Vendor:</label>
                                <select id="SelectVendor" class="form-control selectpicker" data-live-search="true"
                                    data-size="3">
                                    <option disabled selected>Vendor Company</option>
                                    <?php foreach ($vendors as $vendor): ?>
                                        <option data-tokens="<?= $vendor->company_name; ?>" value="<?= $vendor->id; ?>"><?= $vendor->company_name; ?> (<?= $vendor->company_no; ?>)</option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-sm-6">
                                <div class="col-sm-12">
                                    <label class="col-form-label text-right mr-5">Upload PO file:</label>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="po_file" />
                                        <label class="custom-file-label" for="po_file">Choose file</label>
                                    </div>
                                    <div class="file_preview mt-5"></div>
                                    <div class="doc_preview"></div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <hr>
            <div class="d-flex align-items-stretch justify-content-between mb-2">
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap mr-15 title">
                    <?php if ($page == "edit"): ?>
                        <label style="font-size:20px; font-weight:400;">RF No: &nbsp;&nbsp;<a class="modal-links rf_no"
                                data-toggle="modal" data-target="#requisition_form" data-id=""></a></label>
                    <?php endif; ?>
                </div>

                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
                    <a href="#" class="btn btn-primary font-weight-bolder btnAddNew" data-toggle="modal"
                        data-target="#add_newPOItem"><i class="la la-plus"></i>Add</a>
                </div>
            </div>
            <div id="kt_repeater_2" data-rf-id="" data-rf-no="">
                <div class="form-group row mb-0">
                    <div class="col-sm-12">
                        <table class="table table-bordered table_rf_new_item new">
                            <tr>
                                <th style="width:5%;">#</th>
                                <th style="width:41%;">Item Name & Description</th>
                                <th style="width:9%;">Unit</th>
                                <th style="width:10%;">Qty</th>
                                <th style="width:30%;">Remarks </th>
                                <th style="width:5%;">Action</th>
                            </tr>
                            <tbody>

                            </tbody>

                        </table>
                    </div>
                </div>

            </div>


            <hr>
            <div class="row">
                <div class="col-sm-12">
                    <p class="mb-0">Notes:</p>
                    <ol class="notes-list">
                        <li>Request forms done by site clerical personnel will be needed project manager's approval.
                        </li>
                        <li>Request forms done by project manager will be auto-approved and sent to HQ.</li>
                    </ol>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12 text-center">
                    <a href="#" class="btn btn-primary font-weight-bolder btnProceed">Proceed</a>
                </div>
            </div>

        </div>

    </div>
</div>
<!-- Modal PO Details Update -->
<div class="modal fade" id="add_newPOItem" tabindex="-1" role="dialog" aria-labelledby="add_newPOItem"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add PO Item</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i aria-hidden="true" class="ki ki-close"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <div id="ListSearch"></div>
                        <div id="ListItem" data-rf-id="" data-rf-no=""></div>
                    </div>
                </div>

            </div>
            <div class="modal-footer d-flex align-items-stretch justify-content-between">
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap mr-15">
                    <button type="button" class="btn btn-primary font-weight-bold btnBack">Back</button>
                </div>
                <div class="d-flex align-items-center justify-content-between flex-wrap flex-sm-nowrap">
                    <button type="button" class="btn btn-primary font-weight-bold mr-3 btnConfirm">Add</button>
                    <button type="button" class="btn btn-light-primary font-weight-bold"
                        data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal RF -->
<div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-5">
                        <h1>Requisition Form</h1>
                        <h5 class="rf_no"></h5>
                    </div>
                    <div class="col-sm-7">
                        <div class="address-box text-right">
                            Arte Cheras,<br>
                            No.2, Jalan Midah 2,<br>
                            Taman Midah, Cheras,<br>
                            56000 Kuala Lumpur<br>
                            Tel: +6012-123 4567
                        </div>
                        <div class="logo-box">
                            <div class="logo-rf"
                                style="background-image: url('{{ asset('/images/logo/arte-cheras.png') }}');"></div>
                        </div>
                    </div>
                </div>

                <hr class="mt-5 mb-5">

                <div class="row">
                    <div class="col-sm-6">
                        <div class="to-info"></div>
                    </div>
                    <div class="col-sm-6">
                        <div class="request-info">

                        </div>
                    </div>

                    <div class="col-sm-12">
                        <table class="table table-bordered table-rf mt-5">
                        </table>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
<?= $this->section('custom_js') ?>

<script src="<?= base_url('js/po.js') ?>"></script>
<script src="<?= base_url('js/pages/crud/forms/widgets/form-repeater.js') ?>"></script>
<script src="<?= base_url('js/pages/crud/forms/widgets/bootstrap-datepicker.js') ?>"></script>
<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
    var residential_id = "<?php echo $residential_id ?>";

</script>
<?= $this->endSection() ?>