<?= $this->extend('layouts/app.php') ?>
<?= $this->section('content') ?>
<?php $residential_id = service('request')->uri->getSegment(3);

foreach ($residential as $res)
{
    if ($res['id'] == $residential_id)
    {
        $logo_img = $res['logo'];
    }
}
?>

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div id="total_requisition" class="d-flex justify-content-center"></div>
                </div>
            </div>

            <hr class="mt-15 mb-15">

            <div class="row">
                <div class="col-sm-12" id="rflistTabContent">
                </div>
            </div>

                  <!-- Modal RF -->
                  <div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-5">
                                    <h1>Requisition Form</h1>
                                    <h5 class="rf_no"></h5>
                                </div>
                                <div class="col-sm-7" style="text-align: end !important; ">
                                    <div class="address-box text-right">
                        
                                    </div>
                                    <div class="logo-box">
                                        <div class="logo-rf"
                                            style="background-image: url('<?=base_url('media/' . $logo_img) ; ?>');">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-5 mb-5">

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="to-info"></div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="request-info">
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <table class="table table-bordered table-rf mt-5">
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <?php if (in_array('PM', $role_category)): ?>
                                <button type="button" class="btn btn-success font-weight-bold btnApproveRf" data-rf-id=""
                                    data-action="approve" data-no="">Approve RF</button>
                                <button type="button" class="btn btn-danger font-weight-bold btnRejectRf" data-rf-id=""
                                    data-action="reject" data-no="">Reject RF</button>
                            <?php endif; ?>
                            <button type="button" class="btn btn-light-primary font-weight-bold"
                                data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<?= $this->endSection() ?>
<?= $this->section('custom_js') ?>
<script>
        var KTApexChartsDemo = function () {

            var _total_requisition = function () {
                const apexChart = "#total_requisition";
                var options = {
                    series: [{
                        name: 'Pending',
                        data: [619, 828, 539, 589, 427, 206, 624, 449, 301, 388]
                    }, {
                        name: 'PO',
                        data: [4899, 3591, 3946, 2381, 2653, 2405, 1864, 1983, 1274, 925]
                    }, {
                        name: 'DO',
                        data: [832, 957, 558, 248, 363, 673, 559, 341, 488, 345]
                    }, {
                        name: 'Rejected',
                        data: [384, 449, 204, 347, 146, 103, 216, 145, 56, 123]
                    }],
                    chart: {
                        type: 'bar',
                        height: 450,
                        stacked: true,
                        toolbar: {
                            tools: {
                                download: false
                            }
                        },
                    },
                    title: {
                        text: 'Total Requisition',
                        align: 'center',
                        style: {
                            fontSize:  '16px',
                            fontWeight:  'bold',
                            color:  '#000'
                        },
                    },
                    responsive: [{
                        breakpoint: 480,

                        options: {
                            title: {
                                style: {
                                    fontSize: '14px',
                                },
                            },
                            chart: {
                                height: 500,
                            },
                            legend: {
                                position: 'bottom'
                            },
                            xaxis: {
                                type: 'text',
                                categories: [
                                    ['Item 2', '(Nos)'],
                                    ['Item 5', '(M2)'],
                                    ['Item 9', '(M3)'],
                                    ['Item 6', '(Nos)'],
                                    ['Item 1', '(Kg)'],
                                    ['Item 10', '(Nos)'],
                                    ['Item 8', '(Kg)'],
                                    ['Item 4', '(M3)'],
                                    ['Item 3', '(Kg)'],
                                    ['Item 7', '(Kg)'],
                                ],
                                tickAmount: 6,
                            },
                        }
                    }],
                    plotOptions: {
                        bar: {
                            borderRadius: 8,
                            horizontal: true,
                        },
                    },
                    xaxis: {
                        type: 'text',
                        categories: ['Item 2 (Nos)', 'Item 5 (M2)', 'Item 9 (M3)', 'Item 6 (Nos)', 'Item 1 (Kg)', 'Item 10 (Nos)', 'Item 8 (Kg)', 'Item 4 (M3)', 'Item 3 (Kg)', 'Item 7 (Kg)'],
                        tickAmount: 6,
                    },
                    dataLabels: {
                        enabled: true,
                        style: {
                            fontSize: '10px',
                        },
                    },
                    legend: {
                        position: 'bottom',
                        formatter: function (seriesName, opts) {
                            return [seriesName, " - ", opts.w.globals.seriesTotals[opts.seriesIndex]]
                        }
                    },
                    fill: {
                        opacity: 1
                    },
                    colors: ['#87c5fe', '#f4ca80', '#75cf8c', '#bbbfc2'],
                    grid: {
                        xaxis: {
                            lines: {
                                show: true
                            }
                        },
                        yaxis: {
                            lines: {
                                show: false
                            }
                        }
                    },
                    states: {
                        normal: {
                            filter: {
                                type: 'none',
                                value: 0,
                            }
                        },
                        hover: {
                            filter: {
                                type: 'darken',
                                value: 0.15,
                            }
                        },
                        active: {
                            allowMultipleDataPointsSelection: false,
                            filter: {
                                type: 'darken',
                                value: 0.35,
                            }
                        },
                    }
                };

                var chart = new ApexCharts(document.querySelector(apexChart), options);
                chart.render();
            }

            return {
                // public functions
                init: function () {
                    _total_requisition();
                }
            };
        }();
    </script>

<script src="<?= base_url('js/overview.js'); ?>"></script>
<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
</script>

<?= $this->endSection() ?>