<?= $this->extend('layouts/app.php') ?>
<?= $this->section('content') ?>

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">    
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="alert alert-danger print-error-msg" style="display:none">
                <ul></ul>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <form id="form_category">                       
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Parent Category :</label>
                            <div class="col-lg-9">
                                <select name="parent_cat" class="form-control selectpicker" multiple data-live-search="true" data-size="4">
                                    <option data-tokens="-">-</option>                                
                                <?php foreach ($categories as $category): ?>
                                    <option data-tokens="<?= $category->id ?>" <?= $category->id == $category_details->cat_id ? 'selected' : '' ?> ><?= $category->name ?></option>
                                <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                         <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Category Name :</label>
                            <div class="col-lg-9">
                                <input class="form-control" type="text" name="category_name" value="<?= $category_details->name ?>" />
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-lg-2 col-form-label text-right">Category Description :</label>
                            <div class="col-lg-9">
                                <textarea class="form-control" type="text" rows="4" name="category_desc" ></textarea>
                            </div>
                        </div>                       
                    </form>
                    
                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <a href="#" class="btn btn-primary font-weight-bolder btnSaveCategory">Save</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

			
<?= $this->endSection() ?>
<?= $this->section('custom_js') ?>
<script src="<?= base_url('js/material.js'); ?>"></script>
<script type="text/javascript">
    var base_url = "<?php echo base_url(); ?>";
</script>
<?= $this->endSection() ?>