<?= form_open($action); ?>

<div class="mb-3">
    <label for="name" class="form-label">Name</label>
    <input name="name" type="text" class="form-control <?= (isset($validation) && $validation->hasError('name')) ? 'is-invalid' : '' ?>" id="name" aria-describedby="name" value="<?= old('name', isset($user) ? $user->name : '') ?>">
    <?php if (isset($validation) && $validation->hasError('name')): ?>
        <span class="invalid-feedback" role="alert"><?= $validation->getError('name') ?></span>
    <?php endif; ?>
</div>

<div class="mb-3">
    <label for="email" class="form-label">Email address</label>
    <input name="email" type="email" class="form-control <?= (isset($validation) && $validation->hasError('email')) ? 'is-invalid' : '' ?>" id="email" aria-describedby="email" value="<?= old('email', isset($user) ? $user->email : '') ?>">
    <?php if (isset($validation) && $validation->hasError('email')): ?>
        <span class="invalid-feedback" role="alert"><?= $validation->getError('email') ?></span>
    <?php endif; ?>
</div>

<div class="mb-3">
    <?php foreach ($roles as $role): ?>
        <div class="form-check">
            <input class="form-check-input" name="roles[]" type="checkbox" value="<?= $role->id ?>" id="<?= $role->name ?>" <?php if (isset($user) && in_array($role->id, array_column($user->roles, 'id'))): ?>checked<?php endif; ?>>
            <label class="form-check-label" for="<?= $role->name ?>"><?= $role->name ?></label>
        </div>
    <?php endforeach; ?>
</div>

<!-- create  -->
<?php if (isset($create)): ?>
    <div class="mb-3">
        <label for="password" class="form-label">Password</label>
        <input name="password" type="password" class="form-control <?= (isset($validation) && $validation->hasError('password')) ? 'is-invalid' : '' ?>" id="password">
        <?php if (isset($validation) && $validation->hasError('password')): ?>
            <span class="invalid-feedback" role="alert"><?= $validation->getError('password') ?></span>
        <?php endif; ?>
    </div> 

    <div class="mb-3">
        <label for="password_confirmation" class="form-label">Confirm Password</label>
        <input name="password_confirmation" type="password" class="form-control <?= (isset($validation) && $validation->hasError('password_confirmation')) ? 'is-invalid' : '' ?>" id="password_confirmation">
        <?php if (isset($validation) && $validation->hasError('password_confirmation')): ?>
            <span class="invalid-feedback" role="alert"><?= $validation->getError('password_confirmation') ?></span>
        <?php endif; ?>
    </div>   
<?php endif; ?>

<button type="submit" class="btn btn-primary">Submit</button>

<?= form_close(); ?>