<?= $this->extend('layouts/app.php') ?>

<?= $this->section('content') ?>
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
    <div class="d-flex flex-column-fluid pb-20">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="pageTitle">
                        <h4>Total Items Requisition of All Projects</h4>
                    </div>
                    <div class="row select_status status1">
                        <div class="col-lg-12">
                            <div id="item_requisition_status_all" class="d-flex justify-content-center mt-5"></div>
                        </div>
                    </div>
                </div>
            </div>

            <hr class="mt-15 mb-15">

            <div class="row">
                <div class="col-sm-12">
                    <ul class="nav nav-pills basic-tabs" id="dashboardTab">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#rf">
                                <span class="nav-text">RF</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#po">
                                <span class="nav-text">PO</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#do">
                                <span class="nav-text">DO</span>
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content dashboard_tab mt-5" id="dashboardTabContent">
                        <div class="tab-pane fade show active" id="rf" role="tabpanel" aria-labelledby="rf">
                            <!-- Datatable (JS in datatable-custom.js) -->
                            <table class="table table-bordered mt-15 table_dashhqrf table-hover" id="dashboard_hq_rf">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>RF#</th>
                                        <th>RF Date</th>
                                        <th>Requeted by</th>
                                        <th>Contact</th>
                                        <th>PO Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Arte Cheras</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC28082021001</a></td>
                                        <td>28/08/2021</td>
                                        <td>Janet Tan</td>
                                        <td>017-330 5149</td>
                                        <td>Inc 2/3</td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Edumetro</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-ED25082021002</a></td>
                                        <td>25/08/2021</td>
                                        <td>Siti Hassan</td>
                                        <td>012-337 8899</td>
                                        <td>Cmp 2/2</td>
                                        <td></td>
                                    </tr>
                                 
                                </tbody>
                            </table>
                        </div>
                
                        <div class="tab-pane fade" id="po" role="tabpanel" aria-labelledby="po">
                            <!-- Datatable (JS in datatable-custom.js) -->
                            <table class="table table-bordered table-hover mt-15 table_dashhqpo" id="dashboard_hq_po">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>PO#</th>
                                        <th>Item Desc</th>
                                        <th>Qty</th>
                                        <th>Unit</th>
                                        <th>Vendor</th>
                                        <th>RF#</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/po-sample.pdf" target="_blank">PO-10092021001</a></td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>58</td>
                                        <td>M3</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/po-sample.pdf" target="_blank">PO-10092021001</a></td>
                                        <td>Item 1 asda asd sd asd</td>
                                        <td>79</td>
                                        <td>Nos</td>
                                        <td>ABC Sdn Bhd</td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021002</a></td>
                                    </tr>
                                 
                                </tbody>
                            </table>
                        </div>
                
                        <div class="tab-pane fade" id="do" role="tabpanel" aria-labelledby="do">
                            <!-- Datatable (JS in datatable-custom.js) -->
                            <table class="table table-bordered table-hover mt-15 table_dashhqdo" id="dashboard_hq_do">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Project</th>
                                        <th>DO#</th>
                                        <th>Item Desc</th>
                                        <th>Qty</th>
                                        <th>Unit</th>
                                        <th>Vendor</th>
                                        <th>PO#</th>
                                        <th>RF#</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>125</td>
                                        <td>Kg</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a href="assets/document/po-sample.pdf" target="_blank">PO-04092021001</a></td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a href="assets/document/po-sample.pdf" target="_blank">PO-04092021001</a></td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>3</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a href="assets/document/po-sample.pdf" target="_blank">PO-04092021001</a></td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                    <tr>
                                        <td>4</td>
                                        <td>Arte Cheras</td>
                                        <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                        <td>Item 25 asda asd sd asd</td>
                                        <td>39</td>
                                        <td>Nos</td>
                                        <td>KKK Sdn Bhd</td>
                                        <td><a href="assets/document/po-sample.pdf" target="_blank">PO-04092021001</a></td>
                                        <td><a class="modal-links" data-toggle="modal" data-target="#requisition_form">RF-AC10092021001</a></td>
                                        <td class="modal-links" data-toggle="modal" data-target="#received_details">Received</td>
                                    </tr>
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal RF -->
            <div class="modal fade" id="requisition_form" tabindex="-1" role="dialog" aria-labelledby="requisition_form" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h1>Requisition Form</h1>
                                    <h5>RF#: RF-AC28082021001</h5>
                                </div>
                                <div class="col-sm-6">
                                    <div class="address-box text-right">
                                        Arte Cheras,<br>
                                        No.2, Jalan Midah 2,<br>
                                        Taman Midah, Cheras,<br>
                                        56000 Kuala Lumpur<br>
                                        Tel: +6012-123 4567												
                                    </div>
                                    <div class="logo-box">
                                        <div class="logo-rf" style="background-image: url('assets/media/arte-cheras.png');"></div>
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-5 mb-5">

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="to-info">
                                        <strong>To:</strong><br>
                                        Headquarters<br>
                                        No.1, Jalan Wangsa Permai, 2nd Floor,<br>
                                        Bangunan One Wangsa, Taman Wangsa Permai,<br>
                                        Tel: +603-6277 2480<br>
                                        Fax: +603-6276 2482
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="request-info">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td>Request Date :</td>
                                                <td>28/08/2021</td>
                                            </tr>
                                            <tr>
                                                <td>Requested by :</td>
                                                <td>Janet Tan</td>
                                            </tr>
                                            <tr>
                                                <td>Contact # :</td>
                                                <td>017-330 5149</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <table class="table table-bordered table-rf mt-5">
                                        <tr>
                                            <th>#</th>
                                            <th>Item Description</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>Date Required</th>
                                            <th>Remarks</th>
                                        </tr>
                                        <tr>
                                            <td>1</td>
                                            <td>Item 1</td>
                                            <td>Nos</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>Item 2</td>
                                            <td>Kg</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1. This is some description for item 1</td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>Item 3</td>
                                            <td>M3</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>This is some description for item 1</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Received Item Details -->
            <div class="modal fade" id="received_details" tabindex="-1" role="dialog" aria-labelledby="received_details" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Received Item Details</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <i aria-hidden="true" class="ki ki-close"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="accordion accordion-toggle-arrow" id="receivedItemAcc">
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="card-title collapsed" data-toggle="collapse" data-target="#receivedItemAcc1">
                                                    <span class="recv_date">Received Date: 29/09/2021</span><span class="recv_qty">Received Qty: 34Kg</span>
                                                </div>
                                            </div>
                                            <div id="receivedItemAcc1" class="collapse" data-parent="#receivedItemAcc">
                                                <div class="card-body">
                                                    <table class="table table-bordered table-receivedDetails mb-10">
                                                        <tr>
                                                            <th>#</th>
                                                            <th>DO#</th>
                                                            <th>Vendor</th>
                                                            <th>Item Description</th>
                                                            <th>Qty</th>
                                                            <th>Unit</th>
                                                            <th>PO#</th>
                                                            <th>Received</th>
                                                        </tr>
                                                        <tr>
                                                            <td>1</td>
                                                            <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                                            <td>ABC Sdn Bhd</td>
                                                            <td>Item 1 description asdad asd as asd ad	</td>
                                                            <td>128</td>
                                                            <td>Nos</td>
                                                            <td>PO-04092021001</td>
                                                            <td>05/09/2021</td>
                                                        </tr>
                                                    </table>

                                                    <ul class="nav nav-pills basic-tabs" id="received_details_Tab">
                                                        <li class="nav-item">
                                                            <a class="nav-link active" data-toggle="tab" href="#stocks">
                                                                <span class="nav-text"><i class="fas fa-cubes"></i>Stocks</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-toggle="tab" href="#vehicle">
                                                                <span class="nav-text"><i class="fas fa-truck"></i>Vehicle</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-toggle="tab" href="#driver">
                                                                <span class="nav-text"><i class="fas fa-user"></i>Driver</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-toggle="tab" href="#document">
                                                                <span class="nav-text"><i class="far fa-file-alt"></i>Document</span>
                                                            </a>
                                                        </li>
                                                    </ul>

                                                    <div class="tab-content received_details_Tab mt-5" id="received_detailsTabContent">
                                                        <div class="tab-pane fade show active" id="stocks" role="tabpanel" aria-labelledby="stocks">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img1">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/stock.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img1">
                                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img2">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/stock.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img2">
                                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img3">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/stock.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img3">
                                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="tab-pane fade" id="vehicle" role="tabpanel" aria-labelledby="vehicle">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img4">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img4">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img5">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img5">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img6">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img6">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img7">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img7">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img8">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img8">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="tab-pane fade" id="driver" role="tabpanel" aria-labelledby="driver">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img9">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/driver.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img9">
                                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img10">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/driver.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img10">
                                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img11">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/driver.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img11">
                                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="tab-pane fade" id="document" role="tabpanel" aria-labelledby="document">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img12">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/document.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img12">
                                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img13">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/document.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img13">
                                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img14">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/document.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img14">
                                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="card">
                                            <div class="card-header">
                                                <div class="card-title collapsed" data-toggle="collapse" data-target="#receivedItemAcc2">
                                                    <span class="recv_date">Received Date: 11/09/2021</span><span class="recv_qty">Received Qty: 60Kg</span>
                                                </div>
                                            </div>
                                            <div id="receivedItemAcc2" class="collapse" data-parent="#receivedItemAcc">
                                                <div class="card-body">
                                                    <table class="table table-bordered table-receivedDetails mb-10">
                                                        <tr>
                                                            <th>#</th>
                                                            <th>DO#</th>
                                                            <th>Vendor</th>
                                                            <th>Item Description</th>
                                                            <th>Qty</th>
                                                            <th>Unit</th>
                                                            <th>PO#</th>
                                                            <th>Status</th>
                                                        </tr>
                                                        <tr>
                                                            <td>1</td>
                                                            <td><a href="assets/document/do-sample.pdf" target="_blank">DO-10092021A</a></td>
                                                            <td>ABC Sdn Bhd</td>
                                                            <td>Item 1 description asdad asd as asd ad	</td>
                                                            <td>128</td>
                                                            <td>Nos</td>
                                                            <td>PO-04092021001</td>
                                                            <td>05/09/2021</td>
                                                        </tr>
                                                    </table>

                                                    <ul class="nav nav-pills basic-tabs" id="received_details_Tab1">
                                                        <li class="nav-item">
                                                            <a class="nav-link active" data-toggle="tab" href="#stocks1">
                                                                <span class="nav-text"><i class="fas fa-cubes"></i>Stocks</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-toggle="tab" href="#vehicle1">
                                                                <span class="nav-text"><i class="fas fa-truck"></i>Vehicle</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-toggle="tab" href="#driver1">
                                                                <span class="nav-text"><i class="fas fa-user"></i>Driver</span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-toggle="tab" href="#document1">
                                                                <span class="nav-text"><i class="far fa-file-alt"></i>Document</span>
                                                            </a>
                                                        </li>
                                                    </ul>

                                                    <div class="tab-content received_details_Tab mt-5" id="received_detailsTabContent1">
                                                        <div class="tab-pane fade show active" id="stocks1" role="tabpanel" aria-labelledby="stocks1">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img1">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/stock.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img1">
                                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img2">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/stock.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img2">
                                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img3">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/stock.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img3">
                                                                        <span style="background-image: url('assets/media/stock.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="tab-pane fade" id="vehicle1" role="tabpanel" aria-labelledby="vehicle1">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img4">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img4">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img5">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img5">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img6">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img6">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img7">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img7">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img8">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/vehicle.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img8">
                                                                        <span style="background-image: url('assets/media/vehicle.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="tab-pane fade" id="driver1" role="tabpanel" aria-labelledby="driver1">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img9">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/driver.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img9">
                                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img10">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/driver.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img10">
                                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img11">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/driver.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img11">
                                                                        <span style="background-image: url('assets/media/driver.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="tab-pane fade" id="document1" role="tabpanel" aria-labelledby="document1">
                                                            <ul class="info_img_list">
                                                                <li>
                                                                    <a href="#img12">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/document.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img12">
                                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img13">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/document.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img13">
                                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                                <li>
                                                                    <a href="#img14">
                                                                        <div class="info_img_bg"
                                                                            style="background-image: url(assets/media/document.jpg);">
                                                                        </div>
                                                                    </a>
                                                                    <a href="#" class="lightbox" id="img14">
                                                                        <span style="background-image: url('assets/media/document.jpg')"></span>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal RF with PO status -->
            <div class="modal fade" id="requisition_form_status_po" tabindex="-1" role="dialog" aria-labelledby="requisition_form_status_po" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h1>Requisition Form</h1>
                                    <h5>RF#: RF-AC28082021001</h5>
                                </div>
                                <div class="col-sm-6">
                                    <div class="address-box text-right">
                                        Arte Cheras,<br>
                                        No.2, Jalan Midah 2,<br>
                                        Taman Midah, Cheras,<br>
                                        56000 Kuala Lumpur<br>
                                        Tel: +6012-123 4567												
                                    </div>
                                    <div class="logo-box">
                                        <div class="logo-rf" style="background-image: url('assets/media/arte-cheras.png');"></div>
                                    </div>
                                </div>
                            </div>

                            <hr class="mt-5 mb-5">

                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="to-info">
                                        <strong>To:</strong><br>
                                        Headquarters<br>
                                        No.1, Jalan Wangsa Permai, 2nd Floor,<br>
                                        Bangunan One Wangsa, Taman Wangsa Permai,<br>
                                        Tel: +603-6277 2480<br>
                                        Fax: +603-6276 2482
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="request-info">
                                        <table class="table table-borderless">
                                            <tr>
                                                <td>Request Date :</td>
                                                <td>28/08/2021</td>
                                            </tr>
                                            <tr>
                                                <td>Requested by :</td>
                                                <td>Janet Tan</td>
                                            </tr>
                                            <tr>
                                                <td>Contact # :</td>
                                                <td>017-330 5149</td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <table class="table table-bordered table-rf-statusPO mt-5">
                                        <tr>
                                            <th>#</th>
                                            <th>Item Description</th>
                                            <th>Unit</th>
                                            <th>Qty</th>
                                            <th>Date Required</th>
                                            <th>PO#</th>
                                        </tr>
                                        <tr>
                                            <td>1</td>
                                            <td>Item 1</td>
                                            <td>Nos</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td><a href="assets/document/po-sample.pdf" target="_blank">PO123456</a></td>
                                        </tr>
                                        <tr>
                                            <td>2</td>
                                            <td>Item 2</td>
                                            <td>Kg</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td><a href="assets/document/po-sample.pdf" target="_blank">PO123456</a></td>
                                        </tr>
                                        <tr>
                                            <td>3</td>
                                            <td>Item 3</td>
                                            <td>M3</td>
                                            <td>128</td>
                                            <td>05/10/2021</td>
                                            <td>Pending</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light-primary font-weight-bold" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?= $this->endSection() ?>
<?= $this->section('custom_js') ?>
	<script>
		var KTApexChartsDemo = function () {

			var _item_requisition_status_all = function () {
				const apexChart = "#item_requisition_status_all";
				var options = {
					series: [{
						name: 'Pending',
						data: [82, 61, 53, 20, 62, 42, 58, 30, 44, 38]
					}, {
						name: 'PO',
						data: [158, 186, 142, 120, 79, 116, 103, 88, 91, 38]
					}, {
						name: 'DO',
						data: [95, 83, 55, 67, 55, 36, 24, 48, 34, 34]
					}, {
						name: 'Rejected',
						data: [28, 31, 20, 10, 21, 14, 16, 18, 14, 12]
					}],
					chart: {
						type: 'bar',
						height: 450,
						stacked: true,
						toolbar: {
							tools: {
								download: false
							}
						},
					},
					title: {
						text: 'Item Requisition Status of All Projects',
						align: 'center',
						style: {
							fontSize:  '16px',
							fontWeight:  'bold',
							color:  '#000'
						},
					},
					responsive: [{
						breakpoint: 480,

						options: {
							title: {
								style: {
									fontSize: '14px',
								},
							},
							chart: {
								height: 500,
							},
							legend: {
								position: 'bottom'
							},
							xaxis: {
								type: 'text',
								categories: [
									['Edumetro'],
									['Arte Cheras'],
									['Megahrise'],
									['Edusphere'],
									['Vertu'],
									['Lucentia'],
									['Apple99'],
									['Bon Estate'],
									['Bloomsvale'],
									['Conlay'],
								],
								tickAmount: 6,
							},
						}
					}],
					plotOptions: {
						bar: {
							borderRadius: 8,
							horizontal: true,
						},
					},
					xaxis: {
						type: 'text',
						categories: ['Edumetro', 'Arte Cheras', 'Megahrise', 'Edusphere', 'Vertu', 'Lucentia', 'Apple99', 'Bon Estate', 'Bloomsvale', 'Conlay'],
						tickAmount: 6,
					},
					dataLabels: {
						enabled: true,
						style: {
							fontSize: '10px',
						},
					},
					legend: {
						position: 'bottom',
						formatter: function (seriesName, opts) {
							return [seriesName, " - ", opts.w.globals.seriesTotals[opts.seriesIndex]]
						}
					},
					fill: {
						opacity: 1
					},
					colors: ['#87c5fe', '#f4ca80', '#75cf8c', '#bbbfc2'],
					grid: {
						xaxis: {
							lines: {
								show: true
							}
						},
						yaxis: {
							lines: {
								show: false
							}
						}
					},
					states: {
						normal: {
							filter: {
								type: 'none',
								value: 0,
							}
						},
						hover: {
							filter: {
								type: 'darken',
								value: 0.15,
							}
						},
						active: {
							allowMultipleDataPointsSelection: false,
							filter: {
								type: 'darken',
								value: 0.35,
							}
						},
					}
				};

				var chart = new ApexCharts(document.querySelector(apexChart), options);
				chart.render();
			}

			return {
				// public functions
				init: function () {
					_item_requisition_status_all();
				}
			};
		}();
	</script>
<?= $this->endSection() ?>