<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $returnType = 'array';

    protected $allowedFields = ['name', 'email', 'tel', 'status', 'password', 'created_by', 'created_at', 'updated_by', 'updated_at', 'role_id', 'vendor_id', 'project_id'];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // protected $validationRules    = [];
    // protected $validationMessages = [];
    // protected $skipValidation     = false;

    public function findUserByEmail($email)
    {
        return $this->asArray()->where(['email' => $email])->first();
    }

    public function getResidential($userId)
    {
        // Get the project IDs for the specified user ID
        $user = $this->where('id', $userId)->first();
        $projectIds = explode(',', $user['project_id']); 
        $db      = \Config\Database::connect();
        $builder = $db->table('residential');
        $builder->whereIn('id', $projectIds);
        $builder->orderBy('name', 'ASC');
        $residentialData = $builder->get()->getResultArray();

        return $residentialData;
    }


    public function getCurrentResidential($residential_id)
    {
        // $residential_id =  service('request')->uri->getSegment(3);
        $db      = \Config\Database::connect();
        $builder = $db->table('residential');
        $builder->where('id', $residential_id);
        $builder->orderBy('name', 'ASC');
        $residentialData = $builder->get()->getRow();

        return $residentialData;
    }

    public function getCurrentUser($user_id)
    {
    
        $db      = \Config\Database::connect();
        $builder = $db->table('users');
        $builder->where('id', $user_id);
        $builder->orderBy('name', 'ASC');
        $userData = $builder->get()->getRow();

        return $userData;
    }

    public function getRoleName($role_id)
    {
        $db = \Config\Database::connect();
        $builder = $db->table('roles');
        $builder->select('name');
        $builder->where('id', $role_id);
        $roleName = $builder->get()->getRow();
        if ($roleName) {
            return $roleName->name;
        } else {
            return null;
        }
    }
}
