<?php

namespace App\Models;

use CodeIgniter\Model;

class MaterialModel extends Model

{
    protected $table = 'material';

    public function getMaterial($type, $company_id) {
        $builder = $this->db->table($type);
        $query = $builder->where('company_id', $company_id)
                         ->orderBy('name')
                         ->get();

        return $query->getResult();
    }

    public function getTrades($company_id) {
        $builder = $this->db->table('trade');
        $query = $builder->where('company_id', $company_id)
                         ->get();

        return $query->getResult();
    }

    public function getMeasurements() {
        $builder = $this->db->table('measurement');
        $query = $builder->get();

        return $query->getResult();
    }

    public function getCategories($company_id) {
        $builder = $this->db->table('category');
        $query = $builder->where('company_id', $company_id)
                         ->orderBy('name', 'ASC')
                         ->get();

        return $query->getResult();
    }
}
