<?php
namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class RoleFilters implements FilterInterface
{

    public function before(RequestInterface $request, $arguments = null)
    {
        if (empty($arguments))
        {
            return;
        }



        if (!function_exists('hasAnyRoles')) {
            function hasAnyRoles($userRoles, array $roles)
            {
                if (!is_array($userRoles)) {
                    $userRoles = [$userRoles];
                }
                return !empty(array_intersect($userRoles, $roles));
            }
        }



        $originalRole = session()->get('role_id');
        $userRoles = [];

        if (hasAnyRoles($originalRole, [1, 3, 6]))
        {
            $userRoles[] = 'Admin';
        }
        if (hasAnyRoles($originalRole, [5]))
        {
            $userRoles[] = 'Vendor';
        }
        if (hasAnyRoles($originalRole, [2]))
        {
            $userRoles[] = 'Site';
        }
        if (hasAnyRoles($originalRole, [3]))
        {
            $userRoles[] = 'HQ';
        }
        if (hasAnyRoles($originalRole, [6]))
        {
            $userRoles[] = 'Director';
        }
        if (hasAnyRoles($originalRole, [1]))
        {
            $userRoles[] = 'PM';
        }
        if (hasAnyRoles($originalRole, [4]))
        {
            $userRoles[] = 'SO';
        }


        $ses_data = [
            'role_category' => $userRoles,
        ];

        session()->set($ses_data);

        if (!hasAnyRoles($userRoles, $arguments))
        {
         //  throw new \Exception('No permission, Access Denied');
            return redirect()->to('/login');
            
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
    }
}