<?php

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\Config\Services;

class VendorController extends BaseController
{

    public function index()
    {
        $this->enforceLogin();
        $dashboard_url = "vendor/dashboard";
        $role = session()->get('role');
        $name = session()->get('name');
        $userId = session()->get('id');
        $role_category = session()->get('role_category');

        $userModel = new \App\Models\UserModel();
        $residential = $userModel->getResidential($userId);
        $data = [
           'role' => $role,
           'user' => $name,
           'header' => 'header testing',
           'dashboard_url' => $dashboard_url,
           'residential' => $residential,
           'role_category' => $role_category,
           'userId ' => $userId,
        ];


        return view('vendor/vendor_dashboard', $data);
    }

    public function getPoList()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $project_id = $this->request->getVar('project_id');
        $by_status = $this->request->getVar('by_status');
        $source = $this->request->getVar('source');

        switch ($by_status)
        {
            case 'delete':
                $by_status = 0;
                break;
            case 'new':
                $by_status = 1;
                break;
            case 'rejected':
                $by_status = 2;
                break;
        }

        if ($source == "vendor_add_do")
        {
            $recordsQuery = $db->table('po')
                ->select('po.*, users.name, users.tel, requisition.requisition_no AS requisition, requisition.id as requisition_id, vendor.company_name as vendor, (SELECT COUNT(*) FROM po_item WHERE po_item.po_id = po.id) AS total_item')
                ->join('users', 'users.id = po.create_by', 'left')
                ->join('requisition', 'requisition.id = po.requisition_id', 'left')
                ->join('vendor', 'vendor.id = po.vendor_id', 'left')
                ->where('po.residential_id', $project_id)
                ->where('po.company_id', $company_id)
                ->where('po.status', '2')
                ->groupBy('po.po_no');
        }
        else
        {
            $recordsQuery = $db->table('po')
            ->select('po.*, users.name, users.tel, requisition.requisition_no AS requisition, requisition.id as requisition_id, vendor.company_name as vendor, (SELECT COUNT(*) FROM po_item WHERE po_item.po_id = po.id) AS total_item')
            ->join('users', 'users.id = po.create_by', 'left')
            ->join('requisition', 'requisition.id = po.requisition_id', 'left')
            ->join('vendor', 'vendor.id = po.vendor_id', 'left')
            ->where('po.residential_id', $project_id)
            ->where('po.company_id', $company_id)
            ->groupBy('po.po_no');
        }
        $records = $recordsQuery->get()->getResultArray();

        $data_arr = [];
        $num = 1;
        $user_info = "";


        if ($records)
        {

            foreach ($records as $record)
            {
                $fid = $record['id'];
                $user_info = ['name' => $record['name'], 'tel' => $record['tel']];
                $total_item = $record['total_item'];
                $create_at = $record['create_at'];
                $accept_at = $record['accept_at'];
                $status = ($record['status'] == 1) ? "Pending" : "";
                $po_no = $record['po_no'];
                $rf_no = $record['requisition'];
                $vendor = $record['vendor'];



                switch ($record['status'])
                {
                    case '1':
                        $status = "Pending";
                        break;
                    case '2':
                        $status = "Accepted";
                        break;
                    case '3':
                        $status = "Rejected";
                        break;
                }


                if ($record['status'] == 1)
                {
                    $action = '<a href="#" class="btn btn-light-success font-weight-bolder btnUpdateAction" data-toggle="modal" data-target="#ConfirmPopup" data-id="' . $fid . '" data-ref-no="' . $po_no . '" data-action="accept" >Accept</a>';

                }
                else
                {
                    if ($source == "vendor_add_do")
                    {
                        $action = '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="' . $fid . '">Select</a>';
                    }
                    else
                    {
                        $action = "-";
                    }

                }

                $data_arr[] = [
                "id" => '',
                "po_no" => '<a class="modal-links po" data-toggle="modal" data-target="#po_form" data-id="' . $fid . '">' . $po_no . '</a>',
                "total_item" => $total_item,
                "accept_at" => $accept_at,
                "create_by" => $user_info['name'],
                "create_at" => $create_at,
                "vendor" => $vendor,
                "rf_no" => $rf_no,
                // "do" => "",
                "status" => $status,
                "action" => $action
                ];

                $num++;
            }
        }
        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);

    }

    public function getDoList()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $project_id = $this->request->getVar('project_id');
        $by_status = $this->request->getVar('by_status');
        $source = $this->request->getVar('source');

        switch ($by_status)
        {
            case 'new':
                $by_status = 1;
                break;
            case 'pending':
                $by_status = 2;
                break;
            case 'po':
                $by_status = 3;
                break;
            case 'do':
                $by_status = 4;
                break;
            case 'completed':
                $by_status = 5;
                break;
            case 'rejected':
                $by_status = 6;
                break;
        }

        $recordsQuery = $db->table('do')
            ->select('do.*, users.name, users.tel, vendor.company_name as vendor')
            ->join('users', 'users.id = do.create_by', 'left')
            ->join('vendor', 'vendor.id = do.vendor_id', 'left')
            ->where('do.residential_id', $project_id)
            ->where('do.company_id', $company_id)
            // ->where('do.status', $by_status)
            ->groupBy('do.do_no');

        $records = $recordsQuery->get()->getResultArray();
        $data_arr = [];
        $num = 1;
        $user_info = "";

        if ($records)
        {

            foreach ($records as $record)
            {
                $fid = $record['id'];
                $user_info = ['name' => $record['name'], 'tel' => $record['tel']];
                $create_at = $record['create_at'];
                $status = ($record['status'] == 1) ? "Pending" : "";
                $vendor = $record['vendor'];
                $do_no = $record['do_no'];


                switch ($record['status'])
                {
                    case '1':
                        $status = "Pending";
                        break;
                    case '2':
                        $status = "Delivered";
                        break;
                    case '3':
                        $status = "Rejected";
                        break;
                    
                }

                $total_item = $db->table('do_item')
                ->where('do_id', $fid)
                ->countAllResults();

                // if($source == "po_page") {
                // 	$action	= '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="'.$fid.'">Select</a>';
                // } else {
                $action = '<a href="' . $project_id . '/edit/' . $fid . '" class="action-btn"><i class="fas fa-edit" data-id="' . $fid . '"></i></a>';
                // }

                $data_arr[] = [
                "id" => '',
                "do_no" => '<a class="modal-links do" data-toggle="modal" data-target="#do_form" data-id="' . $fid . '">' . $do_no . '</a>',
                "total_item" => $total_item,
                "create_by" => $user_info['name'],
                "create_at" => $create_at,
                "vendor" => $vendor,
                "status" => $status,
                "action" => $action

                ];

                $num++;
            }
        }
        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);
    }

    public function show_do($id)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();


        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
             ->where('id', $userId)
             ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $residential = $userModel->getResidential($userId);


        $role_category = session()->get('role_category');
        $name = session()->get('name');
        $data = [
            'role' => $role,
            'user' => $name,
            'header' => 'header testing',
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        echo view('vendor/do', $data);
    }
    public function show_po($id)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();


        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
             ->where('id', $userId)
             ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $residential = $userModel->getResidential($userId);


        $role_category = session()->get('role_category');
        $name = session()->get('name');
        $data = [
            'role' => $role,
            'user' => $name,
            'header' => 'header testing',
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        echo view('vendor/po', $data);
    }

    public function getDoDetail()
    {
        $db = \Config\Database::connect();
        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $project_id = $this->request->getVar('project_id');
        $do_id = $this->request->getVar('id');
        $status = "fail";

        $company_info = $db->table('company')
            ->select('company.id as company_id, company.name AS company_name, company.address AS company_addr, residential.name AS residential_name, residential.address AS residential_addr, residential.logo')
            ->join('residential', 'residential.company_id = company.id', 'left')
            ->where('company.id', $company_id)
            ->where('residential.id', $project_id)
            ->get()
            ->getResult();

        if (count($company_info) > 0)
        {
            $status = "success";
        }

        $do_detail = $db->table('do')
        ->select('do.*, users.name AS creator_name, users.tel AS creator_tel, vendor.company_name AS vendor_company, vendor.address AS vendor_addr, po.po_no')
        ->join('users', 'users.id = do.create_by', 'left')
        ->join('vendor', 'vendor.id = do.vendor_id', 'left')
        ->join('po', 'po.id = do.po_id', 'left')
        ->where('do.id', $do_id)
        ->where('do.company_id', $company_id)
        ->get()->getResultArray();

        $do_list = $db->table('do_item')
         ->select('do_item.qty, do_item.remark, do_item.item_id, do_item.id AS do_item_id, do_item.po_item_id AS po_item_id, item.name, item.description, item.unit, item.img')
         ->join('item', 'do_item.item_id = item.id', 'left')
         ->join('do', 'do_item.do_id = do.id', 'left')
         ->where('do.id', $do_id)
         ->where('do.company_id', $company_id)
         ->orderBy('item.name', 'desc')
         ->get()->getResultArray();

        return $this->response->setJSON(array('status' => $status, 'company_info' => $company_info, 'do_detail' => $do_detail, 'do_list' => $do_list));
    }

    public function getPoDetail()
    {
        $db = \Config\Database::connect();
        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;



        $project_id = $this->request->getVar('project_id');
        $po_id = $this->request->getVar('id');
        $status = "fail";

        $company_info = $db->table('company')
            ->select('company.name AS company_name, company.address AS company_addr, residential.name AS residential_name, residential.address AS residential_addr, residential.logo')
            ->join('residential', 'residential.company_id = company.id', 'left')
            ->where('company.id', $company_id)
            ->where('residential.id', $project_id)
            ->get()
            ->getResult();

        if (count($company_info) > 0)
        {
            $status = "success";
        }

        $po_detail = $db->table('po')
            ->select('po.*, users.name AS creator_name, users.tel AS creator_tel, vendor.company_name AS vendor_company, vendor.address AS vendor_addr, requisition.requisition_no')
            ->join('users', 'users.id = po.create_by', 'left')
            ->join('vendor', 'vendor.id = po.vendor_id', 'left')
            ->join('requisition', 'requisition.id = po.requisition_id', 'left')
            ->where('po.id', $po_id)
            ->where('po.company_id', $company_id)
            ->get()
            ->getResult();

        $po_list = $db->table('po_item')
            ->select('po_item.qty, po_item.id as po_item_id, po_item.remark, po_item.item_id, po_item.requisition_item_id, item.name, item.description, item.unit, item.img')
            ->join('item', 'po_item.item_id = item.id', 'left')
            ->join('po', 'po_item.po_id = po.id', 'left')
            ->where('po.id', $po_id)
            ->where('po.company_id', $company_id)
            ->orderBy('item.name', 'desc')
            ->get()
            ->getResult();

        return $this->response->setJSON(array('status' => $status, 'company_info' => $company_info, 'po_detail' => $po_detail, 'po_list' => $po_list));
    }

    public function create($project_id)
    {
        $session = \Config\Services::session();

        $user_id = $session->get('id');
        $role = $session->get('role');

        $userModel = new UserModel();
        $user = $role = $session->get('name');

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential_id = $res->id;



        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $user_id)
                         ->countAll();
        if ($count == 0)
        {
            return redirect()->back();
        }

        $residential = $userModel->getResidential($user_id);



        $vendors = $db->query("SELECT * FROM vendor WHERE company_id = ? ORDER BY company_name ASC", [$company_id])->getResult();

        $po_list = $db->query("SELECT po.*, v.company_name FROM po LEFT JOIN vendor AS v ON v.id=po.company_id WHERE po.company_id = ? AND po.residential_id = ? ORDER BY po.id DESC", [$company_id, $project_id])->getResult();

        return view('vendor/create_do', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            'company_id' => $company_id,
            'residential_id' => $residential_id,
            'vendors' => $vendors,
            'po_list' => $po_list
        ]);
    }


    public function store()
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $list = json_decode($this->request->getPost('list'), true);
        $project_id = $this->request->getPost('project_id');
        $do_no = $this->request->getPost('do_no');

        $do_date = $this->request->getPost('do_date');
        $po_id = $this->request->getPost('po_id');
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $user_id = $session->get('id');

        $db = \Config\Database::connect();

        $rf_id = $db->table('po')
           ->select('requisition_id')
           ->where('id', $po_id)
           ->get()
           ->getRow()
           ->requisition_id;

        $vendor_id = $db->table('users')
        ->select('vendor_id')
        ->where('id', $user_id)
        ->get()
        ->getRow()
        ->vendor_id;

        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg, 'request' => $this->request->getPost()]));
        }

        $filename = $this->request->getPost('do_filename');
        $file = $this->request->getFile('file_data');
        $msg = "";

        $data_row = [
            'company_id' => $company_id,
            'residential_id' => $project_id,
            'do_no' => $do_no,
            'do_file' => $filename,
            'do_date' => $do_date,
            'status' => 1,
            'po_id' => $po_id,
            'vendor_id' => $vendor_id,
            'create_by' => $user_id,
            'create_at' => date("Y-m-d H:i:s")
        ];

        $db->table('do')->insert($data_row);
        $insertid = $db->insertID();

        if ($file && $file->getError() !== UPLOAD_ERR_NO_FILE)
        {
            $folder = FCPATH . 'document/' . $company_id . '/do/';

            if (!is_dir($folder))
            {
                mkdir($folder, 0777, true);
            }
            $file_ext = $file->getExtension();

            $from_path = FCPATH . $filename;
            $new_filename = "do_" . $insertid . "." . $file_ext;
            $to_path = $folder . $new_filename;
            if (file_exists($from_path))
            {
                if (rename($from_path, $to_path))
                {
                    $msg .= "\n [OK] Move file [from_path: $from_path] [to_path: $to_path]";
                    $db->table('do')->where('id', $insertid)->update(['do_file' => $new_filename]); // update the filename in the database
                }
                else
                {
                    $msg .= "\n [FAIL] Move file [from_path: $from_path] [to_path: $to_path]";
                }
            }
        }

        if ($insertid)
        {
            $msg = "DO created! - ID: " . $insertid;

            foreach ($list as $row)
            {
                $temp = [
                    'do_id' => $insertid,
                    'item_id' => $row['id'],
                    'qty' => $row['qty'],
                    'remark' => $row['remark'],
                    'po_item_id' => $row['po_item_id'],
                    'create_by' => $user_id,
                    'create_at' => date("Y-m-d H:i:s")
                ];

                $db->table('do_item')->insert($temp);
            }

           
        }

        return $this->response->setJSON(['status' => 'success', 'msg' => $msg, 'request' => $this->request->getPost(), 'do_id' => $insertid]);
    }


    public function edit($project_id, $fid)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();
        $user = session()->get('name');

        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $userId)
                         ->countAll();

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential = $userModel->getResidential($userId);
        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $do_list = $db->query("SELECT do.*, v.company_name 
        FROM do LEFT JOIN vendor AS v ON v.id=do.vendor_id 
        WHERE do.company_id = '$company_id' AND do.residential_id = '$project_id' AND do.id <> '$fid' 
        ORDER BY do.id desc")->getResult();

        $vendors = $db->query("SELECT * FROM vendor
        WHERE company_id = ? 
        ORDER BY company_name ASC", [$company_id])->getResult();

        return view('vendor/create_do', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            'do_list' => $do_list,
            'vendors' => $vendors,
        ]);

    }


    public function update($id)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $list = json_decode($this->request->getPost('list'), true);
        $project_id = $this->request->getPost('project_id');
        $do_no = $this->request->getPost('do_no');

        $do_date = $this->request->getPost('do_date');
        $po_id = $this->request->getPost('po_id');
        $clickeddelete = $this->request->getPost('clickeddelete');
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $user_id = $session->get('id');

        $db = \Config\Database::connect();

        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg]));
        }

        $filename = $this->request->getPost('do_filename');
        $file = $this->request->getFile('file_data');
        $msg = "";

        if ($file && $file->getError() !== UPLOAD_ERR_NO_FILE)
        {
            $folder = FCPATH . 'document/' . $company_id . '/po/';


            if (!is_dir($folder))
            {
                mkdir($folder, 0777, true);
            }
            $file_ext = $file->getExtension();


            $new_filename = "do_" . $id . "." . $file_ext;

            $from_path = FCPATH . $filename;
            $to_path = FCPATH . 'document/' . $company_id . '/do/' . $new_filename;

            $msg = "[from_path: $from_path] [to_path: $to_path]";

            if (file_exists($from_path))
            {
                if (rename($from_path, $to_path))
                {
                    $msg .= "\n [OK] Move file [from_path: $from_path] [to_path: $to_path]";
                }
                else
                {
                    $msg .= "\n [FAIL] Move file [from_path: $from_path] [to_path: $to_path]";
                }
            }

        }

        $data_row = [
            'do_no' => $do_no,
            'po_id' => $po_id,
            'update_by' => $user_id,
            'update_at' => date("Y-m-d H:i:s"),
            'do_date' => $do_date,
        ];
        if ($clickeddelete == false)
        {
            $data_row['do_file'] = '';
        }
        else if (isset($new_filename))
        {
            $data_row['do_file'] = $new_filename;
        }
        $db->table('do')
        ->where('id', $id)
        ->where('company_id', $company_id)
        ->where('residential_id', $project_id)
        ->update($data_row);

        if ($db->affectedRows())
        {
            $db->table('do_item')
            ->where('do_id', $id)
            ->delete();
            $msg = "DO updated! - ID: " . $id;
            foreach ($list as $row)
            {
                $temp = [
                    'do_id' => $id,
                    'item_id' => $row['id'],
                    'qty' => $row['qty'],
                    'po_item_id' => $row['po_item_id'],
                    'remark' => $row['remark'],
                    'create_by' => $user_id,
                    'create_at' => date("Y-m-d H:i:s"),
                    'update_by' => $user_id,
                    'update_at' => date("Y-m-d H:i:s")
                ];

                // Insert new item
                $db->table('do_item')->insert($temp);
            }
        }

        return $this->response->setJSON(['status' => 'success', 'msg' => $msg, 'po_id' => $id]);
    }


    public function update_status()
    {
        $db = \Config\Database::connect();
        $userId = session()->get('id');
        $data_row = array();
        $id = $this->request->getPost('id');

        $update_status = $this->request->getPost('update_status');

        if ($update_status == "accept")
        {
            $data_row = [
                'status' => 2,
                'accept_by' => $userId,
                'accept_at' => date("Y-m-d H:i:s")
            ];
            $update_result = $db->table('po')->where('id', $id)->update($data_row);
        }

        if (isset($update_result) && $update_result)
        {
            $status = "success";
            $msg = "Updated successfully.";
        }
        else
        {
            $status = "fail";
            $msg = "Failed to update.";
        }

        return $this->response->setJSON(['status' => $status, 'msg' => $msg, 'do_id' => $id]);
    }

}