<?php

namespace App\Controllers;

use App\Models\CompanyModel;
use App\Models\UserModel;
use App\Models\ResidentialModel;
use App\Models\RequisitionModel;
use App\Models\MaterialModel;
use CodeIgniter\Config\Services;

class RequisitionController extends BaseController
{

    public function create($project_id)
    {
        $session = \Config\Services::session();

        $user_id = $session->get('id');
        $role = $session->get('role');

        $userModel = new UserModel();
        $user = $role = $session->get('name');

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential_id = $res->id;

        // $materialModel = new MaterialModel();
        // $items = $materialModel->getMaterial('item', $company_id);

        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $user_id)
                         ->countAll();
        if ($count == 0)
        {
            return redirect()->back();
        }

        $residential = $userModel->getResidential($user_id);
        return view('requisition/create_requisition', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            // 'items' => $items,
            'company_id' => $company_id,
            'residential_id' => $residential_id,
        ]);
    }

    public function store($residential_id)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $res = $userModel->getCurrentResidential($residential_id);
        $company_id = $res->company_id;
        $user_id = $session->get('id');
        $project_id = $residential_id;
        $json = $this->request->getJSON(true);
        $list = $json['list'];

        $db = \Config\Database::connect();

        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg, 'request' => $json]));
        }

        $total_rf = $db->table('requisition')
            ->where('company_id', $company_id)
            ->where('residential_id', $project_id)
            ->where('DATE(create_at)', date('Y-m-d'))
            ->countAllResults();

        $total_rf = $total_rf + 1;
        $rf_no = "RF-" . $residential->code . date("ymd") . str_pad($total_rf, 3, "0", STR_PAD_LEFT);

        $data_row['company_id'] = $company_id;
        $data_row['residential_id'] = $project_id;
        $data_row['requisition_no'] = $rf_no;
        $data_row['status'] = 1;
        $data_row['create_by'] = $user_id;
        $data_row['create_at'] = date("Y-m-d H:i:s");

        $db->table('requisition')->insert($data_row);
        $id = $db->insertID();

        if ($id)
        {
            $msg = "RF created! - ID: " . $id;
            foreach ($list as $row)
            {
                $temp = array();
                $temp['requisition_id'] = $id;
                $temp['item_id'] = $row['id'];
                $temp['qty'] = $row['qty'];
                $temp['status'] = 1;
                $temp['remark'] = $row['remark'];
                $temp['create_by'] = $user_id;
                $temp['create_at'] = date("Y-m-d H:i:s");
                $db->table('requisition_item')->insert($temp);
            }
        }
        return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'success', 'msg' => $msg, 'request' => $json, 'rf_id' => $id]));
    }


    public function getRfList()
    {

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $project_id = $this->request->getVar('project_id');
        $by_status = $this->request->getVar('by_status');
        $source = $this->request->getVar('source');
        $rf_id = $this->request->getVar('rf_id') ?? "";
        switch ($by_status)
        {
            case 'pending':
                $by_status = 1;
                break;
            case 'approve':
                $by_status = 2;
                break;
            case 'po':
                $by_status = 3;
                break;
            case 'do':
                $by_status = 4;
                break;
            case 'completed':
                $by_status = 5;
                break;
            case 'rejected':
                $by_status = 6;
                break;
        }

        $db = \Config\Database::connect();

        if ($source == "po_edit" && $rf_id != "")
        {
            $recordsQuery = $db->table('requisition')
            ->select('requisition.*, users.name, users.tel, po.po_no AS po, po.id as po_id, (SELECT COUNT(*) FROM requisition_item WHERE requisition_item.requisition_id = requisition.id) AS total_item')
            ->join('users', 'users.id = requisition.create_by', 'left')
            ->join('po', 'po.requisition_id = requisition.id', 'left')
            ->where('requisition.residential_id', $project_id)
            ->where('requisition.company_id', $company_id)
            ->where('requisition.id', $rf_id)
            ->groupBy('requisition.requisition_no')
            ->whereIn('requisition.status', [2, 3]);

        }
        else if ($source == "po_create")
        {
            $recordsQuery = $db->table('requisition')
            ->select('requisition.*, users.name, users.tel, po.po_no AS po, po.id as po_id, (SELECT COUNT(*) FROM requisition_item WHERE requisition_item.requisition_id = requisition.id) AS total_item')
            ->join('users', 'users.id = requisition.create_by', 'left')
            ->join('po', 'po.requisition_id = requisition.id', 'left')
            ->where('requisition.residential_id', $project_id)
            ->where('requisition.company_id', $company_id)
            ->groupBy('requisition.requisition_no')
            ->whereIn('requisition.status', [2, 3]);
        }
        else if ($source == "overview")
        {
            $recordsQuery = $db->table('requisition')
            ->select('requisition.*, users.name, users.tel, po.po_no AS po, po.id as po_id, (SELECT COUNT(*) FROM requisition_item WHERE requisition_item.requisition_id = requisition.id) AS total_item')
            ->join('users', 'users.id = requisition.create_by', 'left')
            ->join('po', 'po.requisition_id = requisition.id', 'left')
            ->where('requisition.residential_id', $project_id)
            ->where('requisition.company_id', $company_id)
            ->groupBy('requisition.requisition_no');
        }
        else
        { //Requisition Form List 
            $recordsQuery = $db->table('requisition')
            ->select('requisition.*, users.name, users.tel, po.po_no AS po, po.id as po_id, (SELECT COUNT(*) FROM requisition_item WHERE requisition_item.requisition_id = requisition.id) AS total_item')
            ->join('users', 'users.id = requisition.create_by', 'left')
            ->join('po', 'po.requisition_id = requisition.id', 'left')
            ->where('requisition.residential_id', $project_id)
            ->where('requisition.company_id', $company_id)
            ->groupBy('requisition.requisition_no')
            ->where('requisition.status', $by_status);
        }

        $records = $recordsQuery->get()->getResultArray();

        $data_arr = [];
        $num = 1;
        $user_info = "";

        if ($records)
        {
            foreach ($records as $record)
            {
                $fid = $record['id'];
                $user_info = ['name' => $record['name'], 'tel' => $record['tel']];
                $total_item = $record['total_item'];
                $requisition_no = $record['requisition_no'];
                $create_at = $record['create_at'];
                $date = explode(" ", $create_at)[0];
                $reject_at = $record['reject_at'];
                $approve_at = $record['approve_at'];
                $status = ($record['status'] == 1) ? "Pending" : "";
                $role_category = session()->get('role_category');

                if (in_array('Site', $role_category))
                {
                    $po_text = $record['po'] ? $record['po'] : '';
                }
                else
                {
                    $po_text = '<a class="modal-links po" data-toggle="modal" data-target="#po_form" data-id="' . $record['po_id'] . '">' . $record['po'] . '</a>';

                }

                switch ($record['status'])
                {
                    case '1':
                        $status = "Pending";
                        break;
                    case '2':
                        $status = "Approved";
                        break;
                    case '3':
                        $status = "PO Processed";
                        break;
                    case '4':
                        $status = "DO Processed";
                        break;
                    case '5':
                        $status = "Completed";
                        break;
                    case '6':
                        $status = "Rejected";
                        break;
                }

                if ($source == "po_create" || $source == "po_edit")
                {
                    $action = '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="' . $fid . '">Select</a>';
                }
                else if ($source == "overview")
                {
                    $action = '<a href="' . $project_id . '/show_overview/' . $fid . '" class="action-btn"><i class="fas fa-eye" data-id="' . $fid . '"></i></a>';

                }
                else if ($record['status'] > 1)
                {
                    $action = '';
                }
                else
                {
                    $action = '<a href="' . $project_id . '/showedit/' . $fid . '" class="action-btn"><i class="fas fa-edit" data-id="' . $fid . '"></i></a>';
                }


                if ($source == "overview")
                {
                    if ($record['status'] == 5)
                    {
                        $status = "Completed";
                    }
                    else
                    {
                        $status = "InComplete";
                    }
                }

                $data_arr[] = [
                    "id" => $fid,
                    "requisition_no" => '<a class="modal-links" data-toggle="modal" data-target="#requisition_form" data-id="' . $fid . '">' . $requisition_no . '</a>',
                    "total_item" => $total_item,
                    "create_by" => $user_info['name'],
                    "create_at" => $date,
                    "contact" => $user_info['tel'],
                    "po" => $po_text,
                    "do" => "",
                    "status" => $status,
                    "action" => $action,
                    "reject_at" => $reject_at,
                    "approve_at" => $approve_at,
                ];

                $num++;
            }
        }
        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);
    }


    public function getRfDetail()
    {

        $db = \Config\Database::connect();
        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $status = "fail";
        $rf_detail = "";
        $rf_list = array();
        $msg = "";

        $project_id = $this->request->getVar('project_id');
        $rf_id = $this->request->getVar('id');

        $companyModel = new CompanyModel();
        $company_info = $companyModel->select('company.name AS company_name, company.address AS company_addr, residential.name AS residential_name, residential.address AS residential_addr, residential.logo')
            ->join('residential', 'residential.company_id = company.id', 'left')
            ->where('company.id', $company_id)
            ->where('residential.id', $project_id)
            ->findAll();

        if (count($company_info) > 0)
        {
            $status = "success";
        }


        $rf_detail = $db->table('requisition')->select('requisition.*, users.name AS creator_name, users.tel AS creator_tel')
            ->join('users', 'users.id = requisition.create_by', 'left')
            ->where('requisition.id', $rf_id)
            ->where('requisition.company_id', $company_id)
            ->get()
            ->getResultArray();


        $rf_list = $db->table('requisition_item')->select('requisition_item.requisition_id AS requisition_id, requisition_item.id AS rf_item_id, requisition_item.qty, requisition_item.remark, requisition_item.item_id, item.name, item.description, item.unit, item.img')
            ->join('item', 'requisition_item.item_id = item.id', 'left')
            ->join('requisition', 'requisition_item.requisition_id = requisition.id', 'left')
            ->where('requisition.id', $rf_id)
            ->where('requisition.company_id', $company_id)
            ->orderBy('item.name', 'desc')
            ->get()
            ->getResultArray();

        $num = 0;
        foreach ($rf_list as &$rf)
        {


            $total_qty = $db->query("
            SELECT SUM(po_item.qty) as total_qty
            FROM po_item
            LEFT JOIN requisition_item ON po_item.requisition_item_id = requisition_item.id
            WHERE po_item.requisition_item_id = ?
        ", [$rf['rf_item_id']])->getRow()->total_qty;

            $total_qty = $total_qty ?? 0;

            // To get the last executed query
            $lastQuery = $db->getLastQuery();
            $sql = (string)$lastQuery;
            $text_qty_ordered = $total_qty;
            $is_available = "yes";


            if ($total_qty != 0)
            {
                if ($rf['qty'] > $total_qty)
                {
                    $text_qty_ordered = '<label style="color:green;">' . $total_qty . '</label>';

                }
                else if ($total_qty > $rf['qty'])
                {
                    $text_qty_ordered = '<label style="color:red;">' . $total_qty . '</label>';
                    $is_available = "no";

                }
                else if ($total_qty == $rf['qty'])
                {
                    $text_qty_ordered = $total_qty;
                    $is_available = "no";
                }
            }

            $msg .= "\n[$num] " . $rf['name'];

            $rf['sql'] = $sql;
            $rf['qty_ordered'] = $text_qty_ordered;
            $rf['is_available'] = $is_available;

            $num++;
        }

        echo json_encode(array('status' => $status, 'company_info' => $company_info, 'rf_detail' => $rf_detail, 'rf_list' => $rf_list, 'msg' => $msg));
    }

    public function show($id)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();


        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
                         ->where('id', $userId)
                         ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $residential = $userModel->getResidential($userId);


        $role_category = session()->get('role_category');
        $name = session()->get('name');
        $data = [
            'role' => $role,
            'user' => $name,
            'header' => 'header testing',
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        echo view('requisition/requisition', $data);

    }

    public function showedit($project_id, $fid)
    {
        $session = \Config\Services::session();

        $user_id = $session->get('id');
        $role = $session->get('role');

        $userModel = new UserModel();
        $user = $session->get('name');

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential_id = $res->id;

        // $materialModel = new MaterialModel();
        // $items = $materialModel->getMaterial('item', $company_id);

        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $user_id)
                         ->countAll();
        if ($count == 0)
        {
            return redirect()->back();
        }

        $residential = $userModel->getResidential($user_id);
        return view('requisition/create_requisition', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            // 'items' => $items,
            'company_id' => $company_id,
            'residential_id' => $residential_id,
        ]);
    }

    public function update($requisition_id)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $json = $this->request->getJSON(true);
        $project_id = $json['project_id'];
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $user_id = $session->get('id');
        // $project_id = $residential_id;

        $list = $json['list'];

        $db = \Config\Database::connect();

        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg, 'request' => $json]));
        }


        $data_row['update_by'] = $user_id;
        $data_row['update_at'] = date("Y-m-d H:i:s");

        $db->table('requisition')
            ->where('id', $requisition_id)
            ->where('company_id', $company_id)
            ->where('residential_id', $project_id)
            ->update($data_row);

        if ($db->affectedRows())
        {
            $msg = "RF updated! - ID: " . $requisition_id;
            $db->table('requisition_item')
            ->where('requisition_id', $requisition_id)
            ->delete();


            foreach ($list as $row)
            {
                $temp = array();
                $temp['qty'] = $row['qty'];
                $temp['status'] = 1;
                $temp['remark'] = $row['remark'];
                $temp['update_by'] = $user_id;
                $temp['update_at'] = date("Y-m-d H:i:s");
                $temp['requisition_id'] = $requisition_id;
                $temp['item_id'] = $row['id'];
                $temp['create_by'] = $user_id;
                $temp['create_at'] = date("Y-m-d H:i:s");
                $db->table('requisition_item')->insert($temp);

            }
        }
        return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'success', 'msg' => $msg, 'request' => $json, 'rf_id' => $requisition_id]));
    }
    public function updateRf()
    {

        $session = \Config\Services::session();
        $db = \Config\Database::connect();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $json = $this->request->getJSON(true);
        $project_id = $json['project_id'];
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $rf_id = $json['id'];
        $update_status = $json['status'];
        $status = "fail";

        $residential = $db->table('residential')
        ->where('id', $project_id)
        ->where('company_id', $company_id)
        ->get()
        ->getFirstRow();

        if (!$residential)
        {
            return $this->response->setJSON(['status' => 'fail', 'msg' => 'Invalid request.', 'request' => $json]);
        }
        $temp = array();
        switch ($update_status)
        {
            case 'approve':
                $update_status = 2;
                $temp['approve_by'] = $user_id;
                $temp['approve_at'] = date("Y-m-d H:i:s");
                break;
            case 'reject':
                $update_status = 3;
                $temp['reject_at'] = date("Y-m-d H:i:s");
                break;
        }


        $temp['id'] = $rf_id;
        $temp['status'] = $update_status;

        //temp2
        $temp2 = array();
        $temp2['status'] = $update_status;
        $temp2['update_by'] = $user_id;
        $temp2['update_at'] = date("Y-m-d H:i:s");

        try
        {
            $builder = $db->table('requisition');
            $builder->where('id', $rf_id);
            $builder->update($temp);



            // update requisition_item table
            $builder2 = $db->table('requisition_item');
            $builder2->where('requisition_id', $rf_id);
            $builder2->update($temp2);

            $msg = "Update successful";
            $status = "success";
        }
        catch (\Exception $e)
        {
            $msg = "Update fail.";
        }

        return $this->response->setJSON(['status' => $status, 'msg' => $msg, 'request' => $this->request->getPost(), 'rf_id' => $rf_id]);
    }


}