<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\MaterialModel;
use CodeIgniter\Config\Services;

class PurchaseOrderController extends BaseController
{
    public function show($id)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();


        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
                         ->where('id', $userId)
                         ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $residential = $userModel->getResidential($userId);


        $role_category = session()->get('role_category');
        $name = session()->get('name');
        $data = [
            'role' => $role,
            'user' => $name,
            'header' => 'header testing',
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        if (in_array('Site', $role_category))
        {
            echo view('site/po', $data);
        }
        else
        {
            echo view('po/po', $data);
        }
    }

    public function getPoList()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $project_id = $this->request->getVar('project_id');
        $by_status = $this->request->getVar('by_status');
        $source = $this->request->getVar('source');

        switch ($by_status)
        {
            case 'new':
                $by_status = 1;
                break;
            case 'pending':
                $by_status = 2;
                break;
            case 'po':
                $by_status = 3;
                break;
            case 'do':
                $by_status = 4;
                break;
            case 'completed':
                $by_status = 5;
                break;
            case 'rejected':
                $by_status = 6;
                break;
        }

        $recordsQuery = $db->table('po')
            ->select('po.*, users.name, users.tel, requisition.requisition_no AS requisition, requisition.id as requisition_id, vendor.company_name as vendor, (SELECT COUNT(*) FROM po_item WHERE po_item.po_id = po.id) AS total_item')
            ->join('users', 'users.id = po.create_by', 'left')
            ->join('requisition', 'requisition.id = po.requisition_id', 'left')
            ->join('vendor', 'vendor.id = po.vendor_id', 'left')
            ->where('po.residential_id', $project_id)
            ->where('po.company_id', $company_id)
            ->where('po.status', $by_status)
            ->groupBy('po.po_no');

        $records = $recordsQuery->get()->getResultArray();

        $data_arr = [];
        $num = 1;
        $user_info = "";


        if ($records)
        {

            foreach ($records as $record)
            {
                $fid = $record['id'];
                $user_info = ['name' => $record['name'], 'tel' => $record['tel']];
                $total_item = $record['total_item'];
                $create_at = $record['create_at'];
                $accept_at = $record['accept_at'];
                $status = ($record['status'] == 1) ? "Pending" : "";
                $po_no = $record['po_no'];
                $rf_no = $record['requisition'];
                $vendor = $record['vendor'];



                switch ($record['status'])
                {
                    case '1':
                        $status = "Pending";
                        break;
                    case '2':
                        $status = "Approved";
                        break;
                    case '3':
                        $status = "PO Processed";
                        break;
                    case '4':
                        $status = "DO Processed";
                        break;
                    case '5':
                        $status = "Completed";
                        break;
                    case '6':
                        $status = "Rejected";
                        break;
                }


                if ($source == "po_page")
                {
                    $action = '<a href="#" class="btn btn-light-primary font-weight-bolder btnSelect" data-id="' . $fid . '">Select</a>';

                }
                else
                {
                    $action = '<a href="' . $project_id . '/edit/' . $fid . '" class="action-btn"><i class="fas fa-edit" data-id="' . $fid . '"></i></a>';
                    // $action = '<a href="' . $project_id . '/showedit/' . $fid . '" class="action-btn"><i class="fas fa-edit" data-id="' . $fid . '"></i></a>';
                }

                $data_arr[] = [
                "id" => '',
                "po_no" => '<a class="modal-links po" data-toggle="modal" data-target="#po_form" data-id="' . $fid . '">' . $po_no . '</a>',
                "total_item" => $total_item,
                "accept_at" => $accept_at,
                "create_by" => $user_info['name'],
                "create_at" => $create_at,
                "vendor" => $vendor,
                "rf_no" => $rf_no,
                "do" => "",
                "status" => $status,
                "action" => $action
                ];

                $num++;
            }
        }
        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);

    } //done

    public function getPoDetail()
    {
        $db = \Config\Database::connect();
        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        // $materialModel = new MaterialModel();
        // $materials = $materialModel->getMaterial('trade', $company_id);

        $project_id = $this->request->getVar('project_id');
        $po_id = $this->request->getVar('id');
        $status = "fail";

        $company_info = $db->table('company')
            ->select('company.name AS company_name, company.address AS company_addr,company.id as company_id, residential.name AS residential_name, residential.address AS residential_addr, residential.logo')
            ->join('residential', 'residential.company_id = company.id', 'left')
            ->where('company.id', $company_id)
            ->where('residential.id', $project_id)
            ->get()
            ->getResult();

        if (count($company_info) > 0)
        {
            $status = "success";
        }

        $po_detail = $db->table('po')
            ->select('po.*, users.name AS creator_name, users.tel AS creator_tel, vendor.company_name AS vendor_company, vendor.address AS vendor_addr, requisition.requisition_no')
            ->join('users', 'users.id = po.create_by', 'left')
            ->join('vendor', 'vendor.id = po.vendor_id', 'left')
            ->join('requisition', 'requisition.id = po.requisition_id', 'left')
            ->where('po.id', $po_id)
            ->where('po.company_id', $company_id)
            ->get()
            ->getResult();

        $po_list = $db->table('po_item')
            ->select('po_item.qty, po_item.remark, po_item.item_id, po_item.requisition_item_id, item.name, item.description, item.unit, item.img')
            ->join('item', 'po_item.item_id = item.id', 'left')
            ->join('po', 'po_item.po_id = po.id', 'left')
            ->where('po.id', $po_id)
            ->where('po.company_id', $company_id)
            ->orderBy('item.name', 'desc')
            ->get()
            ->getResult();

        return $this->response->setJSON(array('status' => $status, 'company_info' => $company_info, 'po_detail' => $po_detail, 'po_list' => $po_list));
    } //done

    public function create($project_id)
    {
        $session = \Config\Services::session();

        $user_id = $session->get('id');
        $role = $session->get('role');

        $userModel = new UserModel();
        $user = $role = $session->get('name');

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential_id = $res->id;

        // $materialModel = new MaterialModel();
        // $items = $materialModel->getMaterial('item', $company_id);

        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $user_id)
                         ->countAll();
        if ($count == 0)
        {
            return redirect()->back();
        }

        $residential = $userModel->getResidential($user_id);



        $vendors = $db->query("SELECT * FROM vendor WHERE company_id = ? ORDER BY company_name ASC", [$company_id])->getResult();

        $po_list = $db->query("SELECT po.*, v.company_name FROM po LEFT JOIN vendor AS v ON v.id=po.company_id WHERE po.company_id = ? AND po.residential_id = ? ORDER BY po.id DESC", [$company_id, $project_id])->getResult();

        return view('po/create_po', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            'company_id' => $company_id,
            'residential_id' => $residential_id,
            'vendors' => $vendors,
            'po_list' => $po_list
        ]);
    } //done



    public function edit($project_id, $fid)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();
        $user = session()->get('name');

        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $userId)
                         ->countAll();

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential = $userModel->getResidential($userId);
        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $po_list = $db->query("SELECT po.*, v.company_name FROM po
        LEFT JOIN vendor AS v ON v.id=po.company_id 
        WHERE po.company_id = ? AND po.residential_id = ? AND po.id <> ? 
        ORDER BY po.id DESC", [$company_id, $project_id, $fid])->getResult();

        $vendors = $db->query("SELECT * FROM vendor
        WHERE company_id = ? 
        ORDER BY company_name ASC", [$company_id])->getResult();

        return view('po/create_po', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            'po_list' => $po_list,
            'vendors' => $vendors,
        ]);

    } //done

    public function store()
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $list = json_decode($this->request->getPost('list'), true);
        $project_id = $this->request->getPost('project_id');
        $po_no = $this->request->getPost('po_no');
        $vendor_id = $this->request->getPost('vendor_id');
        $po_date = $this->request->getPost('po_date');
        $rf_id = $this->request->getPost('rf_id');
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $user_id = $session->get('id');

        $db = \Config\Database::connect();

        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg, 'request' => $this->request->getPost()]));
        }

        $filename = $this->request->getPost('po_filename');
        $file = $this->request->getFile('file_data');
        $msg = "";

        $data_row = [
            'company_id' => $company_id,
            'residential_id' => $project_id,
            'po_no' => $po_no,
            'requisition_id' => $rf_id,
            'po_file' => $filename, 
            'po_date' => $po_date,
            'status' => 1,
            'vendor_id' => $vendor_id,
            'create_by' => $user_id,
            'create_at' => date("Y-m-d H:i:s")
        ];

        $db->table('po')->insert($data_row);
        $insertid = $db->insertID();

        if ($file && $file->getError() !== UPLOAD_ERR_NO_FILE)
        {
            $folder = FCPATH . 'document/' . $company_id . '/po/';

            if (!is_dir($folder))
            {
                mkdir($folder, 0777, true);
            }
            $file_ext = $file->getExtension();

            $from_path = FCPATH . $filename;
            $new_filename = "po_" . $insertid . "." . $file_ext;
            $to_path = $folder . $new_filename;
            if (file_exists($from_path))
            {
                if (rename($from_path, $to_path))
                {
                    $msg .= "\n [OK] Move file [from_path: $from_path] [to_path: $to_path]";
                    $db->table('po')->where('id', $insertid)->update(['po_file' => $new_filename]); // update the filename in the database
                }
                else
                {
                    $msg .= "\n [FAIL] Move file [from_path: $from_path] [to_path: $to_path]";
                }
            }
        }

        if ($insertid)
        {
            $msg = "PO created! - ID: " . $insertid;

            foreach ($list as $row)
            {
                $temp = [
                    'po_id' => $insertid,
                    'item_id' => $row['id'],
                    'qty' => $row['qty'],
                    'requisition_item_id' => $row['rf_item_id'],
                    'create_by' => $user_id,
                    'create_at' => date("Y-m-d H:i:s")
                ];

                $db->table('po_item')->insert($temp);
            }

        }

        return $this->response->setJSON(['status' => 'success', 'msg' => $msg, 'request' => $this->request->getPost(), 'po_id' => $insertid]);
    }

    public function update($id)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');

        // Changed from JSON to Post
        $list = json_decode($this->request->getPost('list'), true);
        $project_id = $this->request->getPost('project_id');
        $po_no = $this->request->getPost('po_no');
        $vendor_id = $this->request->getPost('vendor_id');
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $db = \Config\Database::connect();

        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg]));
        }

        $filename = $this->request->getPost('po_filename');
        $file = $this->request->getFile('file_data');
        $msg = "";

        if ($file && $file->getError() !== UPLOAD_ERR_NO_FILE)
        {
            $folder = FCPATH . 'document/' . $company_id . '/po/';


            if (!is_dir($folder))
            {
                mkdir($folder, 0777, true);
            }
            $file_ext = $file->getExtension();


            $new_filename = "po_" . $id . "." . $file_ext;

            $from_path = FCPATH . $filename;
            $to_path = FCPATH . 'document/' . $company_id . '/po/' . $new_filename;

            $msg = "[from_path: $from_path] [to_path: $to_path]";

            if (file_exists($from_path))
            {
                if (rename($from_path, $to_path))
                {
                    $msg .= "\n [OK] Move file [from_path: $from_path] [to_path: $to_path]";
                }
                else
                {
                    $msg .= "\n [FAIL] Move file [from_path: $from_path] [to_path: $to_path]";
                }
            }

        }

        $data_row = [
            'po_no' => $po_no,
            'po_file' => isset($new_filename) ? $new_filename : '', // If file uploaded, use new filename otherwise keep old
            'vendor_id' => $vendor_id,
            'status' => 1,
            'update_by' => $user_id,
            'update_at' => date("Y-m-d H:i:s")
        ];

        $db->table('po')
        ->where('id', $id)
        ->where('company_id', $company_id)
        ->where('residential_id', $project_id)
        ->update($data_row);

        if ($db->affectedRows())
        {
            $msg = "PO updated! - ID: " . $id;
            $db->table('po_item')
            ->where('po_id', $id)
            ->delete();

            foreach ($list as $row)
            {
                $temp = [
                    'po_id' => $id,
                    'requisition_item_id' => $row['rf_item_id'],
                    'item_id' => $row['id'],
                    'qty' => $row['qty'],
                    'remark' => $row['remark'],
                    'create_by' => $user_id,
                    'create_at' => date("Y-m-d H:i:s"),
                    'update_by' => $user_id,
                    'update_at' => date("Y-m-d H:i:s")
                ];
            
                // Insert new item
                $db->table('po_item')->insert($temp);
                
            }
        }

        return $this->response->setJSON(['status' => 'success', 'msg' => $msg, 'po_id' => $id]);
    }

}