<?php

namespace App\Controllers;

use App\Models\UserModel;

class OverviewController extends BaseController
{


    public function show($id)
    {
        $this->enforceLogin();
        $userModel = new UserModel(); // Use your UserModel namespace
        $role = session()->get('role');
        $name = session()->get('name');
        $userId = session()->get('id');
        $role_category = session()->get('role_category');

        $residential = $userModel->getResidential($userId);
        // Counting role_users
        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
                         ->where('id', $userId)
                         ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }


        $data = [
            'role' => $role,
            'user' => $name,
            'header' => 'header testing',
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        return view('overview/overview', $data);
    }


}