<?php

namespace App\Controllers;

use App\Models\MaterialModel;
use App\Models\UserModel;

class MaterialController extends BaseController
{


    public function create($type)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');
        $role = session()->get('role');
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $user_name = session()->get('name');

        $materialModel = new MaterialModel();
        $trades = $materialModel->getTrades($company_id);
        $materials = $materialModel->getMaterial($type, $company_id);
        $measurements = $materialModel->getMeasurements();

        $residential = $userModel->getResidential($user_id);

        if($type == "trade") {         
            return view('material/create_trade', [
                'residential' => $residential,
                'user' => $user_name,
                'role' => $role,
                'materials' => $materials,
                'trades' => $trades 
            ]);


        } else 
        return view('material/create_item', [
            'residential' => $residential,
            'user' => $user_name,
            'role' => $role,
            'measurements' => $measurements,
            'trades' => $trades 
        ]); 
    }   

    // public function import(Request $request, $type) 
    // {
    //     $user       = auth()->user();
    //     $user_id    = $user->id;
    //     $res        = $user->getResidential($user->id);
    //     $company_id = $res->company_id;


    //     $title = "Import Spreadsheet";
    //     $template = url('documents/template-trade.xlsx');

    //     if($_POST) {
    //         // dd($type);
    //         if($type == "trade") {
    //             $sheet_name = "TRADE DATA";
    //             $path       = public_path('uploads'.DIRECTORY_SEPARATOR.'trade'.DIRECTORY_SEPARATOR);  
    //             $columns = [
    //                 // "A"=>"id",
    //                 "A"=>"name",
    //                 // "C"=>"company_id",
    //                 // "D"=>"address"
    //             ];
    //             $table_name = Config::get('constants.tables.trade');

    //         } else if($type == "item") {
    //             $sheet_name = "ITEM DATA";
    //             $path       = public_path('uploads'.DIRECTORY_SEPARATOR.'item'.DIRECTORY_SEPARATOR);  
    //             $columns = [                 
    //                 "A" => "name",
    //                 "B" => "description",           
    //             ];          
    //             $table_name = Config::get('constants.tables.item');

    //         } else if($type == "category") {
    //             $sheet_name = "CATEGORY DATA";
    //             $path       = public_path('uploads'.DIRECTORY_SEPARATOR.'category'.DIRECTORY_SEPARATOR);  
    //             $columns = [                 
    //                 "A" => "name",                         
    //             ];          
    //             $table_name = Config::get('constants.tables.category');

    //         }

    //         if(!file_exists($path)) {
    //             File::makeDirectory($path, $mode = 777, true, true);
    //         }

    //         $request->validate([
    //             'file1' => 'required|mimes:xlsx|max:10000'
    //         ]);
    //         $file = $request->file('file1');
    //         $name = time().'.xlsx';


    //         if ( $file->move($path, $name) ){
    //             $inputFileName  = $path.$name;
    //             $reader         = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    //             $reader->setReadDataOnly(true);
    //             $reader->setLoadSheetsOnly([$sheet_name]);
    //             $spreadSheet    = $reader->load($inputFileName);
    //             $workSheet      = $spreadSheet->getActiveSheet();
    //             $startRow       = 2;
    //             $max            = $workSheet->getHighestRow();             

    //             $data_insert    = [];

    //             for($i=$startRow; $i <= $max; $i++){
    //                 $got_data = 1;
    //                 // echo "<br>i: $i";
    //                 // $id = $workSheet->getCell("A$i")->getValue();
    //                 // if(empty( $id)||!is_numeric( $id ))continue;

    //                 $data_row = [];

    //                 $data_row['company_id'] = $company_id;                    
    //                 $data_row['create_by']  = $user_id;
    //                 $data_row['create_at']  = date("Y-m-d H:i:s");

    //                 if($type == "trade") {
    //                     $data_row['parent_id']  = 0;

    //                 } else if($type == "category") {
    //                     $data_row['parent_id']  = 0;

    //                 } 

    //                 foreach ($columns as $col=>$field) {
    //                     $val = $workSheet->getCell("$col$i")->getValue();

    //                     if($field == "name" && $val == "") {
    //                         $got_data = 0;
    //                         break;
    //                     } else {
    //                         $data_row[$field] = $val;
    //                     }                       
    //                 }                    

    //                 // print_r($data_row);
    //                 // echo "<br><br>";
    //                 if($got_data == 0) {
    //                     continue;
    //                 }

    //                 $data_insert[] = $data_row;

    //             }

    //             // dd($data_insert);
    //             // DB::table('trade')->truncate();
    //             DB::table($table_name)->insert($data_insert);

    //             return redirect('admin/material/'.$type.'/import')->with('success', 'Data imported successfully! '.$max);
    //         }
    //     }

    //      // print_r($id);
    //      $user      = auth()->user();
    //      $role      = $user->getRole($user->id);
    //      $user_id    = $user->id;

    //      $res       = $user->getResidential($user->id);
    //      $residential_id = $res->residential_id;

    //      // $count  = DB::select("SELECT COUNT(id) as count FROM role_user WHERE FIND_IN_SET($id, residential_id)"); 
    //      // // print_r($count);
    //      // $count  = $count[0]->count;
    //      // // echo 'COUNT : '.$count;
    //      // if($count == 0) {
    //      //     dd("Permission not allow for the project");
    //      //     //  return view('overview.index', compact('residential', 'user', 'role'));
    //      // }

    //     $residential = DB::select("SELECT * FROM ".Config::get('constants.tables.residential')." WHERE id IN ($residential_id) order by name asc");     

    //     return view("material.import", compact("title", "template", "residential", "role", "user"));
    // }



    public function store()
    {
        $db = \Config\Database::connect();
        $session = \Config\Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
    
        $data_row = [];
        $type = $this->request->getPost('type');
    
        if ($type == "trade") {
            $data_row = [
                'company_id' => $company_id,
                'name' => $this->request->getPost('trade_name'),
                'description' => $this->request->getPost('trade_desc'),
                'create_by' => $user_id,
                'create_at' => date("Y-m-d H:i:s"),
            ];
            $table_name = 'trade';
        } else {
            $data_row = [
                'company_id' => $company_id,
                'name' => $this->request->getPost('item_name'),
                'description' => $this->request->getPost('item_desc'),
                'unit' => $this->request->getPost('item_unit'),
                'img' => $this->request->getPost('filename'),
                'create_by' => $user_id,
                'create_at' => date("Y-m-d H:i:s"),
            ];
            $table_name = 'item';
        }
    
        $id = $db->table($table_name)->insert($data_row);
    
        if ($id) {
            $msg = 'Added new records.';
            return $this->response->setJSON(['status' => 'success', 'request' => $this->request->getPost(), 'msg' => $msg]);
        } else {
            $msg = 'Failed to add records.';
            return $this->response->setStatusCode(400)->setJSON(['status' => 'fail', 'request' => $this->request->getPost(), 'msg' => $msg]);
        }
    }
    public function show_trade()
    {

        $session = \Config\Services::session();
            $userModel = new UserModel();
            $user_id = $session->get('id');
            $role = session()->get('role');
            $res = $userModel->getCurrentUser($user_id);
            $company_id = $res->company_id;
            $user_name = session()->get('name');
    
            $materialModel = new MaterialModel();
            $materials = $materialModel->getMaterial('trade', $company_id);
            $residential = $userModel->getResidential($user_id);
    
            return view('material/material', [
                'residential' => $residential,
                'user' => $user_name,
                'role' => $role,
                'materials' => $materials,
            ]);
    }  //done

    public function getTradeList() 
    {
        $db = \Config\Database::connect();
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $recordsQuery = $db->table('trade')
        ->select('*')
        ->where('company_id', $company_id)
        ->orderBy('name', 'ASC');

        $records = $recordsQuery->get()->getResultArray();
        $data_arr = array();
        $num = 1;

        foreach ($records as $record)
        {
            $id = $record['id'];
            $name = $record['name'];
            $status = ($record['status'] == 0) ? "Inactive" : "Ok";

            $data_arr[] = array(
                "id" => '',
                "name" => $name,
                "status" => $status,
                "action"    => '<a href="trade/edit/'.$id.'" class="action-btn"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
            );

            $num++;
        }

        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);
    }//done

    public function show_item()
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');
        $role = session()->get('role');
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $user_name = session()->get('name');

        $materialModel = new MaterialModel();
        $materials = $materialModel->getMaterial('item', $company_id);
        $measurements =  $materialModel->getMeasurements();
        $residential = $userModel->getResidential($user_id);

        return view('material/material', [
            'residential' => $residential,
            'user' => $user_name,
            'role' => $role,
            'materials' => $materials,
            'measurements' =>$measurements
        ]);

    }//done

    public function getItemList()
     {
        $db = \Config\Database::connect();
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $recordsQuery = $db->table('item')
        ->select('*')
        ->where('company_id', $company_id)
        ->orderBy('name', 'ASC');

        $records = $recordsQuery->get()->getResultArray();
        $data_arr = array();
        $num = 1;

        foreach ($records as $record)
        {
            $id = $record['id'];
            $name = $record['name'];
            $status = ($record['status'] == 0) ? "Inactive" : "Ok";

            $data_arr[] = array(
                "id" => '',
                "name" => $name,
                "status" => $status,
                "action"    => '<a href="item/edit/'.$id.'" class="action-btn"><i class="fas fa-edit" data-id="'.$id.'"></i></a>'
            );

            $num++;
        }

        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);
    }//done

    // public function show_category()
    // {

    //     $session = \Config\Services::session();
    //     $userModel = new UserModel();
    //     $user_id = $session->get('id');
    //     $role = session()->get('role');
    //     $res = $userModel->getCurrentUser($user_id);
    //     $company_id = $res->company_id;
    //     $user_name = session()->get('name');

    //     $materialModel = new MaterialModel();
    //     $materials = $materialModel->getMaterial('category', $company_id);

    //     $residential = $userModel->getResidential($user_id);

    //     return view('material/material', [
    //         'residential' => $residential,
    //         'user' => $user_name,
    //         'role' => $role,
    //         'materials' => $materials,
    //     ]);
    // } done unuse

    // public function getCategoryList()
    // {
    //     $db = \Config\Database::connect();
    //     $session = \Config\Services::session();
    //     $userModel = new UserModel();
    //     $user_id = $session->get('id');
    //     $res = $userModel->getCurrentUser($user_id);
    //     $company_id = $res->company_id;

    //     $recordsQuery = $db->table('category')
    //     ->select('*')
    //     ->where('company_id', $company_id)
    //     ->orderBy('name', 'ASC');

    //     $records = $recordsQuery->get()->getResultArray();
    //     $data_arr = array();
    //     $num = 1;

    //     foreach ($records as $record)
    //     {
    //         $id = $record['id'];
    //         $name = $record['name'];
    //         $status = ($record['status'] == 0) ? "Inactive" : "Ok";

    //         $data_arr[] = array(
    //             "id" => '',
    //             "name" => $name,
    //             "status" => $status,
    //             "action" => '<a href="category/edit/' . $id . '" class="action-btn"><i class="fas fa-edit" data-id="' . $id . '"></i></a>'
    //         );

    //         $num++;
    //     }

    //     $response = [
    //         "data" => $data_arr
    //     ];

    //     return $this->response->setJSON($response);

    // } done unuse


    public function edit($type, $id)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');
        $role = session()->get('role');
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $user_name = session()->get('name');

        $materialModel = new MaterialModel();
        $trades = $materialModel->getTrades($company_id);
        $materials = $materialModel->getMaterial('category', $company_id);
        $measurements = $materialModel->getMeasurements();
        // $categories = $materialModel->getCategories($company_id);

        $residential = $userModel->getResidential($user_id);

        $db = \Config\Database::connect();

        if ($type == "trade")
        {
            $query = $db->query("SELECT * FROM trade WHERE id = $id AND company_id = $company_id");
            $material_details = $query->getRow();

            if (empty($material_details))
                return redirect()->back();

            return view('material/edit_trade', [
                'residential' => $residential,
                'user' => $user_name,
                'role' => $role,
                'materials' => $materials,
                'material_details' => $material_details,
                'trades' => $trades 
            ]);

        }
        // else if ($type == "category")
        // {
        //     $query = $db->query("SELECT * FROM category WHERE id = $id AND company_id = $company_id");
        //     $category_details = $query->getRow();

        //     if (!empty($category_details))
        //         $category_details->cat_id = 2;
        //     else
        //         return redirect()->back();

        //     return view('material/edit_category', [
        //         'residential' => $residential,
        //         'user' => $user_name,
        //         'role' => $role,
        //         'materials' => $materials,
        //         'category_details' => $category_details,              
        //         'categories' => $categories,
        //     ]);

        // }
        else if ($type == "item")
        {
            $query = $db->query("SELECT * FROM item WHERE id = $id AND company_id = $company_id");
            $item_details = $query->getRow();

            if (empty($item_details))
                return redirect()->back();

            return view('material/edit_item', [
                'residential' => $residential,
                'user' => $user_name,
                'role' => $role,
                'materials' => $materials,
                'item_details' => $item_details,
                'company_id' => $company_id,
                'measurements' => $measurements,
                'trades' => $trades 
                
            ]);
        }
    }//done


    public function update($type, $id)
    {
        $session = \Config\Services::session();
        $userModel = new UserModel();
        $user_id = $session->get('id');
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $db = \Config\Database::connect();
    
        if($type == "item") {
            $filename = $this->request->getPost('filename');
            $file = $this->request->getFile('file_data');
            $msg = "";
    
            // Add this line
            if ($file && $file->getError() !== UPLOAD_ERR_NO_FILE) {
                $folder = FCPATH.'images/'.$company_id;
                
                if(!is_dir($folder)) {
                    mkdir($folder, 0777, true);
                }
                
                $file_ext = $file->getExtension();
                $new_filename = "item_".$id.".".$file_ext;
                
                $from_path = FCPATH . 'tmp/' . $filename;
                $to_path = FCPATH.'images/'.$company_id.'/'.$new_filename;
                
                $msg = "[from_path: $from_path] [to_path: $to_path]";
                
                if(file_exists($from_path)) {
                    if(rename($from_path, $to_path)) {
                        $msg .= "\n [OK] Move file [from_path: $from_path] [to_path: $to_path]";
                    } else {
                        $msg .= "\n [FAIL] Move file [from_path: $from_path] [to_path: $to_path]";
                    }
                }
                // move file data to db only if file has been uploaded and moved
                $builder = $db->table('item'); 
                $builder->where('id', $id)
                        ->where('company_id', $company_id)
                        ->set([
                            'name' => $this->request->getPost('item_name'),
                            'description' => $this->request->getPost('item_desc'),
                            'unit' => $this->request->getPost('item_unit'),
                            'img' => $new_filename,
                            'update_by' => $user_id,
                            'update_at' => date("Y-m-d H:i:s")
                        ])
                        ->update();
            }
            else {
                // update only name, description and unit if no file has been uploaded
                $builder = $db->table('item'); 
                $builder->where('id', $id)
                        ->where('company_id', $company_id)
                        ->set([
                            'name' => $this->request->getPost('item_name'),
                            'description' => $this->request->getPost('item_desc'),
                            'unit' => $this->request->getPost('item_unit'),
                            'update_by' => $user_id,
                            'update_at' => date("Y-m-d H:i:s")
                        ])
                        ->update();
            }
        
            if($db->affectedRows() > 0) {
                $msg .= "\nThe item with ID: $id was updated successfully.";
                return $this->response->setJSON(['status' => 'success', 'msg' => $msg, 'request' => $this->request->getPost()]);
            } else {
                $msg .= "\nNo data was updated for the item with ID: $id.";
                return $this->response->setJSON(['status' => 'error', 'msg' => $msg, 'request' => $this->request->getPost()]);
            }
    
        }
        else if($type == "trade"){
            $msg = "";
            $builder = $db->table('trade'); 
            $builder->where('id', $id)
                    ->where('company_id', $company_id)
                    ->set([
                        'name' => $this->request->getPost('trade_name'),
                        'description' => $this->request->getPost('trade_desc'),
                    ])
                    ->update();
    
            if($db->affectedRows() > 0){
                $msg = 'Updated new records.';
                return $this->response->setJSON(['status' => 'success', 'request' => $this->request->getPost(), 'msg' => $msg]);
            } else {
                $msg = 'No data was updated';
                return $this->response->setJSON(['status' => 'error', 'msg' => $msg, 'request' => $this->request->getPost()]);
            }    
        }
    }
    


    public function search_material()
    {

        $userModel = new UserModel();
        $residential_id = $this->request->getVar('residential_id');
        $res = $userModel->getCurrentResidential($residential_id);
        $company_id = $res->company_id;

        $msg = "";
        $totalRecords = 0;
        $type = $this->request->getVar('type');

        $msg .= "[type: $type]";

        if ($type == "item")
        {
            $db = \Config\Database::connect();
            $builder = $db->table('item');
            $builder->where('company_id', $company_id);

            if ($this->request->getVar('search'))
            {
                $builder->groupStart(); // start grouping
                $builder->like('name', $this->request->getVar('search'));
                $builder->orLike('description', $this->request->getVar('search'));
                $builder->groupEnd(); // end grouping
            }
            $countBuilder = clone $builder; // clone the builder before getting the results
            $materials = $builder->get()->getResult();
            $totalRecords = $countBuilder->countAllResults(); // u
        }

        return $this->response->setJSON(['status' => 'success', 'total' => $totalRecords, 'msg' => $msg, 'request' => $this->request->getVar(), 'materials' => $materials]);
    }
}