<?php
namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\Controller;

class LoginController extends Controller
{
    public $role;
    public function index()
    {
        helper(['form']);
        echo view('login');
    }

    public function auth()
    {
        $session = session();
        $model = new UserModel();
        $email = $this->request->getVar('email');
        $password = $this->request->getVar('password');
        $data = $model->findUserByEmail($email);

        if ($data)
        {
            $this->role = $model->getRoleName($data['role_id']);
            $pass = $data['password'];
            $verify_pass = password_verify($password, $pass);
            if ($verify_pass)
            {
                $this->setUserSession($data);
                $session->setFlashdata('msg', $data['role_id']);
                if($data['role_id']==1|| $data['role_id']==3|| $data['role_id']==6){
                    return redirect()->to('admin/dashboard');
                 }
                 else if($data['role_id']==2){
                    return redirect()->to('site/dashboard');
                 } else if($data['role_id']==5){
                    return redirect()->to('vendor/dashboard');
                 }
              
            }
            else
            {
                $session->setFlashdata('msg', 'Wrong Password');
                return redirect()->to('/login');
            }
        }
        else
        {
            $session->setFlashdata('msg', 'Invalid Credentials');
            return redirect()->to('/login');
        }
    }


    private function setUserSession($data)
    {
        $ses_data = [
            'id' => $data['id'],
            'name' => $data['name'],
            'email' => $data['email'],
            'role_id' => $data['role_id'],
            'role' =>  $this->role,
            'logged_in' => TRUE
        ];
        session()->set($ses_data);
    }

    public function logout()
    {
        $session = session();
        $session->destroy();
        return redirect()->to('login');
    }
}