<?php


namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\Config\Services;

class InventoryController extends BaseController
{

    public function getInventoryList()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $project_id = $this->request->getVar('project_id');
        $by_status = $this->request->getVar('by_status');
        $source = $this->request->getVar('source');

        switch ($by_status)
        {
            case 'new':
                $by_status = 1;
                break;
            case 'pending':
                $by_status = 2;
                break;
            case 'po':
                $by_status = 3;
                break;
            case 'do':
                $by_status = 4;
                break;
            case 'completed':
                $by_status = 5;
                break;
            case 'rejected':
                $by_status = 6;
                break;
        }

        $recordsQuery = $db->table('inventory')
        ->select('inventory.*, item.name AS item_name, item.description')
        ->join('item', 'item.id = inventory.item_id')
        ->where('inventory.residential_id', $project_id)
        ->where('inventory.company_id', $company_id);


        $records = $recordsQuery->get()->getResultArray();
        $data_arr = [];
        $num = 1;

        $data_arr = array();
        $num = 1;

        if ($records)
        {

            foreach ($records as $record)
            {
                $fid = $record['id'];
                $unit = $record['unit'];
                $qty = $record['qty'];
                $item_id = $record['item_id'];
                $item_name = $record['item_name'];
                $description = $record['description'];
                $update_at = $record['update_at'];
                $create_by = $record['create_by'];
                $description = $record['description'];



                $data_arr[] = [
                "id" => '',
                "item_name" => $item_name,
                "desc" => $description,
                "tranx_date" => $update_at,
                "balance" => number_format($qty, 2),
                "unit" => $unit,
                "action" => '<a href="' . $project_id . '/detail?ref=' . $item_id . '" class="action-btn"><i class="fas fa-eye" data-id="' . $fid . '"></i></a>'
                ];

                $num++;
            }
        }
        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);
    }

    public function getInventoryLog()
    {


        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;


        $project_id = $this->request->getPost('project_id');
        $source = $this->request->getPost('source');
        $item_id = $this->request->getPost('item_id');
        $start_date = ($this->request->getPost('start_date') != "") ? date("Y-m-d", strtotime(str_replace('/', '-', $this->request->getPost('start_date')))) : "";
        $end_date = ($this->request->getPost('end_date') != "") ? date("Y-m-d", strtotime(str_replace('/', '-', $this->request->getPost('end_date')))) : "";

        $from_date = "";
        $to_date = "";
        $action = "";



        if ($start_date != "")
        {
            $start_date = $start_date . " 00:00:00";
        }

        if ($end_date != "")
        {
            $end_date = $end_date . " 23:59:59";
        }



        $query = $db->table('inventory_log')
        ->select('inventory_log.*, item.name AS item_name, item.description, item.unit')
        ->join('item', 'item.id = inventory_log.item_id', 'left')
        ->join('inventory', 'inventory.id = inventory_log.inventory_id', 'left')
        ->where('inventory.residential_id', $project_id)
        ->where('inventory.company_id', $company_id)
        ->where('inventory_log.item_id', $item_id);

        if (!empty($start_date))
        {
            $query->where('inventory_log.create_at >=', $start_date);
        }

        if (!empty($end_date))
        {
            $query->where('inventory_log.create_at <=', $end_date);
        }

        $records = $query->get()->getResult();

        $data_arr = [];
        $num = 1;

        if ($records)
        {
            foreach ($records as $record)
            {
                $do = $db->table('do')
                        ->select('do_no')
                        ->where('id', $record->do_id)
                        ->get()
                        ->getRow();

                $qty = (substr($record->qty, 0, 1) != "-") ? "+" . number_format($record->qty, 2) : number_format($record->qty, 2);
                $data_arr[] = [
                    "id" => '',
                    "item_name" => $record->item_name,
                    "do_no" => $do->do_no,
                    "create_at" => $record->create_at,
                    "qty" => (substr($record->qty, 0, 1) != "-") ? '<label style="color:green;">' . $qty . '</label>' : '<label style="color:red;">' . $qty . '</label>',
                    "balance" => number_format($record->last_qty, 2),
                    "unit" => $record->unit != "" ? $record->unit : "-",
                ];
                $num++;
            }
        }

        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);

    }

    public function show($id)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();


        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
             ->where('id', $userId)
             ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $residential = $userModel->getResidential($userId);


        $role_category = session()->get('role_category');
        $name = session()->get('name');
        $data = [
            'role' => $role,
            'user' => $name,
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        if (in_array('Site', $role_category))
        {
            echo view('site/inventory', $data);
        }
        else
        {
            echo view('inventory/inventory', $data);
        }
    }

    public function edit($project_id)
    {
        $db = \Config\Database::connect();
        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();
        $user = session()->get('name');
        $fid = $this->request->getVar('ref');
        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $project_id)
                         ->where('user_id', $userId)
                         ->countAll();

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $residential = $userModel->getResidential($userId);
        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }


        $inventory = $db->table('inventory')
        ->select('inventory.qty, inventory.id, item.name')
        ->join('item', 'inventory.item_id = item.id', 'left')
        ->where('inventory.company_id', $company_id)
        ->where('inventory.residential_id', $project_id)
        ->where('inventory.id', $fid)
        ->get()
        ->getFirstRow();

        return view('inventory/create_inventory', [
            'residential' => $residential,
            'user' => $user,
            'role' => $role,
            'inventory' => $inventory,
        ]);
    }

}