<?php

namespace App\Controllers;

use App\Models\UserModel;



class ImageUploadController extends BaseController
{


    public function fileUploadPost()
    {
        $project_id = $this->request->getVar('project_id');
        $file = $this->request->getFile('file');

        $userModel = new UserModel();
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $msg = "";
        if ($file->isValid() && !$file->hasMoved())
        {
            $file_ext = $file->getExtension();
            $filename_ori = $file->getName();
            $filename = md5(uniqid(rand(), true)) . '.' . $file_ext;

            $dest_path = FCPATH . 'tmp/' . $company_id . '/';
            $path = 'tmp/' . $company_id . '/' . $filename;

            $file->move($dest_path, $filename);

            if (file_exists($dest_path))
            {
                $status = "success";
                $msg .= "\nFile exist! " . $dest_path;
            }
            else
            {
                $status = "File not exists! " . $dest_path;
            }

            return $this->response->setJSON(['status' => $status, 'path' => $path, 'msg' => $msg, 'file_ext' => $file_ext, 'filename' => $filename_ori]);
        }

        return $this->response->setJSON(['status' => "No file provided"]);
    }

    public function imageUploadPost()
    {

        $rules = [
            'image' => [
                'rules' => 'uploaded[image]|mime_in[image,image/jpg,image/jpeg,image/gif,image/png,image/svg+xml,image/jfif]|max_size[image,2048]',
                'errors' => [
                    'uploaded' => 'You must upload an image.',
                    'mime_in' => 'The image must be a jpg, jpeg, png, gif, svg or jfif.',
                    'max_size' => 'The image size is too large. It should be less than 2048 KB.'
                ]
            ]
        ];

        if (!$this->validate($rules))
        {
            return $this->response->setStatusCode(400)->setJSON(['error' => $this->validator->getErrors()]);
        }
        else
        {
            $file = $this->request->getFile('image');
            $file_ext = $file->getExtension();
            $newName = date('YmdHis') . '.' . $file_ext;
            $dest_path = FCPATH . 'tmp/';
            $file->move($dest_path, $newName);

            $path = 'tmp/' . $newName;
            $fullpath = FCPATH . 'tmp/' . $newName;
            $msg = "";


            if (file_exists($fullpath))
            {
                $status = "success";
                $msg .= " File exist! " . $fullpath;
            }
            else
            {
                $status = "File not exists! " . $fullpath;
            }

            return $this->response->setJSON(['status' => $status, 'path' => $path, 'filename' => $newName, 'msg' => $msg]);
        }
    }

    public function deleteImage()
    {
        $session = \CodeIgniter\Config\Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $source = $this->request->getPost('source');
        $filename = $this->request->getPost('filename');
        $id = $this->request->getPost('id');
        $file_path = "";
        $dest_paths = [];
        if ($source == 'material_item')
        {
            $dest_paths[] = FCPATH . 'images/' . $company_id . '/' . $filename;
            $dest_paths[] = FCPATH . 'tmp/' . $filename;
        }
        else if ($source == 'vendor_do')
        {
            $dest_paths[] = FCPATH . 'document/' . $company_id . '/do/' . $filename;
            $dest_paths[] = FCPATH . 'tmp/'.$company_id .'/' . $filename;
        }

        $msg = "";
        $fileRemoved = false;

        $db = \Config\Database::connect(); // Get database connection

        foreach ($dest_paths as $dest_path)
        {
            if (file_exists($dest_path))
            {
                unlink($dest_path);
                $msg .= 'File removed from ' . $dest_path . '; ';

                // If the file was not in the tmp directory
                if (!strstr($dest_path, FCPATH . 'tmp/'))
                {
                    $fileRemoved = true;
                    if ($source == 'material_item')
                    {
                        $db->table('item')->where('id', $id)->set(['img' => ''])->update();
                        $msg .= 'removed from db ';
                    }
                    else if ($source == 'vendor_do')
                    {
                        $db->table('do')->where('id', $id)->set(['img' => ''])->update();
                        $msg .= 'removed from db ';
                    }
                }
            }
            else
            {
                $msg .= 'File not found at ' . $dest_path . '; ';
            }
        }

        if (!$fileRemoved)
        {
            return $this->response->setJSON(['status' => 'Failed to delete image.', 'request' => $this->request->getPost(), 'msg' => rtrim($msg, "; ")]);
        }

        return $this->response->setJSON(['status' => 'success', 'request' => $this->request->getPost(), 'path' => $file_path, 'msg' => rtrim($msg, "; ")]);
    }




    public function deleteFile()
    {
        $session = \CodeIgniter\Config\Services::session();
        $userModel = new UserModel();
        $project_id = $this->request->getPost('project_id');
        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
    
        $source = $this->request->getPost('source');
        $filename = $this->request->getPost('filename');
        $id = $this->request->getPost('id');
        $file_path = "";
    
        if ($source == 'do')
        {
            $file_path = FCPATH . 'document/' . $company_id . '/do/' . $filename;
        }
        else if ($source == 'po')
        {
            $file_path = FCPATH . 'document/' . $company_id . '/po/' . $filename;
        }
    
        $msg = "".$file_path;
        $fileRemoved = false;
    
        $db = \Config\Database::connect(); // Get database connection
    
        if (file_exists($file_path))
        {
            unlink($file_path);
            $msg .= 'File removed from ' . $file_path . '; ';
    
            if (!strstr($file_path, FCPATH . 'tmp/'))
            {
                $fileRemoved = true;
                if ($source == 'do')
                {
                    $db->table('do')->where('id', $id)->set(['do_file' => ''])->update();
                    $msg .= 'removed from db ';
                }
                else if ($source == 'po')
                {
                    $db->table('po')->where('id', $id)->set(['po_file' => ''])->update();
                    $msg .= 'removed from db ';
                }
            }
        }
        else
        {
            $msg .= 'File not found at ' . $file_path . '; ';
        }
    
        if (!$fileRemoved)
        {
            return $this->response->setJSON(['status' => 'Failed to delete file.', 'request' => $this->request->getPost(), 'msg' => rtrim($msg, "; ")]);
        }
    
        return $this->response->setJSON(['status' => 'success', 'request' => $this->request->getPost(), 'path' => $file_path, 'msg' => rtrim($msg, "; ")]);
    }


}