<?php


namespace App\Controllers;

use App\Models\UserModel;
use App\Models\MaterialModel;
use CodeIgniter\Config\Services;

class DeliveryOrderController extends BaseController
{


    public function getDoList()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;

        $project_id = $this->request->getVar('project_id');
        $by_status = $this->request->getVar('by_status');
        $source = $this->request->getVar('source');

        switch ($by_status)
        {
            case 'new':
                $by_status = 1;
                break;
            case 'pending':
                $by_status = 2;
                break;
            case 'po':
                $by_status = 3;
                break;
            case 'do':
                $by_status = 4;
                break;
            case 'completed':
                $by_status = 5;
                break;
            case 'rejected':
                $by_status = 6;
                break;
        }

        $recordsQuery = $db->table('do')
            ->select('do.*, users.name, users.tel, vendor.company_name as vendor')
            ->join('users', 'users.id = do.create_by', 'left')
            ->join('vendor', 'vendor.id = do.vendor_id', 'left')
            ->where('do.residential_id', $project_id)
            ->where('do.company_id', $company_id)
            // ->where('do.status', $by_status)
            ->groupBy('do.do_no');

        $records = $recordsQuery->get()->getResultArray();
        $data_arr = [];
        $num = 1;
        $user_info = "";

        if ($records)
        {

            foreach ($records as $record)
            {
                $fid = $record['id'];
                $user_info = ['name' => $record['name'], 'tel' => $record['tel']];
                $create_at = $record['create_at'];
                $accept_at = $record['accept_at'];
                $status = ($record['status'] == 1) ? "Pending" : "";
                $vendor = $record['vendor'];
                $do_no = $record['do_no'];


                switch ($record['status'])
                {
                    case '1':
                        $status = "Pending";
                        break;
                    case '2':
                        $status = "Approved";
                        break;
                    case '3':
                        $status = "PO Processed";
                        break;
                    case '4':
                        $status = "DO Processed";
                        break;
                    case '5':
                        $status = "Completed";
                        break;
                    case '6':
                        $status = "Rejected";
                        break;
                }

                $total_item = $db->table('do_item')
                ->where('do_id', $fid)
                ->countAllResults();



                $data_arr[] = [
                "id" => '',
                "do_no" => '<a class="modal-links do" data-toggle="modal" data-target="#do_form" data-id="' . $fid . '">' . $do_no . '</a>',
                "total_item" => $total_item,
                "create_by" => $user_info['name'],
                "create_at" => $create_at,
                "vendor" => $vendor,
                "status" => $status,
                ];

                $num++;
            }
        }
        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);
    }

    public function update_status($id)
    {
        $session = \Config\Services::session();
        $db = \Config\Database::connect();
        $userModel = new UserModel();
        $json = $this->request->getJSON(true);
        $project_id = $json['project_id'];
        $update_status = $json['update_status'];
        $remark = $json['remark'];
        $update_result = "";
        $status = "";
        $msg = "";
        $do_id = $id;
        $inventory_id = "";

        $res = $userModel->getCurrentResidential($project_id);
        $company_id = $res->company_id;
        $user_id = $session->get('id');
        $residential = $db->table('residential')
            ->where('id', $project_id)
            ->where('company_id', $company_id)
            ->get()
            ->getFirstRow();

        if (!$residential)
        {
            $msg = "Invalid request.";
            return $this->response->setContentType('application/json')->setBody(json_encode(['status' => 'fail', 'msg' => $msg, 'request' => $json]));
        }


        $data_row = array();

        if ($update_status == "accept")
        {
            $data_row = [
                'status' => 2,
                'accept_by' => $user_id,
                'accept_at' => date("Y-m-d H:i:s")
            ];
        }
        else if ($update_status == "reject")
        {
            $data_row = [
                'status' => 5,
                'reject_by' => $user_id,
                'reject_at' => date("Y-m-d H:i:s")
            ];
        }

        if ($remark != "")
        {
            $data_row['remark'] = "CONCAT(remark, '\n[" . strtoupper($update_status) . "] ', '{$remark}')";
        }

        $update_result = $db->table('do')->update($data_row, ['id' => $id]);

        // Accept or Reject Operation

        if ($update_status == "accept")
        {
            $do_item_list = $db->table('do_item')
                ->select('do_item.qty, do_item.remark, do_item.item_id, item.name, item.description, item.unit, item.img')
                ->join('item', 'do_item.item_id = item.id')
                ->join('do', 'do_item.do_id = do.id')
                ->where('do.id', $do_id)
                ->where('do.company_id', $company_id)
                ->where('do.residential_id', $project_id)
                ->orderBy('do_item.id', 'ASC')
                ->get()->getResult();

 
            foreach ($do_item_list as $item)
            {
                $item_id = $item->item_id;
                $item_unit = ($item->unit == "") ? "-" : $item->unit;
                $item_qty = $item->qty;

                $inventory = $db->table('inventory')
                    ->select('COUNT(*) as count, qty, id')
                    ->where('company_id', $company_id)
                    ->where('residential_id', $project_id)
                    ->where('item_id', $item_id)
                    ->get()->getRow();


                $inventory_id = $inventory->id;
                $count_item = $inventory->count;
                $last_qty = ($inventory->qty > 0) ? $inventory->qty : "0";


                $data_row = array();
                if ($count_item == 0)
                {
                    $data_row = [
                        'company_id' => $company_id,
                        'residential_id' => $project_id,
                        'item_id' => $item_id,
                        'unit' => $item_unit,
                        'qty' => $item_qty,
                        'status' => 1,
                        'create_by' => $user_id,
                        'create_at' => date("Y-m-d H:i:s")
                    ];

                    $inventory_id = $db->table('inventory')->insert($data_row);

                }
                else
                {

                    if ($inventory_id != "")
                    {
                        $db->table('inventory')
                        ->where('company_id', $company_id)
                        ->where('residential_id', $project_id)
                        ->where('id', $inventory_id)
                        ->where('item_id', $item_id)
                        ->set('qty', "qty + {$item_qty}", false) // unescaped arithmetic operation
                        ->set('update_by', $user_id)
                        ->set('update_at', date("Y-m-d H:i:s"))
                        ->update();
                    }
                }

                $data_temp = [];
                if ($inventory_id || $inventory_id != "")
                {
                    $data_temp = [
                        'inventory_id' => $inventory_id,
                        'do_id' => $do_id,
                        'item_id' => $item_id,
                        'qty' => $item_qty,
                        'last_qty' => $last_qty,
                        'type' => "add",
                        'create_by' => $user_id,
                        'create_at' => date("Y-m-d H:i:s")
                    ];

                    $db->table('inventory_log')->insert($data_temp);
                }
            }
        }

        if ($update_result)
        {
            $status = "success";
        }
        else
        {
            $status = "fail";
            $msg = "Failed to update.";
        }

        return $this->response->setJSON(['status' => $status, 'msg' => $msg, 'request' => $json, 'do_id' => $id]);
    }

    public function getDoDetail()
    {
        $db = \Config\Database::connect();
        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $project_id = $this->request->getVar('project_id');
        $do_id = $this->request->getVar('id');
        $status = "fail";

        $company_info = $db->table('company')
            ->select('company.id as company_id, company.name AS company_name, company.address AS company_addr, residential.name AS residential_name, residential.address AS residential_addr, residential.logo')
            ->join('residential', 'residential.company_id = company.id', 'left')
            ->where('company.id', $company_id)
            ->where('residential.id', $project_id)
            ->get()
            ->getResult();

        if (count($company_info) > 0)
        {
            $status = "success";
        }

        $do_detail = $db->table('do')
        ->select('do.*, users.name AS creator_name, users.tel AS creator_tel, vendor.company_name AS vendor_company, vendor.address AS vendor_addr, po.po_no')
        ->join('users', 'users.id = do.create_by', 'left')
        ->join('vendor', 'vendor.id = do.vendor_id', 'left')
        ->join('po', 'po.id = do.po_id', 'left')
        ->where('do.id', $do_id)
        ->where('do.company_id', $company_id)
        ->get()->getResultArray();

        $do_list = $db->table('do_item')
         ->select('do_item.qty, do_item.remark, do_item.item_id, do_item.id AS do_item_id, do_item.po_item_id AS po_item_id, item.name, item.description, item.unit, item.img')
         ->join('item', 'do_item.item_id = item.id', 'left')
         ->join('do', 'do_item.do_id = do.id', 'left')
         ->where('do.id', $do_id)
         ->where('do.company_id', $company_id)
         ->orderBy('item.name', 'desc')
         ->get()->getResultArray();

        return $this->response->setJSON(array('status' => $status, 'company_info' => $company_info, 'do_detail' => $do_detail, 'do_list' => $do_list));
    }

    public function show($id)
    {
        $db = \Config\Database::connect();

        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();


        $db = \Config\Database::connect();
        $builder = $db->table('users');
        $count = $builder->like('project_id', $id)
             ->where('id', $userId)
             ->countAllResults();


        if ($count == 0)
        {
            throw new \Exception("Permission not allowed for the project");
        }

        $residential = $userModel->getResidential($userId);


        $role_category = session()->get('role_category');
        $name = session()->get('name');
        $data = [
            'role' => $role,
            'user' => $name,
            'header' => 'header testing',
            'residential' => $residential,
            'role_category' => $role_category,
            'userId ' => $userId,
         ];

        if (in_array('Vendor', $role_category))
        {
            echo view('vendor/do', $data);
        }
        else
        {
            echo view('do/do', $data);
        }
    }
}