<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\UserModel;
use CodeIgniter\Config\Services;

class UserController extends BaseController
{

    public function index()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $residential_id = $res->project_id;
        $user_name = session()->get('name');
        $arr_res = explode(',', $residential_id);

        $sql = "SELECT * FROM users WHERE";
        $i = 0;
        foreach ($arr_res as $res_id)
        {
            $sql .= ($i == 0) ? " FIND_IN_SET($res_id,project_id) " : " OR FIND_IN_SET($res_id, project_id)";
            $i++;
        }
        $sql .= " ORDER BY id";
        $query = $db->query($sql);
        $result = $query->getResult();

        $temp = array();


        foreach ($result as $row)
        {
            $user_id2 = $row->id;

            $user = $db->query("SELECT users.*, roles.name as role_name FROM users LEFT JOIN roles ON users.role_id = roles.id WHERE users.id = '$user_id2' LIMIT 1 ")->getRow();
            $user->role = $user->role_name;
            $temp[] = $user;
        }

        $residential = $userModel->getResidential($user_id);
        $res_list = $db->table('residential')->where('company_id', $company_id)->where('status', '1')->get()->getResult();
        $role_list = $db->table('roles')->get()->getResult();
        $vendor_list = $db->table('vendor')->get()->getResult();

        $this->enforceLogin();

        return view('admin/users/index', ['users' => $temp, 'user' => $user_name, 'role' => $role, 'residential' => $residential, 'res_list' => $res_list, 'role_list' => $role_list, 'vendor_list' => $vendor_list]);
    }

    public function profile()
    {

        $dashboard_url = "site/dashboard";
        $userId = session()->get('id');
        $role = session()->get('role');
        $userModel = new UserModel();
        $details = $userModel->getCurrentUser($userId);

        $residential = $userModel->getResidential($userId);
        $data = [
           'user' => $details->name,
           'role' => $role,
           'details' => $details,
           'dashboard_url' => $dashboard_url,
           'residential' => $residential,
           'userId ' => $userId,
        ];


        return view('layouts/profile', $data);
    }

    public function updateProfile()
    {
        $session = session();
        $userId = $session->get('id');
        $password = $this->request->getPost('pass');
        $confirm_password = $this->request->getPost('pass_again');
        $status = "success";
        $msg = "";
    
        if (empty($password))
        {
            $msg = "Password cannot be empty.";
            return $this->response->setJSON(['status' => 'fail', 'request' => $this->request->getPost(), 'msg' => $msg]);
        }
        elseif ($password != $confirm_password)
        {
            $msg = "'New Password' and 'New Password Again' must match.";
            return $this->response->setJSON(['status' => 'fail', 'request' => $this->request->getPost(), 'msg' => $msg]);
        }
        else
        {
            $data = array(
                'updated_by' => $userId,
                'updated_at' => date("Y-m-d H:i:s"),
                'password' => password_hash($password, PASSWORD_BCRYPT)
            );
    
            $db = db_connect();
            $builder = $db->table('users'); 
            $builder->where('id', $userId);
            $builder->update($data);
        }
    
        return $this->response->setJSON(['status' => $status, 'msg' => $msg, 'request' => $this->request->getPost()]);
    }    


    public function store()
    {
        $db = \Config\Database::connect();
        $json = $this->request->getJSON(true);
        $session = Services::session();
        $user_id = $session->get('id');
        $user_email = $json['email'];
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;
        $id = "";
        $msg = "";

        $builder = $db->table('users');
        $projects = implode(',', $json['project']);
        $count = $builder->where('email', $user_email)
                         ->countAllResults();

        if ($count == 0)
        {
            $password = $this->request->getPost('password');
            $confirm_password = $this->request->getPost('confirm_password');

            if ($password == $confirm_password)
            {
                $data = [
                    'name' => $json['name'],
                    'tel' => $json['tel'],
                    'email' => $user_email,
                    'status' => $json['status'],
                    'password' => password_hash($password, PASSWORD_DEFAULT),
                    'created_by' => $user_id,
                    'created_at' => date("Y-m-d H:i:s"),
                    'project_id' => $projects,
                    'role_id' => $json['role'],
                    'vendor_id' => $json['vendor_id'],
                    'company_id' => $company_id
                ];

                $db->table('users')->insert($data);
                $id = $db->insertID();

            }
            else
            {
                $msg = "'Password' and 'Confirm password' must match.";
                return $this->response->setJSON(['status' => 'fail 1', 'request' => $this->request->getPost(), 'msg' => $msg]);
            }

        }
        else
        {
            $msg = "User already exists.";
            return $this->response->setJSON(['status' => 'fail 2', 'request' => $this->request->getPost(), 'msg' => $msg]);
        }

        return $this->response->setJSON(['status' => 'success', 'request' => $this->request->getPost(), 'user_id' => $id, 'msg' => $msg]);
    }


    public function show($user_id)
    {

        $db = \Config\Database::connect();
        $json = $this->request->getJSON(true);
        $userModel = new UserModel();
        $details = $userModel->getCurrentUser($user_id);
        $user_role = $details->role_id;
        $projects = $details->project_id;


        if (!$details)
        {

            return $this->response->setJSON(['status' => 'error', 'msg' => 'Failed to load data.']);

        }

        return $this->response->setJSON(['status' => 'success', 'request' => $json, 'user_id' => $user_id, 'projects' => $projects, 'details' => $details, 'user_role' => $user_role]);
    }

    public function getUserList()
    {
        $db = \Config\Database::connect();

        $session = Services::session();
        $user_id = $session->get('id');
        $userModel = new UserModel();
        $res = $userModel->getCurrentUser($user_id);
        $company_id = $res->company_id;



        $recordsQuery = $db->table('users')
        ->select('*')
        ->where('company_id', $company_id)
        ->orderBy('id', 'ASC');

        $records = $recordsQuery->get()->getResultArray();

        $data_arr = array();

        foreach ($records as $record)
        {
            $id = $record['id'];
            $name = $record['name'];
            $email = $record['email'];
            $tel = $record['tel'];
            $role_id = $record['role_id'];
            $project = $record['project_id'];
            $status = ($record['status'] == 0) ? "Inactive" : "Active";
            $userModel = new UserModel();
            $role = $userModel->getRoleName($role_id);


            $data_arr[] = array(
                "id" => $id,
                "name" => $name,
                "email" => $email,
                "tel" => $tel,
                "role" => $role,
                "status" => $status,
                "project" => $project,
                "action" => '<a href="#" class="action-btn" data-toggle="modal" data-target="#edit_User"><i class="fas fa-edit" data-id="' . $id . '"></i></a>',
                "record" => $record
            );
        }

        $response = [
            "data" => $data_arr
        ];

        return $this->response->setJSON($response);

    }


    public function update($id)
    {
        $session = \Config\Services::session();
        $db = \Config\Database::connect();
        $json = $this->request->getJSON(true);
        $user_id = $session->get('id');
        $status = "success";

        $builder = $db->table('users');
        $email = $builder->select('email')
                         ->where('id', $id)
                         ->get()
                         ->getRowArray()['email'];

        try
        {
            $password = $json['password'];
            $confirm_password = $json['confirm_password'];

            if ($password == $confirm_password)
            {
                $data = array();
                $data['name'] = $json['name'];
                $data['tel'] = $json['tel'];
                $data['status'] = $json['status'];
                $data['updated_by'] = $user_id;
                $data['updated_at'] = date("Y-m-d H:i:s");
                $data['role_id'] = $json['role'];
                $data['vendor_id'] = $json['vendor_id'];
                $data['project_id'] = implode(',', $json['project']);

                if ($email != $json['email'])
                {
                    $data['email'] = $json['email'];
                }

                if ($password != "" && $password == $confirm_password)
                {
                    $data['password'] = password_hash($password, PASSWORD_BCRYPT);
                }

                $builder->where('id', $id)->update($data);
            }
            else
            {
                $status = "fail"; // set status to fail
                $msg = "'Password' and 'Confirm password' must match.";
                return $this->response->setJSON(['status' => $status, 'msg' => $msg]);
            }

        }
        catch (\Exception $e)
        {
            $status = "fail";
            $errorCode = $e->getCode();
            $msg = "[ErrCode: " . $errorCode . "] Failed to update user.";
            return $this->response->setJSON(['status' => $status, 'msg' => $msg, 'e' => $e->getMessage()]);
        }

        return $this->response->setJSON(['status' => $status, 'request' => $json, 'user_id' => $id]);
    }



}