<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps
// where controller filters or CSRF protection are bypassed.
// If you don't want to define all routes, please use the Auto Routing (Improved).
// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.
// $routes->setAutoRoute(false);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', function ()
{
    return redirect()->to('login');
});
$routes->get('login', 'LoginController::index');
$routes->post('logout', 'LoginController::logout');
$routes->post('login/auth', 'LoginController::auth');

$routes->group('admin', ['filter' => 'role:Admin'], function ($routes)
{
    $routes->get('dashboard', 'Admin\AdminController::index');
    $routes->get('overview/(:num)', 'OverviewController::show/$1');

    //requisition
    $routes->get('requisition/(:num)', 'RequisitionController::show/$1');
    $routes->match(['get', 'post'], 'requisition/detail', 'RequisitionController::getRfDetail');
    $routes->match(['get', 'post'], 'requisition/list', 'RequisitionController::getRfList');
    $routes->get('requisition/(:num)/create', 'RequisitionController::create/$1');
    $routes->get('requisition/(:num)/showedit/(:num)', 'RequisitionController::showedit/$1/$2');
    $routes->put('requisition/(:num)/store', 'RequisitionController::store/$1');
    $routes->put('requisition/update/(:num)', 'RequisitionController::update/$1');
    $routes->put('requisition/update_rf', 'RequisitionController::updateRf');


    //po
    $routes->get('po/(:num)', 'PurchaseOrderController::show/$1');
    $routes->match(['get', 'post'], 'po/detail', 'PurchaseOrderController::getPoDetail');
    $routes->match(['get', 'post'], 'po/list', 'PurchaseOrderController::getPoList');
    $routes->get('po/(:num)/create', 'PurchaseOrderController::create/$1');
    $routes->get('po/(:num)/edit/(:num)', 'PurchaseOrderController::edit/$1/$2');
    $routes->match(['get', 'post'], 'po/store', 'PurchaseOrderController::store');
    $routes->match(['get', 'post'], 'po/update/(:num)', 'PurchaseOrderController::update/$1');

    //do
    $routes->get('do/(:num)', 'DeliveryOrderController::show/$1');
    $routes->match(['get', 'post'], 'do/detail', 'DeliveryOrderController::getDoDetail');
    $routes->match(['get', 'post'], 'do/list', 'DeliveryOrderController::getDoList');
    $routes->put('do/update_status/(:num)', 'DeliveryOrderController::update_status/$1');

    //materials
    $routes->post('material/search', 'MaterialController::search_material');
    $routes->get('material/trade', 'MaterialController::show_trade');
    $routes->match(['get', 'post'], 'material/trade/list', 'MaterialController::getTradeList');
    $routes->get('material/(:segment)/create', 'MaterialController::create/$1');
    $routes->post('material/(:segment)/create', 'MaterialController::store/$1');
    $routes->get('material/(:segment)/edit/(:segment)', 'MaterialController::edit/$1/$2');
    $routes->post('material/(:segment)/edit/(:segment)', 'MaterialController::edit/$1/$2');
    $routes->post('material/(:segment)/update/(:segment)', 'MaterialController::update/$1/$2');
    $routes->get('material/item', 'MaterialController::show_item');
    $routes->match(['get', 'post'], 'material/item/list', 'MaterialController::getItemList');
    $routes->match(['get', 'post'], 'material/(:segment)/import', 'MaterialController::import/$1');
    $routes->get('material/category', 'MaterialController::show_category');
    $routes->match(['get', 'post'], 'material/category/list', 'MaterialController::getCategoryList');

    //file and image
    // $routes->get('imageUpload', 'ImageUploadController::imageUpload');
    $routes->post('imageUpload/delete', 'ImageUploadController::deleteImage');
    $routes->post('imageUpload', 'ImageUploadController::imageUploadPost');
    $routes->get('fileUpload', 'ImageUploadController::imageUpload');
    $routes->post('fileUpload/delete', 'ImageUploadController::deleteFile');
    $routes->post('fileUpload', 'ImageUploadController::fileUploadPost');

    //inventory
    $routes->get('inventory/(:num)', 'InventoryController::show/$1');
    $routes->match(['get', 'post'], 'inventory/log', 'InventoryController::getInventoryLog');
    $routes->get('inventory/(:num)/detail', 'InventoryController::edit/$1');
    $routes->match(['get', 'post'], 'inventory/list', 'InventoryController::getInventoryList');

    //users
    $routes->get('users', 'Admin\UserController::index');
    $routes->match(['get', 'post'], 'users/list', 'Admin\UserController::getUserList');
    $routes->put('users/store', 'Admin\UserController::store');
    $routes->get('users/show/(:segment)', 'Admin\UserController::show/$1');
    $routes->post('users/update/(:segment)', 'Admin\UserController::update/$1');

        //profile
        $routes->match(['get', 'post'], 'profile', 'Admin\UserController::profile');
        $routes->match(['get', 'post'], 'profile/update', 'Admin\UserController::updateProfile');
    
});


$routes->group('site', ['filter' => 'role:Site'], function ($routes)
{
    $routes->get('dashboard', 'SiteController::index');
    $routes->get('overview/(:num)', 'OverviewController::show/$1');

    $routes->get('requisition/(:num)', 'RequisitionController::show/$1');
    $routes->match(['get', 'post'], 'requisition/detail', 'RequisitionController::getRfDetail');
    $routes->match(['get', 'post'], 'requisition/list', 'RequisitionController::getRfList');
    $routes->get('requisition/(:num)/create', 'RequisitionController::create/$1');
    $routes->get('requisition/(:num)/showedit/(:num)', 'RequisitionController::showedit/$1/$2');
    $routes->put('requisition/(:num)/store', 'RequisitionController::store/$1');
    $routes->put('requisition/update/(:num)', 'RequisitionController::update/$1');
    $routes->put('requisition/update_rf', 'RequisitionController::updateRf');

    //do
    $routes->get('do/(:num)', 'DeliveryOrderController::show/$1');
    $routes->match(['get', 'post'], 'do/detail', 'DeliveryOrderController::getDoDetail');
    $routes->match(['get', 'post'], 'do/list', 'DeliveryOrderController::getDoList');

    //profile
    $routes->match(['get', 'post'], 'profile', 'Admin\UserController::profile');
    $routes->match(['get', 'post'], 'profile/update', 'Admin\UserController::updateProfile');


    $routes->post('material/search', 'MaterialController::search_material');
});

$routes->group('vendor', ['filter' => 'role:Vendor'], function ($routes)
{
    $routes->get('dashboard', 'VendorController::index');

    //po
    $routes->get('po/(:num)', 'VendorController::show_po/$1');
    $routes->match(['get', 'post'], 'po/detail', 'VendorController::getPoDetail');
    $routes->match(['get', 'post'], 'po/list', 'VendorController::getPoList');
    $routes->match(['get', 'post'], 'po/update_status', 'VendorController::update_status');

    //do
    $routes->get('do/(:num)', 'VendorController::show_do/$1');
    $routes->match(['get', 'post'], 'do/detail', 'VendorController::getDoDetail');
    $routes->match(['get', 'post'], 'do/list', 'VendorController::getDoList');
    $routes->put('do/update_status/(:num)', 'VendorController::update_status/$1');
    $routes->get('do/(:num)/create', 'VendorController::create/$1');
    $routes->match(['get', 'post'], 'do/store', 'VendorController::store');
    $routes->match(['get', 'post'], 'do/update/(:num)', 'VendorController::update/$1');
    $routes->get('do/(:num)/edit/(:num)', 'VendorController::edit/$1/$2');


    //upload
    $routes->post('imageUpload/delete', 'ImageUploadController::deleteImage');
    $routes->post('imageUpload', 'ImageUploadController::imageUploadPost');
    $routes->get('fileUpload', 'ImageUploadController::imageUpload');
    $routes->post('fileUpload/delete', 'ImageUploadController::deleteFile');
    $routes->post('fileUpload', 'ImageUploadController::fileUploadPost');

    //profile
    $routes->match(['get', 'post'], 'profile', 'Admin\UserController::profile');
    $routes->match(['get', 'post'], 'profile/update', 'Admin\UserController::updateProfile');

    $routes->post('material/search', 'MaterialController::search_material');
});


/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}